/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.Q7;
import org.eclipse.rcptt.core.Q7Features;
import org.eclipse.rcptt.core.ecl.core.model.CreateReport;
import org.eclipse.rcptt.core.ecl.core.model.GetReport;
import org.eclipse.rcptt.core.ecl.core.model.PrepareEnvironment;
import org.eclipse.rcptt.core.ecl.core.model.Q7CoreFactory;
import org.eclipse.rcptt.core.ecl.core.model.ResetVerifications;
import org.eclipse.rcptt.core.ecl.core.model.SetCommandsDelay;
import org.eclipse.rcptt.core.ecl.core.model.SetQ7Features;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.Sequence;
import org.eclipse.rcptt.ecl.core.util.ECLBinaryResourceImpl;
import org.eclipse.rcptt.ecl.core.util.ScriptletFactory;
import org.eclipse.rcptt.ecl.parser.ScriptErrorStatus;
import org.eclipse.rcptt.internal.launching.EclStackTrace;
import org.eclipse.rcptt.internal.launching.Executable;
import org.eclipse.rcptt.internal.launching.ExecutionStatus;
import org.eclipse.rcptt.internal.launching.GroupExecutable;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.internal.launching.ScenarioExecutable;
import org.eclipse.rcptt.internal.launching.ecl.EclScenarioExecutable;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.Q7LaunchUtils;
import org.eclipse.rcptt.parameters.ParametersFactory;
import org.eclipse.rcptt.parameters.ResetParams;
import org.eclipse.rcptt.reporting.ItemKind;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.ReportingFactory;
import org.eclipse.rcptt.reporting.ResultStatus;
import org.eclipse.rcptt.reporting.core.ReportHelper;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.ReportContainer;
import org.eclipse.rcptt.sherlock.core.streams.SherlockReportSession;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;

public class PrepareExecutionWrapper
extends Executable {
    private final AutLaunch launch;
    private final Executable executable;
    private IStatus resultStatus;
    private boolean terminated;
    private boolean failed;
    private long time;
    private SherlockReportSession reportSession;
    private String resultReportID;
    private static final Map<IQ7Element.HandleType, ItemKind> typeMapping = new HashMap<IQ7Element.HandleType, ItemKind>();

    static {
        typeMapping.put(IQ7Element.HandleType.Context, ItemKind.CONTEXT);
        typeMapping.put(IQ7Element.HandleType.TestCase, ItemKind.TESTCASE);
        typeMapping.put(IQ7Element.HandleType.TestSuite, ItemKind.TEST_SUITE);
        typeMapping.put(IQ7Element.HandleType.Verification, ItemKind.VERIFICATION);
    }

    public PrepareExecutionWrapper(AutLaunch launch, Executable executable) {
        super(executable.isDebug());
        this.launch = launch;
        this.executable = executable;
    }

    public Executable getExecutable() {
        return this.executable;
    }

    @Override
    public AutLaunch getAut() {
        return this.launch;
    }

    @Override
    public void startLaunching() {
        this.executable.startLaunching();
    }

    @Override
    public Report getResultReport() {
        if (this.resultReportID != null && this.reportSession != null) {
            return this.reportSession.getReport(this.resultReportID);
        }
        return null;
    }

    @Override
    public IStatus execute() throws InterruptedException {
        block10: {
            this.launch.resetState();
            PrepareEnvironment prepareEnvironment = Q7CoreFactory.eINSTANCE.createPrepareEnvironment();
            SetCommandsDelay commandsDelay = Q7CoreFactory.eINSTANCE.createSetCommandsDelay();
            commandsDelay.setDelay(Q7.INSTANCE.getCommandsExecutionDelay());
            TeslaFeatures.getInstance().getOption("org.eclipse.rcptt.tesla.ecl.execution.delay").setValue(Integer.toString(commandsDelay.getDelay()));
            SetQ7Features setQ7Features = Q7CoreFactory.eINSTANCE.createSetQ7Features();
            Q7LaunchUtils.setQ7Variable(setQ7Features, "current_test", this.getName());
            TeslaFeatures.getInstance().storeValues((List)setQ7Features.getFeatures());
            Q7Features.getInstance().storeValues((List)setQ7Features.getFeatures());
            Sequence command = ScriptletFactory.seq((Command[])new Command[]{prepareEnvironment, commandsDelay, setQ7Features});
            long startTime = System.currentTimeMillis();
            this.failed = false;
            try {
                this.launch.execute((Command)command);
                this.resetParams();
                this.resetVerifications();
            }
            catch (CoreException e) {
                this.resultStatus = e.getStatus();
                this.time = System.currentTimeMillis() - startTime;
                break block10;
            }
            catch (Exception e) {
                try {
                    this.resultStatus = Q7LaunchingPlugin.createStatus(e.getMessage(), e);
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.time = System.currentTimeMillis() - startTime;
                }
            }
            this.time = System.currentTimeMillis() - startTime;
        }
        if (this.resultStatus != null) {
            this.failed = true;
        }
        try {
            this.createReport();
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return this.executable.execute();
    }

    private Report getReport() throws CoreException, InterruptedException {
        Q7Info info;
        GetReport getReport = Q7CoreFactory.eINSTANCE.createGetReport();
        Object object = this.launch.execute((Command)getReport);
        Report resultReport = null;
        if (object instanceof Report) {
            resultReport = (Report)object;
        } else if (object instanceof ReportContainer) {
            ZipInputStream zin = new ZipInputStream(new ByteArrayInputStream(((ReportContainer)object).getContent()));
            try {
                zin.getNextEntry();
                ECLBinaryResourceImpl res = new ECLBinaryResourceImpl();
                res.load((InputStream)zin, null);
                EObject object2 = (EObject)res.getContents().get(0);
                if (!(object2 instanceof Report)) {
                    throw this.invalidObjectStatus(object2);
                }
                resultReport = (Report)object2;
            }
            catch (Exception e) {
                throw new CoreException(Q7LaunchingPlugin.createStatus(e.getMessage(), e));
            }
        } else {
            throw this.invalidObjectStatus(object);
        }
        if (resultReport != null && (info = ReportHelper.getInfoOnly((Node)resultReport.getRoot())) != null) {
            info.getVariant().clear();
            info.getVariant().addAll(this.getVariantName());
        }
        return resultReport;
    }

    private CoreException invalidObjectStatus(Object o) {
        return new CoreException(Q7LaunchingPlugin.createStatus("Expect Report object, but found: " + o));
    }

    private void resetParams() throws CoreException, InterruptedException {
        ResetParams cmd = ParametersFactory.eINSTANCE.createResetParams();
        this.launch.execute((Command)cmd);
    }

    private void resetVerifications() throws CoreException, InterruptedException {
        ResetVerifications cmd = Q7CoreFactory.eINSTANCE.createResetVerifications();
        this.launch.execute((Command)cmd);
    }

    private void createReport() throws CoreException, InterruptedException {
        CreateReport createReport = Q7CoreFactory.eINSTANCE.createCreateReport();
        String name = this.getName();
        Executable parent = this.getParent();
        while (parent != null) {
            name = String.valueOf(parent.getName()) + "/" + name;
            parent = parent.getParent();
        }
        createReport.setName(name);
        createReport.setQ7info(PrepareExecutionWrapper.getQ7Info(this.executable));
        this.launch.execute((Command)createReport);
    }

    public static Q7Info getQ7Info(Executable executable) {
        IQ7NamedElement element = executable.getActualElement();
        return PrepareExecutionWrapper.getQ7Info(element);
    }

    public static Q7Info getQ7Info(IQ7NamedElement element) {
        Q7Info info = ReportingFactory.eINSTANCE.createQ7Info();
        info.setType(typeMapping.get(element.getElementType()));
        try {
            info.setDescription(element.getDescription());
            info.setId(element.getID());
            info.setTags(element.getTags());
        }
        catch (ModelException e) {
            Q7LaunchingPlugin.log("Error getting RCPTT information", e);
        }
        return info;
    }

    @Override
    public Executable[] getChildren() {
        return this.executable.getChildren();
    }

    @Override
    public int getStatus() {
        if (this.failed) {
            return 3;
        }
        return this.executable.getStatus();
    }

    @Override
    public boolean isTerminated() {
        if (this.terminated) {
            return true;
        }
        return this.executable.isTerminated();
    }

    @Override
    public void terminate(boolean user) {
        this.terminated = true;
        this.executable.terminate(user);
    }

    @Override
    public IQ7NamedElement getActualElement() {
        return this.executable.getActualElement();
    }

    @Override
    public String getName() {
        return this.executable.getName();
    }

    @Override
    public IStatus getResultStatus() {
        if (this.resultStatus != null) {
            return this.resultStatus;
        }
        return this.executable.getResultStatus();
    }

    @Override
    public long getTime() {
        return this.time + this.executable.getTime();
    }

    @Override
    public int getType() {
        return this.executable.getType();
    }

    private static void closeAllNodes(long endTime, Node node) {
        if (node.getEndTime() == 0L) {
            node.setEndTime(endTime);
        }
        for (Node child : node.getChildren()) {
            PrepareExecutionWrapper.closeAllNodes(endTime, child);
        }
    }

    @Override
    public void postExecute() {
        try {
            Report resultReport = this.getReport();
            Node root = resultReport.getRoot();
            PrepareExecutionWrapper.closeAllNodes(root.getStartTime() + this.getTime(), root);
            Q7Info rootInfo = ReportHelper.getInfo((Node)root);
            switch (this.getStatus()) {
                case 1: 
                case 2: 
                case 3: {
                    rootInfo.setResult(ResultStatus.FAIL);
                    break;
                }
                case 0: {
                    rootInfo.setResult(ResultStatus.PASS);
                }
            }
            Executable[] executableArray = this.getChildren();
            int n = executableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Executable ch = executableArray[n2];
                if (ch instanceof ScenarioExecutable) {
                    rootInfo.setId(ch.getId());
                    break;
                }
                ++n2;
            }
            IStatus rs = this.getResultStatus();
            if (!rs.isOK()) {
                if (rs instanceof ExecutionStatus) {
                    IStatus cause = ((ExecutionStatus)rs).getCause(true);
                    if (cause == null && rs.getSeverity() == 8) {
                        rootInfo.setMessage(rs.getMessage());
                    }
                    if (cause instanceof ScriptErrorStatus) {
                        rootInfo.setMessage(EclStackTrace.fromExecStatus((ExecutionStatus)rs).print());
                    }
                } else {
                    rootInfo.setMessage(rs.getMessage());
                }
            }
            if (this.reportSession != null) {
                this.resultReportID = this.reportSession.write(resultReport);
            }
        }
        catch (CoreException e) {
            this.resultStatus = e.getStatus();
        }
        catch (InterruptedException e) {
            this.resultStatus = Q7LaunchingPlugin.createStatus(e.getMessage(), e);
        }
    }

    public void setReportSession(SherlockReportSession reportSession) {
        this.reportSession = reportSession;
    }

    public List<String> getVariantName() {
        Executable ex;
        Executable exx = this.getExecutable();
        if (exx instanceof GroupExecutable && (ex = ((GroupExecutable)exx).getRoot()) instanceof EclScenarioExecutable) {
            return ((EclScenarioExecutable)ex).getVariantName();
        }
        return Collections.emptyList();
    }
}

