/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.reporting.ItemKind;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.Q7Statistics;
import org.eclipse.rcptt.reporting.ReportingFactory;
import org.eclipse.rcptt.reporting.ResultStatus;
import org.eclipse.rcptt.reporting.core.Q7ReportIterator;
import org.eclipse.rcptt.sherlock.core.model.sherlock.EclipseStatus;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Event;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.EventSource;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.ReportFactory;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Screenshot;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Snaphot;
import org.eclipse.rcptt.sherlock.core.reporting.SimpleReportGenerator;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.utils.AdvancedInformationGenerator;

public class ReportUtils {
    public static Q7Statistics calculateStatistics(Q7ReportIterator iterator) {
        return ReportUtils.calculateStatistics(iterator.iterator());
    }

    public static Q7Statistics calculateStatistics(Iterator<Report> iterator) {
        Q7Statistics statistics = ReportingFactory.eINSTANCE.createQ7Statistics();
        long startTime = Long.MAX_VALUE;
        long endTime = Long.MIN_VALUE;
        long totalTime = 0L;
        int total = 0;
        int failed = 0;
        int passed = 0;
        int skipped = 0;
        while (iterator.hasNext()) {
            Report report = iterator.next();
            if (report == null) {
                return null;
            }
            ++total;
            Node localRoot = report.getRoot();
            if (!localRoot.getProperties().containsKey((Object)"q7")) continue;
            Q7Info q7info = (Q7Info)localRoot.getProperties().get((Object)"q7");
            switch (q7info.getResult()) {
                case FAIL: 
                case WARN: {
                    ++failed;
                    break;
                }
                case PASS: {
                    ++passed;
                    break;
                }
                case SKIPPED: {
                    ++skipped;
                }
            }
            startTime = Math.min(startTime, localRoot.getStartTime());
            endTime = Math.max(endTime, localRoot.getEndTime());
            totalTime += localRoot.getEndTime() - localRoot.getStartTime();
        }
        statistics.setTime((int)totalTime);
        statistics.setTotal(total);
        statistics.setFailed(failed);
        statistics.setPassed(passed);
        statistics.setSkipped(skipped);
        return statistics;
    }

    public static Report combineReports(Q7ReportIterator iterator, int len, IProgressMonitor monitor) {
        monitor.beginTask("Combine Q7 testcase reports", len * 10);
        Report report = ReportFactory.eINSTANCE.createReport();
        Node rootNode = ReportFactory.eINSTANCE.createNode();
        report.setRoot(rootNode);
        iterator.reset();
        while (iterator.hasNext()) {
            Report copy = iterator.next();
            HashMap<EventSource, EventSource> toUpdate = new HashMap<EventSource, EventSource>();
            EList copySources = copy.getSources();
            EList sources = report.getSources();
            ArrayList<EventSource> repSources = new ArrayList<EventSource>();
            for (EventSource source : copySources) {
                boolean exist = false;
                for (EventSource rootSource : sources) {
                    if (!ReportUtils.compareSources(source, rootSource)) continue;
                    toUpdate.put(source, rootSource);
                    exist = true;
                    break;
                }
                if (exist) continue;
                repSources.add(source);
            }
            sources.addAll(repSources);
            for (EventSource source : toUpdate.keySet()) {
                ReportUtils.updateSource(copy, source, (EventSource)toUpdate.get(source));
            }
            rootNode.getChildren().add((Object)copy.getRoot());
            monitor.worked(10);
        }
        monitor.done();
        return report;
    }

    private static boolean compareSources(EventSource source, EventSource rootSource) {
        if (source == null || rootSource == null) {
            return false;
        }
        EMap properties = source.getProperties();
        EMap properties2 = rootSource.getProperties();
        if (properties.size() != properties2.size()) {
            return false;
        }
        Set keySet = properties.keySet();
        for (String s : keySet) {
            EObject v2;
            EObject v1 = (EObject)properties.get((Object)s);
            if (EcoreUtil.equals((EObject)v1, (EObject)(v2 = (EObject)properties2.get((Object)s)))) continue;
            return false;
        }
        return true;
    }

    private static void updateSource(Report copy, EventSource source, EventSource rootSource) {
        TreeIterator contents = copy.eAllContents();
        ArrayList<Event> eventsToUpdate = new ArrayList<Event>();
        while (contents.hasNext()) {
            EventSource eSource;
            EObject next = (EObject)contents.next();
            if (!(next instanceof Event) || (eSource = ((Event)next).getSource()) == null || !source.equals(eSource)) continue;
            eventsToUpdate.add((Event)next);
        }
        for (Event event : eventsToUpdate) {
            event.setSource(rootSource);
        }
    }

    public static String getScenarioTags(Node item) {
        EList children = item.getChildren();
        for (Node node : children) {
            Q7Info info = (Q7Info)node.getProperties().get((Object)"q7");
            if (info == null || info.getType() != ItemKind.SCRIPT) continue;
            return info.getTags();
        }
        return null;
    }

    public static String getScenarioDescription(Node item) {
        EList children = item.getChildren();
        for (Node node : children) {
            Q7Info info = (Q7Info)node.getProperties().get((Object)"q7");
            if (info == null || info.getType() != ItemKind.SCRIPT) continue;
            return info.getDescription();
        }
        return null;
    }

    public static boolean isLoggedCommand(String name) {
        return ReportUtils.isTraceCommand(name) || ReportUtils.isScreenshotCommand(name);
    }

    public static boolean isTraceCommand(String name) {
        return name.equals("trace");
    }

    public static boolean isScreenshotCommand(String name) {
        return name.equals("take-screenshot");
    }

    public static final String formatTime(long duration) {
        return String.format("%d.%03d", duration / 1000L, duration % 1000L);
    }

    public static String replaceEscapeSymbols(String text) {
        if (text == null) {
            return null;
        }
        return text.replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public static List<Screenshot> findScreenshots(Node node) {
        ArrayList<Screenshot> result = new ArrayList<Screenshot>();
        ReportUtils.collectScreenshots(node, result);
        return result;
    }

    private static void collectScreenshots(Node node, List<Screenshot> acc) {
        for (Snaphot snapshot : node.getSnapshots()) {
            if (!(snapshot.getData() instanceof Screenshot)) continue;
            acc.add((Screenshot)snapshot.getData());
        }
        for (Node child : node.getChildren()) {
            ReportUtils.collectScreenshots(child, acc);
        }
    }

    public static String getFailMessage(Node item) {
        StringBuilder result = new StringBuilder();
        EList children = item.getChildren();
        Q7Info current = (Q7Info)item.getProperties().get((Object)"q7");
        if (current != null && current.getResult().equals((Object)ResultStatus.FAIL) && current.getMessage() != null) {
            return current.getMessage();
        }
        for (Node node : children) {
            String message = ReportUtils.getFailMessage(node);
            if (message == null || message.isEmpty()) continue;
            return message;
        }
        return result.toString();
    }

    public static String replaceHtmlEntities(String string) {
        string = string.replace("&", "&amp;");
        string = string.replace("<", "&lt;");
        string = string.replace(">", "&gt;");
        return string;
    }

    public static String replaceLineBreaks(String string) {
        string = string.replace("\r\n", "<br />");
        string = string.replace("\n", "<br />");
        string = string.replace("\r", "<br />");
        return string;
    }

    private static void collectFailures(Node item, StringBuilder result) {
        String msg;
        Q7Info info = (Q7Info)item.getProperties().get((Object)"q7");
        if (info != null && info.getResult().equals((Object)ResultStatus.FAIL) && (msg = info.getMessage()) != null) {
            result.append(msg).append("\n");
        }
        EList children = item.getChildren();
        for (Node node : children) {
            ReportUtils.collectFailures(node, result);
        }
    }

    public static String getDetails(Node item) {
        StringBuilder builder = new StringBuilder();
        ReportUtils.collectDetails(item, builder);
        return ReportUtils.maskIllegalChars(builder.toString());
    }

    private static String maskIllegalChars(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        return str.replace("\u0000", "\\0").replace("]]>", "]] >");
    }

    public static String combineNames(EList<String> list, String separator) {
        if (list == null || separator == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < list.size()) {
            sb.append((String)list.get(i));
            if (i < list.size() - 1) {
                sb.append(separator);
            }
            ++i;
        }
        return sb.toString();
    }

    public static void collectDetails(Node item, StringBuilder result) {
        EList snapshots = item.getSnapshots();
        for (Snaphot snaphot : snapshots) {
            Iterator data = snaphot.getData();
            if (data == null) continue;
            if (data instanceof AdvancedInformation) {
                result.append(new AdvancedInformationGenerator().generateContent((AdvancedInformation)data));
                result.append("\n");
                continue;
            }
            new SimpleReportGenerator().toString(result, 2, (EObject)data, new String[0]);
            result.append("\n");
        }
        EList events = item.getEvents();
        for (Event event : events) {
            if (!(event.getData() instanceof EclipseStatus)) continue;
            EclipseStatus data = (EclipseStatus)event.getData();
            new SimpleReportGenerator().toString(result, 1, (EObject)data, new String[0]);
            result.append("\n");
        }
        EList children = item.getChildren();
        for (Node node : children) {
            ReportUtils.collectDetails(node, result);
        }
    }
}

