/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.testing;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.pde.internal.launching.PreferenceInitializer;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.ext.Q7TargetPlatformManager;
import org.eclipse.rcptt.internal.launching.ext.UpdateVMArgs;
import org.eclipse.rcptt.launching.Aut;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.AutManager;
import org.eclipse.rcptt.launching.ext.Q7LaunchingUtil;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.rcptt.testing.commands.InvokeAUT;

public class InvokeAUTService
implements ICommandService {
    private static String eclipseLocation = null;

    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        AutLaunch launch;
        InvokeAUT cmd;
        String name;
        Aut aut;
        if (Platform.getOS().equals("macosx")) {
            new PreferenceInitializer().initializeDefaultPreferences();
        }
        if ((aut = AutManager.INSTANCE.getByName(name = (cmd = (InvokeAUT)command).getName())) == null) {
            aut = this.createAut(cmd);
        }
        if ((launch = aut.getActiveLaunch()) == null) {
            launch = aut.launch((IProgressMonitor)new NullProgressMonitor());
        }
        return Status.OK_STATUS;
    }

    private Aut createAut(InvokeAUT cmd) throws CoreException {
        InvokeAUTService.updateEclipseLocation();
        if (eclipseLocation == null) {
            throw new CoreException(RcpttPlugin.createStatus((String)"Failed to launch selfAUT. ${eclipse_home} variable is not resolved..."));
        }
        ITargetPlatformHelper platform = Q7TargetPlatformManager.createTargetPlatform((String)eclipseLocation, (IProgressMonitor)new NullProgressMonitor(), (boolean)false);
        ILaunchConfigurationWorkingCopy launch = Q7LaunchingUtil.createLaunchConfiguration((ITargetPlatformHelper)platform, (String)cmd.getName());
        launch.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "-os ${target.os} -arch ${target.arch} -nl ${target.nl} -consoleLog " + cmd.getArgs() + " -data " + RcpttPlugin.getDefault().getStateLocation().append("self_aut_") + System.currentTimeMillis());
        launch.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", null);
        launch.setAttribute("org.eclipse.debug.core.capture_output", null);
        String vmArgs = platform.getIniVMArgs();
        vmArgs = vmArgs == null ? LaunchArgumentsHelper.getInitialVMArguments().trim() : vmArgs.trim();
        if (vmArgs != null && vmArgs.length() > 0) {
            vmArgs = UpdateVMArgs.updateAttr((String)vmArgs);
            launch.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs);
        }
        launch.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, this.getVMArgs(cmd, platform));
        ILaunchConfiguration config = launch.doSave();
        return AutManager.INSTANCE.getByLaunch(config);
    }

    private String getVMArgs(InvokeAUT cmd, ITargetPlatformHelper platform) {
        if (cmd.getVmargs() != null) {
            return cmd.getVmargs();
        }
        String vmArgs = platform.getIniVMArgs();
        vmArgs = vmArgs == null ? LaunchArgumentsHelper.getInitialVMArguments().trim() : vmArgs.trim();
        if (vmArgs != null && vmArgs.length() > 0) {
            vmArgs = UpdateVMArgs.updateAttr((String)vmArgs);
        }
        return vmArgs;
    }

    public static void updateEclipseLocation() {
        if (eclipseLocation != null) {
            return;
        }
        IStringVariableManager vars = VariablesPlugin.getDefault().getStringVariableManager();
        IDynamicVariable var = vars.getDynamicVariable("eclipse_home");
        try {
            String value = var.getValue(null);
            if (new File(value).exists()) {
                eclipseLocation = value;
            }
        }
        catch (CoreException coreException) {}
    }
}

