/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.report.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.ResultStatus;
import org.eclipse.rcptt.reporting.core.Q7ReportIterator;
import org.eclipse.rcptt.reporting.internal.ReportUtils;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.reporting.SimpleReportGenerator;
import org.eclipse.rcptt.ui.controls.AbstractEmbeddedComposite;
import org.eclipse.rcptt.ui.launching.TimeFormatHelper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class TestCasesComposite
extends AbstractEmbeddedComposite {
    private Composite control;
    private Q7ReportIterator iterator;
    private List<ReportEntry> entries = new ArrayList<ReportEntry>();

    protected void fillActions(IToolBarManager manager) {
    }

    public TestCasesComposite(Q7ReportIterator iterator) {
        this.iterator = iterator;
        this.iterator.reset();
        while (this.iterator.hasNext()) {
            Report next = this.iterator.next();
            if (next == null) break;
            ReportEntry re = new ReportEntry();
            Node root = next.getRoot();
            re.name = root.getName();
            re.time = (int)(root.getEndTime() - root.getStartTime());
            EMap properties = root.getProperties();
            Q7Info info = (Q7Info)properties.get((Object)"q7");
            if (info == null) continue;
            StringBuilder details = new StringBuilder();
            String fail = ReportUtils.getFailMessage((Node)root);
            if (fail.length() > 0) {
                details.append(fail).append("\n");
            }
            ReportUtils.collectDetails((Node)root, (StringBuilder)details);
            if (details.length() > 0) {
                re.warning = true;
            }
            re.message = new SimpleReportGenerator().generateContent(next);
            re.status = info.getResult().getLiteral();
            re.id = info.getId();
            this.entries.add(re);
        }
    }

    public String getName() {
        return "Test cases";
    }

    public Image getImage() {
        return Images.getImage((String)"icons/file.gif");
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.control = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.control);
        GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).applyTo(this.control);
        TableViewer viewer = new TableViewer(this.control, 536939264);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 100).applyTo(viewer.getControl());
        TableColumn testcaseColumn = new TableColumn(table, 0);
        testcaseColumn.setText("Test case");
        testcaseColumn.setWidth(400);
        TableColumn statusColumn = new TableColumn(table, 0);
        statusColumn.setText("Status");
        statusColumn.setWidth(60);
        TableColumn timeColumn = new TableColumn(table, 0);
        timeColumn.setText("Time");
        timeColumn.setWidth(80);
        TableColumn detColumn = new TableColumn(table, 0);
        detColumn.setText("Details");
        detColumn.setWidth(20);
        viewer.setLabelProvider((IBaseLabelProvider)new ReportEntryLabelProvider());
        viewer.setContentProvider((IContentProvider)new ReportEntryContentProvider());
        viewer.setInput(this.entries);
        viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ReportEntry element = (ReportEntry)selection.getFirstElement();
                if (element != null) {
                    TestCasesComposite.this.doOpen(element.id, element.name);
                }
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ReportEntry element = (ReportEntry)selection.getFirstElement();
                if (element != null) {
                    TestCasesComposite.this.doSelection(element.id, element.name, element.message);
                }
            }
        });
    }

    protected void doSelection(String id, String name, String msg) {
    }

    protected void doOpen(String id, String title) {
    }

    public Control getControl() {
        return this.control;
    }

    private class ReportEntry {
        public String name;
        public String id;
        public int time;
        public String status;
        public String message;
        public boolean warning = false;

        private ReportEntry() {
        }
    }

    private class ReportEntryContentProvider
    implements IStructuredContentProvider {
        private ReportEntryContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return TestCasesComposite.this.entries.toArray();
        }
    }

    private class ReportEntryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ReportEntryLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ReportEntry entry = (ReportEntry)element;
            if (columnIndex == 0) {
                if (entry.status.equals(ResultStatus.FAIL.getLiteral())) {
                    return Images.getImage((String)"icons/launching/testerr.gif");
                }
                if (entry.status.equals(ResultStatus.PASS.getLiteral())) {
                    return Images.getImage((String)"icons/launching/testok.gif");
                }
                if (entry.status.equals(ResultStatus.SKIPPED.getLiteral())) {
                    return Images.getImage((String)"icons/scenario.gif");
                }
            }
            if (columnIndex == 3 && entry.warning) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ReportEntry entry = (ReportEntry)element;
            switch (columnIndex) {
                case 0: {
                    return entry.name;
                }
                case 1: {
                    return entry.status;
                }
                case 2: {
                    return TimeFormatHelper.format((long)entry.time);
                }
            }
            return "";
        }
    }
}

