/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.projectsettings;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.ProjectMetadata;
import org.eclipse.rcptt.internal.ui.HookUtils;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.controls.ContextsTable;
import org.eclipse.rcptt.ui.controls.DescriptionComposite;
import org.eclipse.rcptt.ui.controls.SectionWithToolbar;
import org.eclipse.rcptt.ui.controls.VerificationsTable;
import org.eclipse.rcptt.ui.editors.IQ7NamedElementEditorPage;
import org.eclipse.rcptt.ui.editors.NamedElementEditor;
import org.eclipse.rcptt.ui.editors.projectsettings.Q7ProjectEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class Q7ProjectEditorPage
extends FormPage
implements IQ7NamedElementEditorPage {
    private ContextsTable contextTable;
    private Section contextSection;
    private DescriptionComposite descriptionComposite;
    private Section descriptionSection;
    private VerificationsTable verificationsTable;
    private Section verificationSection;

    public Q7ProjectEditorPage(NamedElementEditor editor) {
        super((FormEditor)editor, "metadata", "RCPTT Project Description");
    }

    public ContextsTable getContextTable() {
        return this.contextTable;
    }

    public VerificationsTable getVerificationsTable() {
        return this.verificationsTable;
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        form.setText("Project Settings");
        form.setImage(Images.getImage("icons/q7.png"));
        FormToolkit toolkit = managedForm.getToolkit();
        Composite parent = form.getBody();
        GridLayoutFactory.swtDefaults().equalWidth(true).applyTo(parent);
        this.descriptionComposite = new DescriptionComposite((NamedElement)this.getElement()){

            @Override
            public void createControl(Composite parent) {
                super.createControl(parent);
            }
        };
        this.descriptionSection = new SectionWithToolbar(this.descriptionComposite, 322).create(parent, toolkit);
        try {
            this.contextTable = new ContextsTable(this.getModel()){

                @Override
                public String getName() {
                    return "Default Contexts";
                }
            };
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
        }
        this.contextSection = new SectionWithToolbar(this.contextTable, 322).create(parent, toolkit);
        GridDataFactory.fillDefaults().hint(-1, 300).grab(true, true).applyTo((Control)this.contextSection);
        GridDataFactory.fillDefaults().hint(-1, 300).grab(true, true).applyTo((Control)this.descriptionSection);
        try {
            this.verificationsTable = new VerificationsTable(this.getModel()){

                @Override
                public String getName() {
                    return "Default Verifications";
                }
            };
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
        }
        this.verificationSection = new SectionWithToolbar(this.verificationsTable, 322).create(parent, toolkit);
        GridDataFactory.fillDefaults().hint(-1, 300).grab(true, true).applyTo((Control)this.verificationSection);
        GridDataFactory.fillDefaults().hint(-1, 300).grab(true, true).applyTo((Control)this.contextSection);
        GridDataFactory.fillDefaults().hint(-1, 300).grab(true, true).applyTo((Control)this.descriptionSection);
        this.getEditor().createActions();
    }

    @Override
    public NamedElementEditor getEditor() {
        return (NamedElementEditor)super.getEditor();
    }

    public IQ7ProjectMetadata getModel() {
        return (IQ7ProjectMetadata)this.getEditor().getModel();
    }

    public ProjectMetadata getElement() {
        return (ProjectMetadata)this.getEditor().getElement();
    }

    @Override
    public void elementChangedEvent() {
    }

    public void updateContent() {
    }

    public void refreshPage() {
    }

    public boolean canUndo() {
        if (this.descriptionComposite.getDescriptionControl().isFocusControl()) {
            return this.descriptionComposite.canUndo();
        }
        return false;
    }

    public boolean canRedo() {
        if (this.descriptionComposite.getDescriptionControl().isFocusControl()) {
            return this.descriptionComposite.canRedo();
        }
        return false;
    }

    public void undo() {
        if (this.descriptionComposite.getDescriptionControl().isFocusControl()) {
            this.descriptionComposite.undo();
        }
    }

    public void redo() {
        if (this.descriptionComposite.getDescriptionControl().isFocusControl()) {
            this.descriptionComposite.redo();
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ((Q7ProjectEditor)Q7ProjectEditorPage.this.getEditor()).updateEnablement();
                Q7ProjectEditorPage.this.getEditor().activateActions();
            }
        };
        HookUtils.textHook(parent, r, new FocusListener(){

            public void focusGained(FocusEvent e) {
                Q7ProjectEditorPage.this.getEditor().updateEnablement();
                Q7ProjectEditorPage.this.getEditor().activateActions();
            }

            public void focusLost(FocusEvent e) {
                Q7ProjectEditorPage.this.getEditor().deactivateActions();
            }
        });
        ((Q7ProjectEditor)this.getEditor()).updateEnablement();
    }
}

