/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.preferences;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rcptt.core.Q7Features;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.utils.AbstractFeatureManager;
import org.eclipse.rcptt.ui.preferences.FeaturesComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FeaturesConfigurationDialog
extends Dialog {
    private FeaturesComposite features = new FeaturesComposite();
    private static final int RUNNER_OPTIONS_ID = 1025;
    private static final List<String> DISABLED_OPTIONS = Arrays.asList("org.eclipse.rcptt.tesla.protocol.version");
    private static final String[] TRIM_PREFIXES = new String[]{"ui", "org.eclipse.rcptt.tesla.protocol.", "org.eclipse.rcptt.tesla.", "com.xored."};

    protected FeaturesConfigurationDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.FeaturesConfigurationDialog_0);
        newShell.setImage(Images.getImageDescriptor("icons/launching/externalEclipse.gif").createImage());
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = (Composite)super.createDialogArea(parent);
        GridData data = new GridData(4, 4, true, true);
        content.setLayoutData((Object)data);
        content.setLayout((Layout)new GridLayout(1, false));
        this.features.createOptions(content, "adv.options", false, null);
        return content;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, "Runner arg", false);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1025: {
                this.features.apply();
                new MessageDialog(this.getShell(), "-testOptions arg for RCPTT Runner", null, this.buildTestOptionsLine(), 2, new String[]{"Copy to Clipboard", "Close"}, 1){

                    protected void buttonPressed(int buttonId) {
                        switch (buttonId) {
                            case 0: {
                                Clipboard cb = new Clipboard(this.getShell().getDisplay());
                                cb.setContents(new Object[]{this.message}, new Transfer[]{TextTransfer.getInstance()});
                                cb.dispose();
                                break;
                            }
                            default: {
                                super.buttonPressed(buttonId);
                            }
                        }
                    }
                }.open();
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    private String buildTestOptionsLine() {
        AbstractFeatureManager[] managers = new AbstractFeatureManager[]{TeslaFeatures.getInstance(), Q7Features.getInstance()};
        LinkedHashMap<String, AbstractFeatureManager.Option> nonDefaultOptions = new LinkedHashMap<String, AbstractFeatureManager.Option>();
        AbstractFeatureManager[] abstractFeatureManagerArray = managers;
        int n = managers.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractFeatureManager manager = abstractFeatureManagerArray[n2];
            String[] stringArray = manager.getOptionNames();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                AbstractFeatureManager.Option option;
                String optionKey = stringArray[n4];
                if (!DISABLED_OPTIONS.contains(optionKey) && ((option = manager.getOption(optionKey)).getValue() == null && option.getDefaultValue() != null || !option.getValue().equals(option.getDefaultValue()))) {
                    nonDefaultOptions.put(optionKey, option);
                }
                ++n4;
            }
            ++n2;
        }
        if (nonDefaultOptions.size() == 0) {
            return "All options are set to defaults, no need to specify -testOptions arg";
        }
        StringBuilder result = new StringBuilder();
        result.append("-testOptions ");
        for (Map.Entry option : nonDefaultOptions.entrySet()) {
            result.append(String.format("%s=%s;", FeaturesConfigurationDialog.optionNameToArgName((String)option.getKey()), ((AbstractFeatureManager.Option)option.getValue()).getValue()));
        }
        result.setLength(result.length() - 1);
        return result.toString();
    }

    private static final String optionNameToArgName(String optionName) {
        StringBuilder result = new StringBuilder();
        String[] stringArray = TRIM_PREFIXES;
        int n = TRIM_PREFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (optionName.startsWith(prefix)) {
                optionName = optionName.substring(prefix.length());
                break;
            }
            ++n2;
        }
        String[] parts = optionName.split("\\.");
        boolean isFirst = true;
        String[] stringArray2 = parts;
        int n3 = parts.length;
        int n4 = 0;
        while (n4 < n3) {
            String part = stringArray2[n4];
            if (part.length() != 0) {
                if (isFirst) {
                    isFirst = false;
                    result.append(part);
                } else {
                    result.append(Character.toUpperCase(part.charAt(0)));
                    result.append(part.substring(1));
                }
            }
            ++n4;
        }
        return result.toString();
    }

    protected void okPressed() {
        this.features.apply();
        super.okPressed();
    }
}

