/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.data.internal.commands;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.rcptt.ecl.data.internal.EclDataPlugin;

public class FileResolver {
    private static Map<String, Resolver> resolvers = new HashMap<String, Resolver>();

    static {
        resolvers.put("file", new Resolver(){

            @Override
            public File resolve(URI uri) {
                return new File(uri);
            }
        });
        resolvers.put("workspace", new Resolver(){

            @Override
            public File resolve(URI uri) throws CoreException {
                try {
                    return ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromPortableString((String)uri.getPath())).getLocation().toFile();
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    throw new CoreException(EclDataPlugin.createErr("Resources plugin is not available, cannot use 'workspace:' scheme", new Object[0]));
                }
            }
        });
    }

    public static void refresh(File file) {
        try {
            IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(Path.fromOSString((String)file.getAbsolutePath()));
            if (ifile != null) {
                try {
                    ifile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {}
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
    }

    public static File resolve(String uri) throws CoreException {
        try {
            return FileResolver.resolve(new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new CoreException(EclDataPlugin.createErr(e, "Cannot parse URI %s", uri));
        }
    }

    public static File resolve(URI uri) throws CoreException {
        Resolver resolver = resolvers.get(uri.getScheme());
        if (resolver == null) {
            throw new CoreException(EclDataPlugin.createErr("Usupported scheme %s", uri.getScheme()));
        }
        return resolver.resolve(uri);
    }

    private static interface Resolver {
        public File resolve(URI var1) throws CoreException;
    }
}

