/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.filesystem.internal.commands;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.Get;
import org.eclipse.rcptt.ecl.dispatch.IScriptletExtension;
import org.eclipse.rcptt.ecl.filesystem.EclFilesystemPlugin;
import org.eclipse.rcptt.ecl.filesystem.File;
import org.eclipse.rcptt.ecl.filesystem.FilesystemFactory;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;
import org.eclipse.rcptt.ecl.runtime.SingleCommandService;

public class GetFromFileService
extends SingleCommandService<Get>
implements IScriptletExtension {
    public GetFromFileService() {
        super(Get.class);
    }

    private static Key parseKey(Object object) {
        Object keyObject = BoxedValues.unbox((Object)object);
        if (keyObject == null) {
            return null;
        }
        if (!(keyObject instanceof String)) {
            return null;
        }
        String keyString = (String)keyObject;
        try {
            return Key.valueOf(Key.class, keyString.toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public boolean canHandle(Command command) {
        if (!(command instanceof Get)) {
            return false;
        }
        Get get = (Get)command;
        if (!(get.getInput() instanceof File)) {
            return false;
        }
        return GetFromFileService.parseKey(get.getKey()) != null;
    }

    protected Object serviceTyped(Get command) throws InterruptedException, CoreException {
        Key key = GetFromFileService.parseKey(command.getKey());
        if (key == null) {
            throw new CoreException((IStatus)EclFilesystemPlugin.createError("Invalid key: " + command.getKey()));
        }
        String uriString = ((File)command.getInput()).getUri();
        URI uri = URI.create(uriString);
        IFileStore input = EFS.getStore((URI)uri);
        switch (key) {
            case CHILDREN: {
                return this.handleChildren(input);
            }
            case EXISTS: {
                return this.handleExists(input);
            }
            case ISDIRECTORY: {
                return this.handleIsDirectory(input);
            }
            case NAME: {
                return this.handleName(input);
            }
        }
        throw new CoreException((IStatus)EclFilesystemPlugin.createError("Wrong key: " + (Object)((Object)key)));
    }

    private boolean handleIsDirectory(IFileStore input) throws CoreException {
        return input.fetchInfo().isDirectory();
    }

    private List<File> handleChildren(IFileStore input) throws CoreException {
        try {
            IFileStore[] files = input.childStores(0, null);
            ArrayList<File> rv = new ArrayList<File>();
            IFileStore[] iFileStoreArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore child = iFileStoreArray[n2];
                File item = FilesystemFactory.eINSTANCE.createFile();
                item.setUri(child.toURI().toURL().toExternalForm());
                rv.add(item);
                ++n2;
            }
            return rv;
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)EclFilesystemPlugin.createError("Can't create child URI", e));
        }
    }

    private String handleName(IFileStore input) {
        return input.fetchInfo().getName();
    }

    private boolean handleExists(IFileStore input) throws CoreException {
        return input.fetchInfo().exists();
    }

    static enum Key {
        EXISTS,
        CHILDREN,
        NAME,
        ISDIRECTORY;

    }
}

