/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.runtime.ui;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.swt.dialogs.SWTDialogManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class Utils {
    public static void closeDialogs() {
        Utils.doCloseDialogs();
    }

    private static boolean doCloseDialogs() {
        SWTDialogManager.setCancelMessageBoxesDisplay((boolean)true);
        try {
            boolean closed = false;
            IWorkbench workbench = PlatformUI.getWorkbench();
            Display display = workbench.getDisplay();
            workbench.getActiveWorkbenchWindow();
            IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
            HashSet<Shell> windowShells = new HashSet<Shell>();
            IWorkbenchWindow[] iWorkbenchWindowArray = windows;
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                Shell shell = window.getShell();
                if (shell != null) {
                    windowShells.add(shell);
                }
                ++n2;
            }
            Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
            for (Thread t : map.keySet()) {
                Display dd = Display.findDisplay((Thread)t);
                if (dd == null || dd.equals(display)) continue;
                t.interrupt();
            }
            Shell[] shells = display.getShells();
            int i = shells.length - 1;
            while (i >= 0) {
                Shell shell = shells[i];
                if (!windowShells.contains(shell) && !shell.isDisposed() && shell.isVisible()) {
                    Object data = shell.getData();
                    if (data != null && data instanceof WizardDialog) {
                        try {
                            ProgressMonitorPart part;
                            WizardDialog dialog = (WizardDialog)data;
                            if (TeslaSWTAccess.getWizardDialogHasActiveOperations((WizardDialog)dialog) && (part = TeslaSWTAccess.getProgressMonitorPart((WizardDialog)dialog)) != null) {
                                part.setCanceled(true);
                                part.clearBlocked();
                            }
                            TeslaSWTAccess.setWizardDialogHasActiveOperations((WizardDialog)dialog, (long)0L);
                            dialog.close();
                        }
                        catch (Throwable e) {
                            TeslaCore.log((Throwable)e);
                        }
                    } else {
                        shell.close();
                    }
                    closed = true;
                }
                --i;
            }
            boolean bl = closed;
            return bl;
        }
        finally {
            SWTDialogManager.setCancelMessageBoxesDisplay((boolean)false);
        }
    }
}

