/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.profiling.core;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.profiling.core.JobsEventProvider;
import org.eclipse.rcptt.profiling.core.ReflectionUtils;
import org.eclipse.rcptt.sherlock.aspects.jobs.internal.IJobsEventListener;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Event;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.EventKind;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.EventSource;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.ReportFactory;
import org.eclipse.rcptt.sherlock.core.reporting.IReportBuilder;
import org.eclipse.rcptt.sherlock.jobs.jobs.JobEventInfo;
import org.eclipse.rcptt.sherlock.jobs.jobs.JobEventKind;
import org.eclipse.rcptt.sherlock.jobs.jobs.JobInfo;
import org.eclipse.rcptt.sherlock.jobs.jobs.JobsFactory;

public class JobsProfilingSupport
implements IJobsEventListener,
IJobChangeListener {
    private static final String JOBS_SLEEPING_COLOR = "#505050";
    private static final String JOBS_RUNNING_COLOR = "#00BB00";
    private static final String JOBS_WAITING_COLOR = "#AAAAAA";
    private Map<IReportBuilder, Map<Object, EventSource>> sources = new HashMap<IReportBuilder, Map<Object, EventSource>>();
    private Map<InternalJob, JobEventKind> currentStates = new WeakHashMap<InternalJob, JobEventKind>();
    private JobsEventProvider provider;

    public JobsProfilingSupport(JobsEventProvider jobsEventProvider) {
        this.provider = jobsEventProvider;
    }

    private Map<Object, EventSource> getSources(IReportBuilder builder) {
        Map<Object, EventSource> map = this.sources.get(builder);
        if (map == null) {
            map = new WeakHashMap<Object, EventSource>();
            this.sources.put(builder, map);
        }
        return map;
    }

    public void jobSchedule(InternalJob job, long delay, boolean reshedule) {
        IReportBuilder[] builders;
        IReportBuilder[] iReportBuilderArray = builders = this.provider.getListeners();
        int n = builders.length;
        int n2 = 0;
        while (n2 < n) {
            EventSource source;
            IReportBuilder builder = iReportBuilderArray[n2];
            JobInfo jobInfo = JobsFactory.eINSTANCE.createJobInfo();
            String jname = job.getClass().getName();
            jobInfo.setJobClassName(jname);
            Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
            Object object = ReflectionUtils.getThis(job);
            block1: for (Thread t : stackTraces.keySet()) {
                if (!t.equals(Thread.currentThread())) continue;
                jobInfo.setThreadName(t.getName());
                StackTraceElement[] traceElements = stackTraces.get(t);
                boolean next = false;
                StackTraceElement[] stackTraceElementArray = traceElements;
                int n3 = traceElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    StackTraceElement stackTraceElement = stackTraceElementArray[n4];
                    if (next) {
                        jobInfo.setSourceMethod(stackTraceElement.getMethodName());
                        jobInfo.setSourceClass(stackTraceElement.getClassName());
                        String fName = stackTraceElement.getFileName();
                        if (fName == null) continue block1;
                        jobInfo.setSourceFile(String.valueOf(fName) + ":" + stackTraceElement.getLineNumber());
                        continue block1;
                    }
                    if (stackTraceElement.getClassName().equals("org.eclipse.swt.widgets.Display")) {
                        next = true;
                    }
                    ++n4;
                }
            }
            if (object != null) {
                String tname = object.getClass().getName();
                if (jobInfo.getSourceClass() == null || !jobInfo.getSourceClass().equals(tname)) {
                    jobInfo.setThisClassName(tname);
                }
            }
            if (jobInfo.getJobClassName() != null && jobInfo.getSourceClass() != null && jobInfo.getJobClassName().startsWith(jobInfo.getSourceClass())) {
                jobInfo.setJobClassName(jobInfo.getJobClassName().substring(jobInfo.getSourceClass().length()));
            }
            if ((source = builder.findSource("org.eclipse.rcptt.watson.jobs.info", (EObject)jobInfo)) == null) {
                source = builder.registerEventSource("job:" + job.getClass().getSimpleName());
                source.getProperties().put((Object)"org.eclipse.rcptt.watson.jobs.info", (Object)jobInfo);
            }
            this.getSources(builder).put(job, source);
            Event event = ReportFactory.eINSTANCE.createEvent();
            event.setSource(source);
            event.setKind(EventKind.BEGIN);
            event.setColor(JOBS_WAITING_COLOR);
            JobEventInfo eventInfo = JobsFactory.eINSTANCE.createJobEventInfo();
            event.setData((EObject)eventInfo);
            eventInfo.setKind(JobEventKind.SHEDULED);
            eventInfo.setId(JobsEventProvider.getID(job));
            this.currentStates.put(job, JobEventKind.SHEDULED);
            builder.getCurrent().createEvent(event);
            ++n2;
        }
    }

    public void jobChangeStatus(InternalJob job, int newState) {
        IReportBuilder[] builders;
        IReportBuilder[] iReportBuilderArray = builders = this.provider.getListeners();
        int n = builders.length;
        int n2 = 0;
        while (n2 < n) {
            IReportBuilder builder = iReportBuilderArray[n2];
            if (this.getSources(builder).get(job) == null) {
                return;
            }
            if (newState != 0) {
                JobEventKind kind = this.currentStates.get(job);
                if (kind != null && (newState == 4 || newState == 16 ? kind.equals((Object)JobEventKind.RUNNING) : (newState == 1 ? kind.equals((Object)JobEventKind.SLEPPING) : kind.equals((Object)JobEventKind.WAITING)))) {
                    return;
                }
                JobEventInfo eventInfo = JobsFactory.eINSTANCE.createJobEventInfo();
                eventInfo.setId(JobsEventProvider.getID(job));
                Event event = ReportFactory.eINSTANCE.createEvent();
                event.setSource(this.getSources(builder).get(job));
                event.setData((EObject)eventInfo);
                event.setKind(EventKind.BEGIN);
                if (newState == 4 || newState == 16) {
                    eventInfo.setKind(JobEventKind.RUNNING);
                    event.setColor(JOBS_RUNNING_COLOR);
                } else if (newState == 1) {
                    event.setColor(JOBS_SLEEPING_COLOR);
                    eventInfo.setKind(JobEventKind.SLEPPING);
                } else {
                    eventInfo.setKind(JobEventKind.WAITING);
                    event.setColor(JOBS_WAITING_COLOR);
                }
                builder.getCurrent().createEvent(event);
                this.currentStates.put(job, eventInfo.getKind());
            }
            ++n2;
        }
    }

    public void endJob(InternalJob job, IStatus status, boolean notify) {
        IReportBuilder[] builders;
        IReportBuilder[] iReportBuilderArray = builders = this.provider.getListeners();
        int n = builders.length;
        int n2 = 0;
        while (n2 < n) {
            IReportBuilder builder = iReportBuilderArray[n2];
            if (this.getSources(builder).get(job) == null) {
                return;
            }
            Event event = ReportFactory.eINSTANCE.createEvent();
            event.setSource(this.getSources(builder).get(job));
            JobEventInfo eventInfo = JobsFactory.eINSTANCE.createJobEventInfo();
            eventInfo.setId(JobsEventProvider.getID(job));
            event.setData((EObject)eventInfo);
            if (status != null && Job.ASYNC_FINISH.equals(status)) {
                event.setKind(EventKind.BEGIN);
                eventInfo.setKind(JobEventKind.ASYNC_FINISH);
            } else {
                event.setKind(EventKind.END);
                eventInfo.setKind(JobEventKind.FINISHED);
                this.currentStates.remove(job);
                this.getSources(builder).remove(job);
            }
            builder.getCurrent().createEvent(event);
            ++n2;
        }
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(IJobChangeEvent event) {
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    public void register() {
        Job.getJobManager().addJobChangeListener((IJobChangeListener)this);
    }

    public void unregister() {
        Job.getJobManager().removeJobChangeListener((IJobChangeListener)this);
    }

    public void jobCanceled(InternalJob job) {
        IReportBuilder[] builders;
        IReportBuilder[] iReportBuilderArray = builders = this.provider.getListeners();
        int n = builders.length;
        int n2 = 0;
        while (n2 < n) {
            IReportBuilder builder = iReportBuilderArray[n2];
            if (this.getSources(builder).get(job) == null) {
                return;
            }
            Event event = ReportFactory.eINSTANCE.createEvent();
            event.setSource(this.getSources(builder).get(job));
            JobEventInfo eventInfo = JobsFactory.eINSTANCE.createJobEventInfo();
            event.setData((EObject)eventInfo);
            eventInfo.setKind(JobEventKind.CANCELED);
            eventInfo.setId(JobsEventProvider.getID(job));
            event.setKind(EventKind.END);
            this.currentStates.remove(job);
            builder.getCurrent().createEvent(event);
            ++n2;
        }
    }

    public void clear() {
        this.currentStates.clear();
        this.sources.clear();
    }
}

