/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.views.actions;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.views.actions.AntViewActionMessages;
import org.eclipse.ant.internal.ui.views.actions.EditorImageDescriptor;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class AntOpenWithMenu
extends ContributionItem {
    private IWorkbenchPage fPage;
    private IEditorRegistry fRegistry = PlatformUI.getWorkbench().getEditorRegistry();
    private static final String SYSTEM_EDITOR_ID = "org.eclipse.ui.SystemEditor";
    private static Map imageCache = new Hashtable(11);
    private AntElementNode fNode;
    public static final String ID = "org.eclipse.ant.ui.AntOpenWithMenu";

    public AntOpenWithMenu(IWorkbenchPage page) {
        super(ID);
        this.fPage = page;
    }

    public void dispose() {
        super.dispose();
        Iterator iter = imageCache.values().iterator();
        while (iter.hasNext()) {
            Image image = (Image)iter.next();
            image.dispose();
        }
        imageCache.clear();
    }

    private Image getImage(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = this.getImageDescriptor(editorDesc);
        if (imageDesc == null) {
            return null;
        }
        Image image = (Image)imageCache.get(imageDesc);
        if (image == null) {
            image = imageDesc.createImage();
            imageCache.put(imageDesc, image);
        }
        return image;
    }

    private ImageDescriptor getImageDescriptor(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = null;
        imageDesc = editorDesc == null ? this.fRegistry.getImageDescriptor(this.fNode.getIFile().getName()) : editorDesc.getImageDescriptor();
        if (imageDesc == null && editorDesc != null && editorDesc.getId().equals(SYSTEM_EDITOR_ID)) {
            imageDesc = this.getSystemEditorImageDescriptor(this.fNode.getIFile().getFileExtension());
        }
        return imageDesc;
    }

    private ImageDescriptor getSystemEditorImageDescriptor(String extension) {
        Program externalProgram = null;
        if (extension != null) {
            externalProgram = Program.findProgram((String)extension);
        }
        if (externalProgram == null) {
            return null;
        }
        return new EditorImageDescriptor(externalProgram);
    }

    private void createMenuItem(Menu menu, final IEditorDescriptor descriptor, IEditorDescriptor preferredEditor) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        boolean isPreferred = preferredEditor != null && descriptor.getId().equals(preferredEditor.getId());
        menuItem.setSelection(isPreferred);
        menuItem.setText(descriptor.getLabel());
        Image image = this.getImage(descriptor);
        if (image != null) {
            menuItem.setImage(image);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        AntOpenWithMenu.this.openEditor(descriptor);
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    public void fill(Menu menu, int index) {
        IFile fileResource = this.fNode.getIFile();
        if (fileResource == null) {
            return;
        }
        IEditorDescriptor defaultEditor = this.fRegistry.findEditor("org.eclipse.ui.systemInPlaceEditor");
        IEditorDescriptor preferredEditor = IDE.getDefaultEditor((IFile)fileResource);
        IEditorDescriptor[] editors = this.fRegistry.getEditors(fileResource.getName());
        Arrays.sort(editors, new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = ((IEditorDescriptor)o1).getLabel();
                String s2 = ((IEditorDescriptor)o2).getLabel();
                return s1.compareToIgnoreCase(s2);
            }
        });
        IEditorDescriptor antEditor = this.fRegistry.findEditor("org.eclipse.ant.internal.ui.editor.AntEditor");
        boolean defaultFound = false;
        boolean antFound = false;
        ArrayList<String> alreadyAddedEditors = new ArrayList<String>(editors.length);
        int i = 0;
        while (i < editors.length) {
            IEditorDescriptor editor = editors[i];
            if (!alreadyAddedEditors.contains(editor.getId())) {
                this.createMenuItem(menu, editor, preferredEditor);
                if (defaultEditor != null && editor.getId().equals(defaultEditor.getId())) {
                    defaultFound = true;
                }
                if (antEditor != null && editor.getId().equals(antEditor.getId())) {
                    antFound = true;
                }
                alreadyAddedEditors.add(editor.getId());
            }
            ++i;
        }
        if (editors.length > 0) {
            new MenuItem(menu, 2);
        }
        if (!antFound && antEditor != null) {
            this.createMenuItem(menu, antEditor, preferredEditor);
        }
        if (!defaultFound && defaultEditor != null) {
            this.createMenuItem(menu, defaultEditor, preferredEditor);
        }
        IEditorDescriptor descriptor = this.fRegistry.findEditor("org.eclipse.ui.systemExternalEditor");
        this.createMenuItem(menu, descriptor, preferredEditor);
        this.createDefaultMenuItem(menu, fileResource);
    }

    public boolean isDynamic() {
        return true;
    }

    private void openEditor(IEditorDescriptor editorDescriptor) {
        AntUtil.openInEditor(this.fPage, editorDescriptor, this.fNode);
    }

    private void createDefaultMenuItem(Menu menu, final IFile fileResource) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        menuItem.setSelection(IDE.getDefaultEditor((IFile)fileResource) == null);
        menuItem.setText(AntViewActionMessages.AntViewOpenWithMenu_Default_Editor_4);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        IDE.setDefaultEditor((IFile)fileResource, null);
                        try {
                            IDE.openEditor((IWorkbenchPage)AntOpenWithMenu.this.fPage, (IFile)fileResource, (boolean)true);
                            break;
                        }
                        catch (PartInitException e) {
                            AntUIPlugin.log(MessageFormat.format((String)AntViewActionMessages.AntViewOpenWithMenu_Editor_failed, (Object[])new String[]{fileResource.getLocation().toOSString()}), e);
                        }
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    public void setNode(AntElementNode node) {
        this.fNode = node;
    }
}

