/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.refactoring.descriptors;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.core.refactoring.descriptors.JavaRefactoringDescriptorUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class IntroduceParameterObjectDescriptor
extends JavaRefactoringDescriptor {
    private static final String PARAMETER_COUNT = "PARAMETER_COUNT";
    private static final String PARAMETER_IDX = "PARAMETER_IDX";
    private static final String PARAMETER_CREATE_FIELD = "PARAMETER_CREATE_FIELD";
    private static final String PARAMETER_FIELD_NAME = "PARAMETER_FIELD_NAME";
    private static final String CLASS_NAME = "class_name";
    private static final String DELEGATE = "delegate";
    private static final String DEPRECATE_DELEGATE = "deprecate_delegate";
    private static final String GETTERS = "getters";
    private static final String PACKAGE_NAME = "package_name";
    private static final String PARAMETER_NAME = "parameter_name";
    private static final String SETTERS = "setters";
    private static final String TOP_LEVEL = "top_level";
    public static final int PARAMETER_OBJECT_IDX = -1;
    public static final Parameter PARAMETER_OBJECT = new Parameter(-1);
    private String fClassName;
    private boolean fDelegate = false;
    private boolean fDeprecateDelegate = true;
    private boolean fGetters = false;
    private IMethod fMethod;
    private String fPackageName;
    private String fParameterName;
    private Parameter[] fParameters;
    private boolean fSetters = false;
    private boolean fTopLevel = true;

    public static Parameter[] createParameters(IMethod method) {
        int length = method.getNumberOfParameters();
        Parameter[] result = new Parameter[length + 1];
        result[0] = PARAMETER_OBJECT;
        int i = 0;
        while (i < length) {
            result[i + 1] = new Parameter(i);
            result[i + 1].setCreateField(true);
            ++i;
        }
        return result;
    }

    public IntroduceParameterObjectDescriptor() {
        super("org.eclipse.jdt.ui.introduce.parameter.object");
    }

    public IntroduceParameterObjectDescriptor(String project, String description, String comment, Map arguments, int flags) throws IllegalArgumentException {
        super("org.eclipse.jdt.ui.introduce.parameter.object", project, description, comment, arguments, flags);
        this.initializeFromMap(arguments);
    }

    public String getClassName() {
        return this.fClassName;
    }

    public IMethod getMethod() {
        return this.fMethod;
    }

    public String getPackageName() {
        IType type;
        if (this.fPackageName == null && this.fMethod != null && (type = this.fMethod.getDeclaringType()) != null) {
            return type.getPackageFragment().getElementName();
        }
        return this.fPackageName;
    }

    public String getParameterName() {
        return this.fParameterName;
    }

    public Parameter[] getParameters() {
        return this.fParameters;
    }

    public boolean isDelegate() {
        return this.fDelegate;
    }

    public boolean isDeprecateDelegate() {
        return this.fDeprecateDelegate;
    }

    public boolean isGetters() {
        return this.fGetters;
    }

    public boolean isSetters() {
        return this.fSetters;
    }

    public boolean isTopLevel() {
        return this.fTopLevel;
    }

    protected void populateArgumentMap() {
        super.populateArgumentMap();
        JavaRefactoringDescriptorUtil.setJavaElement(this.fArguments, "input", this.getProject(), (IJavaElement)this.fMethod);
        Parameter[] parameters = this.fParameters;
        if (parameters == null) {
            parameters = IntroduceParameterObjectDescriptor.createParameters(this.fMethod);
        }
        JavaRefactoringDescriptorUtil.setInt(this.fArguments, PARAMETER_COUNT, parameters.length);
        int i = 0;
        while (i < parameters.length) {
            Parameter param = parameters[i];
            JavaRefactoringDescriptorUtil.setInt(this.fArguments, JavaRefactoringDescriptorUtil.getAttributeName(PARAMETER_IDX, i), param.getIndex());
            JavaRefactoringDescriptorUtil.setBoolean(this.fArguments, JavaRefactoringDescriptorUtil.getAttributeName(PARAMETER_CREATE_FIELD, i), param.isCreateField());
            if (param.isCreateField()) {
                JavaRefactoringDescriptorUtil.setString(this.fArguments, JavaRefactoringDescriptorUtil.getAttributeName(PARAMETER_FIELD_NAME, i), param.getFieldName());
            }
            ++i;
        }
        JavaRefactoringDescriptorUtil.setString(this.fArguments, CLASS_NAME, this.fClassName);
        JavaRefactoringDescriptorUtil.setString(this.fArguments, PACKAGE_NAME, this.fPackageName);
        JavaRefactoringDescriptorUtil.setString(this.fArguments, PARAMETER_NAME, this.fParameterName);
        JavaRefactoringDescriptorUtil.setBoolean(this.fArguments, DELEGATE, this.fDelegate);
        JavaRefactoringDescriptorUtil.setBoolean(this.fArguments, DEPRECATE_DELEGATE, this.fDeprecateDelegate);
        JavaRefactoringDescriptorUtil.setBoolean(this.fArguments, GETTERS, this.fGetters);
        JavaRefactoringDescriptorUtil.setBoolean(this.fArguments, SETTERS, this.fSetters);
        JavaRefactoringDescriptorUtil.setBoolean(this.fArguments, TOP_LEVEL, this.fTopLevel);
    }

    private void initializeFromMap(Map map) throws IllegalArgumentException {
        IMethod method = (IMethod)JavaRefactoringDescriptorUtil.getJavaElement(map, "input", this.getProject());
        this.setMethod(method);
        this.initializeParameter(map);
        this.setClassName(JavaRefactoringDescriptorUtil.getString(map, CLASS_NAME, true));
        this.setPackageName(JavaRefactoringDescriptorUtil.getString(map, PACKAGE_NAME, true));
        this.setParameterName(JavaRefactoringDescriptorUtil.getString(map, PARAMETER_NAME, true));
        this.setDelegate(JavaRefactoringDescriptorUtil.getBoolean(map, DELEGATE, this.fDelegate));
        this.setDeprecateDelegate(JavaRefactoringDescriptorUtil.getBoolean(map, DEPRECATE_DELEGATE, this.fDeprecateDelegate));
        this.setGetters(JavaRefactoringDescriptorUtil.getBoolean(map, GETTERS, this.fGetters));
        this.setSetters(JavaRefactoringDescriptorUtil.getBoolean(map, SETTERS, this.fSetters));
        this.setTopLevel(JavaRefactoringDescriptorUtil.getBoolean(map, TOP_LEVEL, this.fTopLevel));
    }

    private void initializeParameter(Map map) throws IllegalArgumentException {
        int[] idx = JavaRefactoringDescriptorUtil.getIntArray(map, PARAMETER_COUNT, PARAMETER_IDX);
        boolean[] createField = JavaRefactoringDescriptorUtil.getBooleanArray(map, PARAMETER_COUNT, PARAMETER_CREATE_FIELD, 0);
        Parameter[] result = new Parameter[idx.length];
        int i = 0;
        while (i < idx.length) {
            int index = idx[i];
            if (index == -1) {
                result[i] = new Parameter(-1);
            } else {
                Parameter parameter;
                result[i] = parameter = new Parameter(index);
                parameter.setCreateField(createField[i]);
                if (createField[i]) {
                    parameter.setFieldName(JavaRefactoringDescriptorUtil.getString(map, JavaRefactoringDescriptorUtil.getAttributeName(PARAMETER_FIELD_NAME, i)));
                }
            }
            ++i;
        }
        this.setParameters(result);
    }

    public void setClassName(String className) {
        this.fClassName = className;
    }

    public void setDelegate(boolean delegate) {
        this.fDelegate = delegate;
    }

    public void setDeprecateDelegate(boolean deprecateDelegate) {
        this.fDeprecateDelegate = deprecateDelegate;
    }

    public void setGetters(boolean getters) {
        this.fGetters = getters;
    }

    public void setMethod(IMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("The method must not be null");
        }
        if (!method.exists()) {
            throw new IllegalArgumentException("The method must exist");
        }
        if (method.getJavaProject() == null) {
            throw new IllegalArgumentException("The method has to be in a Java project");
        }
        this.fMethod = method;
    }

    public void setPackageName(String packageName) {
        this.fPackageName = packageName;
    }

    public void setParameterName(String parameterName) {
        this.fParameterName = parameterName;
    }

    public void setParameters(Parameter[] parameters) {
        this.fParameters = parameters;
    }

    public void setSetters(boolean setters) {
        this.fSetters = setters;
    }

    public void setTopLevel(boolean topLevel) {
        this.fTopLevel = topLevel;
    }

    public RefactoringStatus validateDescriptor() {
        RefactoringStatus result = super.validateDescriptor();
        if (!result.isOK()) {
            return result;
        }
        if (this.fMethod == null) {
            result.addFatalError("The method must not be null");
            return result;
        }
        IJavaProject javaProject = this.fMethod.getJavaProject();
        if (javaProject == null) {
            result.addFatalError("Can not derive Java project from method");
            return result;
        }
        String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        String complianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        if (this.fParameters != null) {
            if (this.fParameters.length - 1 != this.fMethod.getNumberOfParameters()) {
                result.addFatalError("The number of parameters does not match the number of parameters of the method");
            }
            boolean hasParameterObject = false;
            int i = 0;
            while (i < this.fParameters.length) {
                Parameter parameter = this.fParameters[i];
                if (parameter.isCreateField()) {
                    String fieldName = parameter.getFieldName();
                    if (fieldName == null) {
                        result.addError("The parameter " + parameter.getIndex() + " is marked for field creation but does not have a field name");
                    } else {
                        result.merge(RefactoringStatus.create((IStatus)JavaConventions.validateFieldName((String)fieldName, (String)sourceLevel, (String)complianceLevel)));
                    }
                }
                if (parameter == PARAMETER_OBJECT) {
                    if (hasParameterObject) {
                        result.addError("Can not have more than one parameter object");
                    } else {
                        hasParameterObject = true;
                    }
                }
                ++i;
            }
        }
        if (this.fClassName != null) {
            result.merge(RefactoringStatus.create((IStatus)JavaConventions.validateIdentifier((String)this.fClassName, (String)sourceLevel, (String)complianceLevel)));
        }
        if (this.fParameterName != null) {
            result.merge(RefactoringStatus.create((IStatus)JavaConventions.validateIdentifier((String)this.fParameterName, (String)sourceLevel, (String)complianceLevel)));
        }
        if (this.fPackageName != null && !"".equals(this.fPackageName)) {
            result.merge(RefactoringStatus.create((IStatus)JavaConventions.validatePackageName((String)this.fPackageName, (String)sourceLevel, (String)complianceLevel)));
        }
        return result;
    }

    public static class Parameter {
        private boolean fCreateField = false;
        private String fFieldName = null;
        private final int fIndex;

        public Parameter(int index) {
            this.fIndex = index;
        }

        public String getFieldName() {
            return this.fFieldName;
        }

        public int getIndex() {
            return this.fIndex;
        }

        public boolean isCreateField() {
            return this.fCreateField;
        }

        public void setCreateField(boolean createField) {
            if (this.fIndex == -1) {
                throw new IllegalArgumentException("You can not set create field for the parameter object");
            }
            this.fCreateField = createField;
        }

        public void setFieldName(String fieldName) {
            if (this.fIndex == -1) {
                throw new IllegalArgumentException("You can not set the field name of the parameter object");
            }
            this.fFieldName = fieldName;
        }
    }
}

