/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rcptt.core.Q7Features;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7Folder;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.core.model.Openable;
import org.eclipse.rcptt.internal.core.model.OpenableElementInfo;
import org.eclipse.rcptt.internal.core.model.Q7Element;
import org.eclipse.rcptt.internal.core.model.Q7Folder;
import org.eclipse.rcptt.internal.core.model.Q7ProjectInfo;
import org.eclipse.rcptt.internal.core.model.ReferencedProjectScope;

public class Q7Project
extends Openable
implements IQ7Project {
    private IProject project;

    protected Q7Project(IProject project, Q7Element parent) throws IllegalArgumentException {
        super(parent);
        this.project = project;
    }

    @Override
    public IQ7Element.HandleType getElementType() {
        return IQ7Element.HandleType.Project;
    }

    @Override
    public IResource getResource() {
        return this.project;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public Object[] getForeignResources() throws ModelException {
        return ((Q7ProjectInfo)this.getElementInfo()).getForeignResources((IContainer)this.project);
    }

    @Override
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map<IQ7Element, Object> newElements, IResource underlyingResource) throws ModelException {
        if (!this.resourceExists()) {
            throw this.newNotPresentException();
        }
        this.getMetadata();
        return this.computeChildren(info, newElements);
    }

    protected boolean computeChildren(OpenableElementInfo info, Map<IQ7Element, Object> newElements) throws ModelException {
        try {
            IResource underlyingResource = this.getResource();
            if (underlyingResource.getType() == 2 || underlyingResource.getType() == 4) {
                ArrayList<IQ7Element> vChildren = new ArrayList<IQ7Element>(5);
                IContainer rootFolder = (IContainer)underlyingResource;
                this.computeFolderChildren(rootFolder, (IPath)Path.EMPTY, vChildren);
                info.setChildren(vChildren.toArray(new IQ7Element[vChildren.size()]));
            }
        }
        catch (ModelException e) {
            info.setChildren(new IQ7Element[0]);
            throw e;
        }
        return true;
    }

    protected void computeFolderChildren(IContainer folder, IPath path, List<IQ7Element> vChildren) throws ModelException {
        IQ7Folder pkg = this.getFolder(path);
        vChildren.add(pkg);
        try {
            IResource[] members = folder.members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource member = members[i];
                String memberName = member.getName();
                switch (member.getType()) {
                    case 2: {
                        IPath newPath = path.append(memberName);
                        this.computeFolderChildren((IContainer)((IFolder)member), newPath, vChildren);
                    }
                }
                ++i;
            }
        }
        catch (IllegalArgumentException e) {
            throw new ModelException((Throwable)e, "Element doesn't exist");
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    @Override
    public IQ7Folder getFolder(IPath path) {
        return new Q7Folder(this, path);
    }

    @Override
    public IPath getPath() {
        return this.project.getFullPath();
    }

    @Override
    protected Object createElementInfo() {
        return new Q7ProjectInfo();
    }

    @Override
    public String getName() {
        return this.project.getName();
    }

    @Override
    public IQ7Folder[] getFolders() throws ModelException {
        List<IQ7Element> result = this.getChildrenOfType(IQ7Element.HandleType.Folder);
        return result.toArray(new IQ7Folder[result.size()]);
    }

    @Override
    public IQ7Project[] getReferences() {
        try {
            IProject[] projects;
            ArrayList<IQ7Project> references = new ArrayList<IQ7Project>();
            IProject[] iProjectArray = projects = this.project.getReferencedProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject iProject = iProjectArray[n2];
                if (iProject.exists() && iProject.isOpen()) {
                    references.add(RcpttCore.create(iProject));
                }
                ++n2;
            }
            return references.toArray(new IQ7Project[references.size()]);
        }
        catch (Exception exception) {
            return new IQ7Project[0];
        }
    }

    @Override
    public <T> List<T> find(Class<T> class_, String id) throws ModelException {
        IQ7NamedElement[] elements = Q7SearchCore.findById(id, new ReferencedProjectScope(this), (IProgressMonitor)new NullProgressMonitor());
        ArrayList<IQ7NamedElement> contexts = new ArrayList<IQ7NamedElement>();
        IQ7NamedElement[] iQ7NamedElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7NamedElement e = iQ7NamedElementArray[n2];
            if (class_.isInstance(e)) {
                contexts.add(e);
            }
            ++n2;
        }
        return contexts;
    }

    @Override
    public IQ7NamedElement[] findNamedElement(String id) throws ModelException {
        return Q7SearchCore.findById(id, new ReferencedProjectScope(this), (IProgressMonitor)new NullProgressMonitor());
    }

    public void resetCaches() {
    }

    public boolean contains(IResource resource) {
        return this.project.getFullPath().isPrefixOf(resource.getFullPath());
    }

    @Override
    public int hashCode() {
        return this.project.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Q7Project)) {
            return false;
        }
        Q7Project other = (Q7Project)o;
        return this.project.equals((Object)other.getProject());
    }

    @Override
    public IQ7Folder getRootFolder() {
        return this.getFolder((IPath)new Path(""));
    }

    @Override
    public IQ7Folder createFolder(Path path) {
        try {
            this.project.getFolder((IPath)path).create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return this.getFolder((IPath)path);
    }

    private static boolean resourceExists(IResource resource) {
        IPath path = resource.getLocation();
        if (path == null) {
            return false;
        }
        return path.toFile().exists();
    }

    @Override
    public IQ7ProjectMetadata getMetadata() {
        if (!Q7Features.supportQ7OptionsFile) {
            return null;
        }
        final Q7Folder rootFolder = (Q7Folder)this.getRootFolder();
        IQ7ProjectMetadata metadata = rootFolder.getMetadata();
        if (!Q7Project.resourceExists(metadata.getResource())) {
            final String pfamily = "Q7_CREATE_METADATA:" + this.getName();
            Job[] find = Job.getJobManager().find((Object)pfamily);
            if (find.length > 0) {
                return rootFolder.getMetadata();
            }
            Job createMetadataJob = new Job("Create Q7 project metadata"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        rootFolder.createMetadata(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (ModelException e) {
                        RcpttPlugin.log((Throwable)((Object)e));
                    }
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    return pfamily.equals(family);
                }
            };
            createMetadataJob.schedule();
            return rootFolder.getMetadata();
        }
        return metadata;
    }
}

