/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ext;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall3;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.ext.OSArchitecture;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JDTUtils {
    private static final String TARGET_VM_INSTALL_TYPE = "org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType";
    private static final String HOST_VM_INSTALL_ID = "Q7 Host JVM";
    private static final String SUN_ARCH_DATA_MODEL = "sun.arch.data.model";
    private static final String JAVA_VM_INFO = "java.vm.info";
    private static final String OS_ARCH = "os.arch";
    private static final Map<String, Map<String, String>> systemPropertiesMap = new HashMap<String, Map<String, String>>();

    public static void registerCurrentJVM() throws CoreException {
        IVMInstallType type = JavaRuntime.getVMInstallType((String)TARGET_VM_INSTALL_TYPE);
        if (type == null) {
            return;
        }
        IVMInstall install = type.findVMInstall(HOST_VM_INSTALL_ID);
        if (install != null) {
            type.disposeVMInstall(HOST_VM_INSTALL_ID);
        }
        install = type.createVMInstall(HOST_VM_INSTALL_ID);
        install.setInstallLocation(new File(System.getProperty("java.home")));
        install.setName(HOST_VM_INSTALL_ID);
        JavaRuntime.saveVMConfiguration();
    }

    public static Map<String, String> evaluateSystemPropertiesInThread(AbstractVMInstall install, IProgressMonitor monitor, boolean d32, int timeout) throws CoreException {
        String installId = install.getId();
        Map<String, String> cashedMap = systemPropertiesMap.get(String.valueOf(installId) + (d32 ? "32" : "64"));
        if (cashedMap != null) {
            return cashedMap;
        }
        GetPropertiesThread thread = new GetPropertiesThread(install, monitor, d32);
        thread.start();
        try {
            thread.join(timeout);
        }
        catch (InterruptedException e) {
            RcpttPlugin.log((Throwable)e);
        }
        thread.interrupt();
        if (thread.getCoreException() != null) {
            throw thread.getCoreException();
        }
        return thread.getMap();
    }

    protected static void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), code, message, exception));
    }

    public static Map<String, String> evaluateSystemProperties(AbstractVMInstall install, IProgressMonitor monitor, boolean d32) throws CoreException {
        File file;
        HashMap<String, String> map = new HashMap<String, String>();
        String[] properties = new String[]{OS_ARCH, "java.version", "java.specification.name", "java.specification.version", JAVA_VM_INFO, "java.vm.name", "java.vm.version", "java.runtime.name", "java.runtime.version", SUN_ARCH_DATA_MODEL};
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((file = LaunchingPlugin.getFileInPlugin((IPath)new Path("lib/launchingsupport.jar"))) != null && file.exists()) {
            IProcess process;
            IVMRunner runner;
            String javaVersion = install.getJavaVersion();
            boolean hasXMLSupport = false;
            if (javaVersion != null) {
                hasXMLSupport = true;
                if (javaVersion.startsWith("1.1") || javaVersion.startsWith("1.2") || javaVersion.startsWith("1.3")) {
                    hasXMLSupport = false;
                }
            }
            String mainType = null;
            mainType = hasXMLSupport ? "org.eclipse.jdt.internal.launching.support.SystemProperties" : "org.eclipse.jdt.internal.launching.support.LegacySystemProperties";
            VMRunnerConfiguration config = new VMRunnerConfiguration(mainType, new String[]{file.getAbsolutePath()});
            ArrayList<String> vmArgs = new ArrayList<String>(Arrays.asList(config.getVMArguments()));
            if (d32 && Platform.getOS().equals("macosx") && !vmArgs.contains("-d32")) {
                vmArgs.add("-d32");
                config.setVMArguments(vmArgs.toArray(new String[vmArgs.size()]));
            }
            if ((runner = install.getVMRunner("run")) == null) {
                JDTUtils.abort(LaunchingMessages.AbstractVMInstall_0, null, 150);
            }
            config.setProgramArguments(properties);
            Launch launch = new Launch(null, "run", null);
            if (monitor.isCanceled()) {
                return map;
            }
            monitor.beginTask(LaunchingMessages.AbstractVMInstall_1, 2);
            runner.run(config, (ILaunch)launch, monitor);
            IProcess[] processes = launch.getProcesses();
            if (processes.length != 1) {
                JDTUtils.abort(LaunchingMessages.AbstractVMInstall_0, null, 150);
            }
            if ((process = processes[0]) instanceof RuntimeProcess) {
                Q7ExtLaunchingPlugin.getDefault().info(String.format("Launched external Java process. Command line is: %s", process.getAttribute(RuntimeProcess.ATTR_CMDLINE)));
            }
            try {
                int total = 0;
                int max = 50000;
                while (!process.isTerminated()) {
                    try {
                        if (total > max) {
                            break;
                        }
                        Thread.sleep(50L);
                        total += 50;
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            finally {
                if (!launch.isTerminated()) {
                    launch.terminate();
                    Q7ExtLaunchingPlugin.getDefault().info("Java process timed out and terminated");
                } else {
                    Q7ExtLaunchingPlugin.getDefault().info("Java process completed normally");
                }
            }
            monitor.worked(1);
            if (monitor.isCanceled()) {
                return map;
            }
            monitor.subTask(LaunchingMessages.AbstractVMInstall_3);
            IStreamsProxy streamsProxy = process.getStreamsProxy();
            String text = null;
            if (streamsProxy != null) {
                text = streamsProxy.getOutputStreamMonitor().getContents();
            }
            if (text != null && text.length() > 0) {
                try {
                    DocumentBuilder parser = LaunchingPlugin.getParser();
                    Document document = parser.parse(new ByteArrayInputStream(text.getBytes()));
                    Element envs = document.getDocumentElement();
                    NodeList list = envs.getChildNodes();
                    int length = list.getLength();
                    int i = 0;
                    while (i < length) {
                        Element element;
                        Node node = list.item(i);
                        short type = node.getNodeType();
                        if (type == 1 && (element = (Element)node).getNodeName().equals("property")) {
                            String name = element.getAttribute("name");
                            String value = element.getAttribute("value");
                            map.put(name, value);
                        }
                        ++i;
                    }
                }
                catch (SAXException e) {
                    JDTUtils.abort(LaunchingMessages.AbstractVMInstall_4, e, 150);
                }
                catch (IOException e) {
                    JDTUtils.abort(LaunchingMessages.AbstractVMInstall_4, e, 150);
                }
            } else {
                JDTUtils.abort(LaunchingMessages.AbstractVMInstall_0, null, 150);
            }
            monitor.worked(1);
        } else {
            JDTUtils.abort(LaunchingMessages.AbstractVMInstall_0, null, 150);
        }
        monitor.done();
        systemPropertiesMap.put(String.valueOf(install.getId()) + (d32 ? "32" : "64"), map);
        return map;
    }

    public static Map<String, String> detectArchitecture(IVMInstall install) {
        if (install instanceof AbstractVMInstall) {
            AbstractVMInstall avi = (AbstractVMInstall)install;
            try {
                Map<String, String> properties = JDTUtils.evaluateSystemPropertiesInThread(avi, (IProgressMonitor)new NullProgressMonitor(), false, 60000);
                return properties;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static OSArchitecture detect(IVMInstall install) {
        return JDTUtils.detect(JDTUtils.detectArchitecture(install));
    }

    private static OSArchitecture detect(Map<String, String> properties) {
        String model = properties.get(SUN_ARCH_DATA_MODEL);
        if (model != null && "32".equals(model)) {
            return OSArchitecture.x86;
        }
        if (model != null && "64".equals(model)) {
            return OSArchitecture.x86_64;
        }
        String arch = properties.get(OS_ARCH);
        if (arch != null && "amd64".equals(arch)) {
            return OSArchitecture.x86_64;
        }
        if (arch != null && "x86_64".equals(arch)) {
            return OSArchitecture.x86_64;
        }
        if (arch != null && "i386".equals(arch)) {
            return OSArchitecture.x86;
        }
        if (arch != null && "i686".equals(arch)) {
            return OSArchitecture.x86;
        }
        if (arch != null && "i586".equals(arch)) {
            return OSArchitecture.x86;
        }
        return null;
    }

    public static boolean canRun32bit(IVMInstall install) {
        if (Platform.getOS().equals("macosx") && install instanceof IVMInstall3) {
            AbstractVMInstall avi = (AbstractVMInstall)install;
            try {
                Map<String, String> properties2 = JDTUtils.evaluateSystemPropertiesInThread(avi, (IProgressMonitor)new NullProgressMonitor(), true, 60000);
                if (!properties2.isEmpty()) {
                    return true;
                }
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    static class GetPropertiesThread
    extends Thread {
        private Map<String, String> map = new HashMap<String, String>();
        private CoreException coreException;
        private final AbstractVMInstall install;
        private final IProgressMonitor monitor;
        private final boolean d32;

        public Map<String, String> getMap() {
            return this.map;
        }

        public CoreException getCoreException() {
            return this.coreException;
        }

        public GetPropertiesThread(AbstractVMInstall install, IProgressMonitor monitor, boolean d32) {
            this.install = install;
            this.monitor = monitor;
            this.d32 = d32;
        }

        @Override
        public void run() {
            try {
                this.map = JDTUtils.evaluateSystemProperties(this.install, this.monitor, this.d32);
            }
            catch (CoreException e) {
                this.coreException = e;
            }
        }
    }
}

