/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ext;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.rcptt.internal.launching.ext.Q7TargetPlatformInitializer;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.rcptt.launching.target.TargetPlatformManager;

public class Q7TargetPlatformManager {
    private static Map<String, ITargetPlatformHelper> cachedHelpers = new HashMap<String, ITargetPlatformHelper>();

    public static synchronized ITargetPlatformHelper loadTarget(ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        String location = config.getAttribute("aut-location", "");
        File loc = new File(location);
        if (!loc.exists()) {
            return null;
        }
        String targetPlatform = config.getAttribute("aut-target-platform", "");
        ITargetPlatformHelper cached = cachedHelpers.get(targetPlatform);
        if (cached != null) {
            return cached;
        }
        monitor.beginTask("Initialize target platform...", 2);
        ITargetPlatformHelper info = TargetPlatformManager.getTargetPlatform(targetPlatform, (IProgressMonitor)new SubProgressMonitor(monitor, 1), false);
        if (info != null && !info.isResolved()) {
            info.resolve(monitor);
        }
        if (!info.isValid()) {
            return null;
        }
        monitor.worked(1);
        monitor.done();
        cachedHelpers.put(targetPlatform, info);
        return info;
    }

    public static synchronized ITargetPlatformHelper getTarget(ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        String location = config.getAttribute("aut-location", "");
        File loc = new File(location);
        if (!loc.exists()) {
            return Q7TargetPlatformManager.newTargetPlatform(config, monitor, location);
        }
        String targetPlatform = config.getAttribute("aut-target-platform", "");
        monitor.beginTask("Initialize target platform...", 2);
        ITargetPlatformHelper info = TargetPlatformManager.getTargetPlatform(targetPlatform, (IProgressMonitor)new SubProgressMonitor(monitor, 1), true);
        if (!info.isValid()) {
            info.delete();
            info = Q7TargetPlatformManager.newTargetPlatform(config, (IProgressMonitor)new SubProgressMonitor(monitor, 1), location);
        } else {
            monitor.worked(1);
        }
        monitor.done();
        cachedHelpers.put(targetPlatform, info);
        return info;
    }

    private static synchronized ITargetPlatformHelper newTargetPlatform(ILaunchConfiguration config, IProgressMonitor monitor, String location) {
        ITargetPlatformHelper info = Q7TargetPlatformManager.createTargetPlatform(location, monitor, true);
        if (info != null && info.isValid()) {
            info.setTargetName(Q7TargetPlatformManager.getTargetPlatformName(config));
            info.save();
            cachedHelpers.put(info.getName(), info);
        }
        return info;
    }

    public static synchronized ITargetPlatformHelper createTargetPlatform(String location, IProgressMonitor monitor, boolean addErrorsToLog) {
        if (monitor.isCanceled()) {
            return null;
        }
        monitor.beginTask("Create AUT configuration", 100);
        ITargetPlatformHelper platform = TargetPlatformManager.createTargetPlatform(location, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        Q7TargetPlatformInitializer.initialize(platform, (IProgressMonitor)new SubProgressMonitor(monitor, 50), addErrorsToLog);
        monitor.done();
        return platform;
    }

    public static String getTargetPlatformName(ILaunchConfiguration config) {
        return "AUT " + config.getName() + " (Target Platform)";
    }

    public static String getTargetPlatformName(String name) {
        return "AUT " + name + " (Target Platform)";
    }

    public static synchronized void initialize() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener(new ILaunchConfigurationListener(){

            public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
                String target = Q7TargetPlatformManager.getTargetPlatformName(configuration);
                if (target != null) {
                    TargetPlatformManager.deleteTargetPlatform(target);
                    cachedHelpers.remove(target);
                }
            }

            public void launchConfigurationChanged(ILaunchConfiguration configuration) {
            }

            public void launchConfigurationAdded(ILaunchConfiguration configuration) {
            }
        });
    }

    public static synchronized void setHelper(String name, ITargetPlatformHelper info) {
        cachedHelpers.put(name, info);
    }

    public static synchronized ITargetPlatformHelper getHelper(String name) {
        return cachedHelpers.get(name);
    }

    public static synchronized void delete(String name) {
        cachedHelpers.remove(name);
    }

    public static synchronized void clear() {
        cachedHelpers.clear();
    }
}

