/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.internal.target;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.simpleconfigurator.utils.SimpleConfiguratorUtils;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDEExtensionRegistry;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.target.DirectoryBundleContainer;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.eclipse.pde.internal.core.target.ProfileBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.IBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.IResolvedBundle;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.ITargetPlatformService;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.internal.launching.ext.OSArchitecture;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;
import org.eclipse.rcptt.launching.ext.OriginalOrderProperties;
import org.eclipse.rcptt.launching.ext.Q7LaunchDelegateUtils;
import org.eclipse.rcptt.launching.injection.Directory;
import org.eclipse.rcptt.launching.injection.Entry;
import org.eclipse.rcptt.launching.injection.InjectionConfiguration;
import org.eclipse.rcptt.launching.injection.UpdateSite;
import org.eclipse.rcptt.launching.internal.target.PDEHelper;
import org.eclipse.rcptt.launching.internal.target.Q7Target;
import org.eclipse.rcptt.launching.p2utils.P2Utils;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.rcptt.launching.target.TargetPlatformManager;
import org.eclipse.rcptt.util.FileUtil;

public class TargetPlatformHelper
implements ITargetPlatformHelper {
    public static final String IDE_APPLICATION = "org.eclipse.ui.ide.workbench";
    public static String APPLICATION_PROPERTY = "eclipse.application";
    public static String PRODUCT_PROPERTY = "eclipse.product";
    private static String ID_PROPERTY = "id";
    private static String OSGI_BUNDLES = "osgi.bundles";
    private static final String SIMPLECONFIGURATOR = "org.eclipse.equinox.simpleconfigurator";
    private static final String SC_BUNDLES_PATH = "configuration/org.eclipse.equinox.simpleconfigurator/bundles.info";
    private String errorMessage = null;
    ITargetDefinition target;
    IBundleContainer instanceContainer;
    private final ArrayList<IBundleContainer> extra = new ArrayList();
    private IPluginModelBase[] models;
    private PDEExtensionRegistry registry;
    private Q7Target q7target = new Q7Target();
    private IPluginModelBase weavingHook;
    private InjectionConfiguration injectConfig;
    private IFileArtifactRepository repository;
    private static final String VMARGS = "-vmargs";
    private static final String VM = "-vm";

    @Override
    public Q7Target getQ7Target() {
        return this.q7target;
    }

    @Override
    public boolean isValid() {
        if (this.target == null) {
            return false;
        }
        if (this.errorMessage != null) {
            return false;
        }
        if (!this.target.isResolved()) {
            return false;
        }
        IStatus status = this.getBundleStatus();
        if (status == null) {
            return false;
        }
        return status.isOK();
    }

    @Override
    public boolean isResolved() {
        if (this.target != null) {
            return this.target.isResolved();
        }
        return false;
    }

    public boolean isInstanceContainerValid() {
        return this.instanceContainer != null && this.instanceContainer.getStatus().isOK();
    }

    @Override
    public String getErrorMessage() {
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        if (this.target != null) {
            IStatus bundleStatus = this.getBundleStatus();
            return this.getNonMultiStatusMessage(bundleStatus);
        }
        return null;
    }

    @Override
    public String getWarningMessage() {
        if (this.target != null) {
            IStatus bundleStatus = this.getBundleWarningStatus();
            return this.getNonMultiStatusMessage(bundleStatus);
        }
        return null;
    }

    public IStatus getBundleStatus() {
        IBundleContainer[] containers = this.getBundleContainers();
        if (containers != null) {
            MultiStatus result = new MultiStatus("org.eclipse.pde.core", 0, Messages.TargetDefinition_5, null);
            int i = 0;
            while (i < containers.length) {
                IBundleContainer container = containers[i];
                IStatus containerStatus = container.getStatus();
                if (containerStatus != null && !containerStatus.isOK()) {
                    result.add(containerStatus);
                }
                ++i;
            }
            if (!result.isOK()) {
                return result;
            }
            IResolvedBundle[] bundles = this.target.getBundles();
            int i2 = 0;
            while (i2 < bundles.length) {
                IResolvedBundle bundle = bundles[i2];
                if (!bundle.getStatus().isOK()) {
                    File file;
                    BundleInfo info = bundle.getBundleInfo();
                    URI uri = info.getLocation();
                    if (uri != null && !(file = new File(uri)).exists()) {
                        this.reportUnexistingFile(info);
                    } else {
                        result.add(bundle.getStatus());
                    }
                }
                ++i2;
            }
            if (result.isOK()) {
                return Status.OK_STATUS;
            }
            return result;
        }
        return Status.OK_STATUS;
    }

    private void reportUnexistingFile(BundleInfo info) {
        Q7LaunchingPlugin.log((IStatus)Q7LaunchingPlugin.createStatus((int)2, (String)("Skip unexisted bundle: " + info.getSymbolicName() + ", then resolve configuration."), null));
    }

    public IStatus getBundleWarningStatus() {
        IBundleContainer[] containers = this.getBundleContainers();
        if (containers != null) {
            MultiStatus result = new MultiStatus("org.eclipse.pde.core", 0, Messages.TargetDefinition_5, null);
            IResolvedBundle[] bundles = this.target.getBundles();
            int i = 0;
            while (i < bundles.length) {
                File file;
                BundleInfo info;
                URI uri;
                IResolvedBundle bundle = bundles[i];
                IStatus status = bundle.getStatus();
                if (!status.isOK() && (uri = (info = bundle.getBundleInfo()).getLocation()) != null && !(file = new File(uri)).exists()) {
                    Status st = new Status(2, status.getPlugin(), status.getMessage(), status.getException());
                    result.add((IStatus)st);
                }
                ++i;
            }
            if (result.isOK()) {
                return Status.OK_STATUS;
            }
            return result;
        }
        return Status.OK_STATUS;
    }

    private String getNonMultiStatusMessage(IStatus st) {
        if (st != null && st.isMultiStatus()) {
            IStatus[] children;
            StringBuilder buf = new StringBuilder();
            IStatus[] iStatusArray = children = st.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String msg;
                IStatus iStatus = iStatusArray[n2];
                if (iStatus.isMultiStatus() && (msg = this.getNonMultiStatusMessage(iStatus)) != null) {
                    buf.append(msg).append('\n');
                }
                if (!iStatus.isOK()) {
                    buf.append(iStatus.getMessage()).append('\n');
                }
                ++n2;
            }
            return buf.toString();
        }
        return st == null ? "" : st.getMessage();
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setTarget(ITargetDefinition target) {
        this.target = target;
        this.initialize();
    }

    private void initialize() {
        this.extra.clear();
        if (this.target != null && this.target.getBundleContainers() != null) {
            IBundleContainer[] containers;
            IBundleContainer[] iBundleContainerArray = containers = this.target.getBundleContainers();
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                IBundleContainer iUBundleContainer = iBundleContainerArray[n2];
                if (iUBundleContainer instanceof ProfileBundleContainer) {
                    this.instanceContainer = iUBundleContainer;
                    this.getQ7Target().setInstall(iUBundleContainer);
                } else if (iUBundleContainer instanceof DirectoryBundleContainer) {
                    this.getQ7Target().pluginsDir = iUBundleContainer;
                } else {
                    this.getQ7Target().addExtra(iUBundleContainer);
                }
                this.extra.add(iUBundleContainer);
                ++n2;
            }
        }
    }

    public void setTargetContainer(IBundleContainer container) {
        this.instanceContainer = container;
    }

    @Override
    public void setTargetName(String name) {
        if (this.target != null) {
            this.target.setName(name);
        }
    }

    @Override
    public String getName() {
        if (this.target != null) {
            return this.target.getName();
        }
        return "";
    }

    @Override
    public void save() {
        if (this.target != null) {
            TargetPlatformManager.deleteTargetPlatform(this.target.getName());
            try {
                ITargetPlatformService service = PDEHelper.getTargetService();
                service.saveTargetDefinition(this.target);
            }
            catch (CoreException e) {
                Q7ExtLaunchingPlugin.getDefault().log(e);
            }
        }
    }

    @Override
    public String getTargetPlatformProfilePath() {
        if (this.instanceContainer != null) {
            try {
                return ((ProfileBundleContainer)this.instanceContainer).getLocation(true).toString();
            }
            catch (CoreException e) {
                Q7ExtLaunchingPlugin.getDefault().log(e);
            }
        }
        return null;
    }

    @Override
    public void delete() {
        try {
            if (this.target != null && this.target.getHandle() != null) {
                PDEHelper.getTargetService().deleteTarget(this.target.getHandle());
            }
        }
        catch (CoreException e) {
            Q7ExtLaunchingPlugin.getDefault().log(e);
        }
    }

    public ITargetDefinition getTarget() {
        return this.target;
    }

    public void update() {
        ArrayList<IBundleContainer> newContainers = new ArrayList<IBundleContainer>();
        newContainers.addAll(Arrays.asList(this.target.getBundleContainers()));
        if (this.extra != null) {
            newContainers.addAll(this.extra);
        }
        this.target.setBundleContainers(newContainers.toArray(new IBundleContainer[newContainers.size()]));
        this.models = null;
        this.registry = null;
    }

    public IPluginModelBase[] getTargetModels() {
        this.calcModels();
        return this.models;
    }

    @Override
    public IPluginModelBase getWeavingHook() {
        this.calcModels();
        return this.weavingHook;
    }

    private void calcModels() {
        if (this.models == null) {
            List<IPluginModelBase> bundles = this.sumBundles();
            this.weavingHook = this.filterHooks(bundles);
            this.models = bundles.toArray(new IPluginModelBase[0]);
        }
    }

    private List<IPluginModelBase> sumBundles() {
        IResolvedBundle[] bundles = this.getTarget().getAllBundles();
        if (bundles == null) {
            return new ArrayList<IPluginModelBase>();
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        IResolvedBundle[] iResolvedBundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            IResolvedBundle bundle = iResolvedBundleArray[n2];
            try {
                urls.add(new URL("file://" + bundle.getBundleInfo().getLocation().getPath()));
            }
            catch (MalformedURLException e) {
                Q7ExtLaunchingPlugin.getDefault().log(e);
            }
            ++n2;
        }
        PDEState state = new PDEState(new URL[0], urls.toArray(new URL[urls.size()]), true, true, (IProgressMonitor)new NullProgressMonitor());
        return new ArrayList<IPluginModelBase>(Arrays.asList(state.getTargetModels()));
    }

    private IPluginModelBase filterHooks(List<IPluginModelBase> models) {
        ArrayList<IPluginModelBase> hooks = new ArrayList<IPluginModelBase>();
        for (IPluginModelBase model : models) {
            String name = model.getBundleDescription().getSymbolicName();
            if (!name.equals("org.eclipse.equinox.weaving.hook")) continue;
            hooks.add(model);
        }
        switch (hooks.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (IPluginModelBase)hooks.get(0);
            }
        }
        IPluginModelBase maxHook = (IPluginModelBase)hooks.get(0);
        int i = 1;
        while (i < hooks.size()) {
            IPluginModelBase hook = (IPluginModelBase)hooks.get(i);
            if (hook.getBundleDescription().getVersion().compareTo(maxHook.getBundleDescription().getVersion()) > 0) {
                maxHook = hook;
            }
            ++i;
        }
        hooks.remove(maxHook);
        models.removeAll(hooks);
        return maxHook;
    }

    @Override
    public boolean validateBundles(IProgressMonitor monitor) {
        LaunchValidationOperation validation = new LaunchValidationOperation(null){

            protected IPluginModelBase[] getModels() throws CoreException {
                return TargetPlatformHelper.this.getTargetModels();
            }

            protected IExecutionEnvironment[] getMatchingEnvironments() throws CoreException {
                IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
                IExecutionEnvironment[] envs = manager.getExecutionEnvironments();
                return envs;
            }
        };
        try {
            StringBuilder b = new StringBuilder();
            validation.run(monitor);
            Map input = validation.getInput();
            Set entrySet = input.entrySet();
            for (Map.Entry e : entrySet) {
                Object value = e.getKey();
                if (!(value instanceof ResolverError)) continue;
                b.append(value.toString()).append("\n");
            }
            if (b.length() > 0) {
                this.errorMessage = b.toString();
                return false;
            }
        }
        catch (CoreException e) {
            Q7ExtLaunchingPlugin.getDefault().log(e);
            return false;
        }
        catch (OperationCanceledException operationCanceledException) {
            return false;
        }
        return true;
    }

    @Override
    public String[] getProducts() {
        if (!this.isValid()) {
            return new String[0];
        }
        PDEExtensionRegistry reg = this.getRegistry();
        TreeSet<String> result = new TreeSet<String>();
        IExtension[] extensions = reg.findExtensions("org.eclipse.core.runtime.products", false);
        int i = 0;
        while (i < extensions.length) {
            String id;
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            if (elements.length == 1 && "product".equals(elements[0].getName()) && (id = extensions[i].getUniqueIdentifier()) != null && id.trim().length() > 0) {
                result.add(id);
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getApplications() {
        if (!this.isValid()) {
            return new String[0];
        }
        PDEExtensionRegistry reg = this.getRegistry();
        TreeSet<String> result = new TreeSet<String>();
        IExtension[] extensions = reg.findExtensions("org.eclipse.core.runtime.applications", false);
        int i = 0;
        while (i < extensions.length) {
            String id = extensions[i].getUniqueIdentifier();
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            if (elements.length == 1) {
                boolean visible;
                String visiblity = elements[0].getAttribute("visible");
                boolean bl = visible = visiblity == null ? true : Boolean.valueOf(visiblity);
                if (id != null && visible) {
                    result.add(id);
                }
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    private PDEExtensionRegistry getRegistry() {
        if (this.registry == null) {
            this.registry = new PDEExtensionRegistry(this.getTargetModels());
        }
        return this.registry;
    }

    @Override
    public IStatus resolve(IProgressMonitor monitor) {
        ITargetDefinition target = this.getTarget();
        if (target != null) {
            return target.resolve(monitor);
        }
        return Status.CANCEL_STATUS;
    }

    @Override
    public OriginalOrderProperties getConfigIniProperties() {
        File iniFile = new File(this.getTargetPlatformProfilePath(), "configuration/config.ini");
        OriginalOrderProperties pini = new OriginalOrderProperties();
        if (!iniFile.exists()) {
            return pini;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(iniFile);
            pini.load(fis);
            fis.close();
            OriginalOrderProperties originalOrderProperties = pini;
            return originalOrderProperties;
        }
        catch (IOException e) {
            Q7ExtLaunchingPlugin.getDefault().log(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                Q7ExtLaunchingPlugin.getDefault().log(e);
            }
        }
        return pini;
    }

    protected String getEclipseProductFileProperty(String name) {
        Properties props = this.getEclipseProductFileProperties();
        return props == null ? null : props.getProperty(name);
    }

    public Properties getEclipseProductFileProperties() {
        File iniFile = new File(this.getTargetPlatformProfilePath(), ".eclipseproduct");
        if (!iniFile.exists()) {
            return null;
        }
        Properties pini = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(iniFile);
            pini.load(fis);
            fis.close();
            Properties properties = pini;
            return properties;
        }
        catch (IOException e) {
            Q7ExtLaunchingPlugin.getDefault().log(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                Q7ExtLaunchingPlugin.getDefault().log(e);
            }
        }
        return null;
    }

    @Override
    public String getDefaultApplication() {
        HashSet<String> apps;
        String app = this.getConfigIniProperty(APPLICATION_PROPERTY);
        return this.isValidId(app, apps = new HashSet<String>(Arrays.asList(this.getApplications()))) ? app : (this.isValidId(IDE_APPLICATION, apps) ? IDE_APPLICATION : null);
    }

    @Override
    public String getBundlesList() {
        String bundles = this.getConfigIniProperty(OSGI_BUNDLES);
        return bundles == null ? org.eclipse.pde.internal.core.TargetPlatformHelper.getDefaultBundleList() : org.eclipse.pde.internal.core.TargetPlatformHelper.stripPathInformation((String)bundles);
    }

    protected String getConfigIniProperty(String name) {
        OriginalOrderProperties config = this.getConfigIniProperties();
        if (config == null) {
            return null;
        }
        return config.getProperty(name);
    }

    protected boolean isValidId(String id, Set<String> available) {
        return id == null ? false : available.contains(id);
    }

    @Override
    public String getDefaultProduct() {
        HashSet<String> values = new HashSet<String>(Arrays.asList(this.getProducts()));
        String product = this.getConfigIniProperty(PRODUCT_PROPERTY);
        if (this.isValidId(product, values)) {
            return product;
        }
        product = this.getEclipseProductFileProperty(ID_PROPERTY);
        if (this.isValidId(product, values)) {
            return product;
        }
        List<File> iniFiles = this.getAppIniFiles();
        for (File file : iniFiles) {
            product = this.readProductFromIniFile(file);
            if (product == null) continue;
            return product;
        }
        return null;
    }

    public IBundleContainer[] getBundleContainers() {
        if (this.target == null) {
            return new IBundleContainer[0];
        }
        IBundleContainer[] bundleContainers = this.target.getBundleContainers();
        if (bundleContainers == null) {
            return new IBundleContainer[0];
        }
        return bundleContainers;
    }

    public IResolvedBundle[] getAllBundles() {
        if (this.target == null) {
            return new IResolvedBundle[0];
        }
        return this.target.getAllBundles();
    }

    public IFeatureModel[] getAllFeatures() {
        if (this.target == null) {
            return new IFeatureModel[0];
        }
        return this.target.getAllFeatures();
    }

    @Override
    public InjectionConfiguration getInjectConfig() {
        return this.injectConfig;
    }

    @Override
    public boolean applyInjection(InjectionConfiguration configuration, IProgressMonitor monitor) {
        this.injectConfig = configuration;
        int i = 0;
        while (i < this.extra.size()) {
            if (this.extra.get(i) == this.instanceContainer) {
                this.extra.remove(i);
                break;
            }
            ++i;
        }
        EList entries = configuration.getEntries();
        monitor.beginTask("Apply injection plugins", 20 + entries.size() * 20);
        for (Entry entry : entries) {
            SubProgressMonitor mon = new SubProgressMonitor(monitor, 20);
            if (monitor.isCanceled()) {
                return false;
            }
            boolean result = false;
            if (entry instanceof UpdateSite) {
                result = this.processUpdateSite((IProgressMonitor)mon, (UpdateSite)entry);
            }
            if (entry instanceof Directory) {
                result = this.processDirectory((IProgressMonitor)mon, (Directory)entry);
            }
            if (result) continue;
            return false;
        }
        this.update();
        IStatus resolveStatus = this.resolve(monitor);
        if (!resolveStatus.isOK()) {
            return false;
        }
        this.save();
        return this.validateBundles(monitor);
    }

    private boolean processDirectory(IProgressMonitor monitor, Directory entry) {
        String path = entry.getPath();
        if (path.startsWith("platform:///")) {
            try {
                URL resolve = FileLocator.resolve((URL)URI.create(path).toURL());
                path = resolve.getPath();
            }
            catch (MalformedURLException e) {
                Q7ExtLaunchingPlugin.getDefault().log(e);
            }
            catch (IOException e) {
                Q7ExtLaunchingPlugin.getDefault().log(e);
            }
        }
        IBundleContainer container = PDEHelper.getTargetService().newDirectoryContainer(path);
        this.q7target.addExtra(container);
        this.extra.add(container);
        return true;
    }

    private boolean processUpdateSite(IProgressMonitor monitor, UpdateSite site) {
        URI uri = URI.create(site.getUri());
        IMetadataRepository repository = PDEHelper.safeLoadRepository(uri, monitor);
        IArtifactRepository artifactRepository = PDEHelper.safeLoadArtifactRepository(uri, monitor);
        if (repository == null || artifactRepository == null) {
            if (monitor.isCanceled()) {
                return false;
            }
            Q7ExtLaunchingPlugin.getDefault().log("Failed to load repository from " + uri, null);
            this.errorMessage = "Failed to load update site:" + uri;
            return false;
        }
        ArrayList unitsToInstall = new ArrayList();
        IQuery finalQuery = P2Utils.createQuery((UpdateSite)site);
        IQueryResult result = repository.query(finalQuery, monitor);
        Set availableUnits = result.toSet();
        if (site.isAllUnits()) {
            unitsToInstall.addAll(availableUnits);
        } else {
            P2Utils.expandFeatures((IProgressMonitor)monitor, (IMetadataRepository)repository, (Set)availableUnits);
            Set unitIDs = P2Utils.mapUnitsToId((Set)availableUnits);
            HashSet missingUnits = new HashSet(site.getUnits());
            missingUnits.removeAll(unitIDs);
            if (!missingUnits.isEmpty()) {
                this.errorMessage = "Few units are not available:" + Arrays.toString(missingUnits.toArray());
                return false;
            }
            unitsToInstall.addAll(availableUnits);
        }
        if (unitsToInstall.size() > 0) {
            IInstallableUnit[] unitsAsArray = unitsToInstall.toArray(new IInstallableUnit[unitsToInstall.size()]);
            URI[] uriArray = new URI[]{uri};
            IBundleContainer container = PDEHelper.getTargetService().newIUContainer(unitsAsArray, uriArray, 2);
            this.extra.add(container);
            this.q7target.addExtra(container);
        }
        try {
            IFileArtifactRepository filesRepository = P2TargetUtils.getBundlePool();
            ArrayList toInstall = new ArrayList();
            toInstall.addAll(unitsToInstall);
            P2Utils.installUnits((IProgressMonitor)monitor, (IArtifactRepository)artifactRepository, (IFileArtifactRepository)filesRepository, toInstall, (int)10, null, (boolean)false, (IProvisioningAgent)P2Utils.getProvisioningAgent());
            if (toInstall.size() > 0) {
                this.errorMessage = "Failed to install next units from repository: " + repository.getName();
                for (IInstallableUnit u : toInstall) {
                    this.errorMessage = String.valueOf(this.errorMessage) + "\n" + u.getId();
                }
                return false;
            }
        }
        catch (CoreException coreException) {}
        return true;
    }

    @Override
    public String getIniVMArgs() {
        List<File> iniFiles = this.getAppIniFiles();
        for (File file : iniFiles) {
            String vmArgs = this.readVMArgsFromIniFile(file);
            if (vmArgs == null) continue;
            return vmArgs;
        }
        return null;
    }

    private List<File> getAppIniFiles() {
        File eclipseIniFile;
        int n;
        ArrayList<File> iniFiles = new ArrayList<File>();
        if (this.instanceContainer == null) {
            return iniFiles;
        }
        File installDirectory = new File(this.getTargetPlatformProfilePath());
        if (!installDirectory.exists()) {
            return iniFiles;
        }
        if (Platform.getOS().equals("macosx")) {
            File[] listFiles;
            File[] fileArray = listFiles = installDirectory.listFiles();
            n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().contains(".app")) {
                    installDirectory = new File(file, "/Contents/MacOS");
                    break;
                }
                ++n2;
            }
        }
        if ((eclipseIniFile = new File(installDirectory, "eclipse.ini")).exists()) {
            iniFiles.add(eclipseIniFile);
            return iniFiles;
        }
        File[] list = installDirectory.listFiles();
        if (list != null) {
            File[] fileArray = list;
            int n3 = list.length;
            n = 0;
            while (n < n3) {
                File file = fileArray[n];
                if (file.getName().endsWith(".ini")) {
                    iniFiles.add(file);
                }
                ++n;
            }
        }
        return iniFiles;
    }

    /*
     * Exception decompiling
     */
    private String readProductFromIniFile(File eclipseIniFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private String readLauncherLibraryFromIniFile(File eclipseIniFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<String> parseIniFile(File eclipseIni) {
        if (eclipseIni == null || !eclipseIni.exists()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (String line : Files.readLines((File)eclipseIni, (Charset)Charsets.UTF_8)) {
                if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                result.add(line);
            }
        }
        catch (IOException e) {
            Q7ExtLaunchingPlugin.getDefault().log(e);
        }
        return result;
    }

    private String getVmArg(File eclipseIniFile) {
        List<String> lines = this.parseIniFile(eclipseIniFile);
        int vmIndex = lines.indexOf(VM) + 1;
        return vmIndex == 0 || vmIndex == lines.size() ? null : lines.get(vmIndex);
    }

    @Override
    public String getVmFromIniFile() {
        for (File file : this.getAppIniFiles()) {
            String result = this.getVmArg(file);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private String readVMArgsFromIniFile(File eclipseIniFile) {
        if (!eclipseIniFile.exists()) {
            return null;
        }
        List<String> lines = this.parseIniFile(eclipseIniFile);
        int vmargsIndex = lines.indexOf(VMARGS);
        if (vmargsIndex == -1) {
            return null;
        }
        int vmIndex = (lines = lines.subList(vmargsIndex + 1, lines.size())).indexOf(VM);
        if (vmIndex != -1) {
            lines.subList(vmIndex, Math.min(vmIndex + 2, lines.size())).clear();
        }
        if (lines.isEmpty()) {
            return null;
        }
        return Q7LaunchDelegateUtils.joinCommandArgs(lines);
    }

    @Override
    public String getTemplateConfigLocation() {
        File iniFile = new File(this.getTargetPlatformProfilePath(), "configuration/config.ini");
        if (!iniFile.exists()) {
            return null;
        }
        return iniFile.getAbsolutePath();
    }

    @Override
    public OSArchitecture detectArchitecture(boolean preferCurrentVmArchitecture, StringBuilder detectMsg) {
        boolean isCurrentVm64 = System.getProperty("os.arch", "not null").contains("64");
        boolean has32 = false;
        boolean has64 = false;
        String launcher64 = null;
        String launcher32 = null;
        List<File> iniFiles = this.getAppIniFiles();
        Path targetPlatformProfilePath = new Path(this.getTargetPlatformProfilePath());
        HashSet<String> availableLaunchers = new HashSet<String>();
        String os = Platform.getOS();
        for (File file : iniFiles) {
            String launcherLibrary = this.readLauncherLibraryFromIniFile(file);
            if (launcherLibrary == null || !launcherLibrary.contains(os)) continue;
            String configPath = new Path(file.getAbsolutePath()).removeFirstSegments(targetPlatformProfilePath.segmentCount()).setDevice(null).toOSString();
            if (launcherLibrary.contains("x86_64")) {
                has64 = true;
                launcher64 = "launcher library\n\t\"" + launcherLibrary + "\" specified in config file: " + configPath;
                continue;
            }
            if (!launcherLibrary.contains("x86") && !launcherLibrary.contains("cocoa.macosx")) continue;
            has32 = true;
            launcher32 = "launcher library\n\t\"" + launcherLibrary + "\" specified in config file: " + configPath;
        }
        if (!has32 && !has64) {
            IResolvedBundle[] bundles;
            IResolvedBundle[] iResolvedBundleArray = bundles = this.target.getAllBundles();
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                IResolvedBundle b = iResolvedBundleArray[n2];
                BundleInfo info = b.getBundleInfo();
                String name = info.getSymbolicName();
                if (name.startsWith("org.eclipse.equinox.launcher")) {
                    if (name.contains("x86_64")) {
                        if (name.contains(os)) {
                            has64 = true;
                            launcher64 = "Equinox launcher\n\t- " + new Path(info.getLocation().getPath()).removeFirstSegments(targetPlatformProfilePath.segmentCount()).toOSString();
                        } else {
                            availableLaunchers.add("\t- " + new Path(info.getLocation().getPath()).removeFirstSegments(targetPlatformProfilePath.segmentCount()).toOSString());
                        }
                    } else if (name.contains("x86") || name.contains("cocoa.macosx")) {
                        if (name.contains(os)) {
                            has32 = true;
                            launcher32 = "Equinox launcher\n\t- " + new Path(info.getLocation().getPath()).removeFirstSegments(targetPlatformProfilePath.segmentCount()).toOSString();
                        } else {
                            availableLaunchers.add("\t- " + new Path(info.getLocation().getPath()).removeFirstSegments(targetPlatformProfilePath.segmentCount()).toOSString());
                        }
                    }
                }
                ++n2;
            }
        }
        if (has32 && !has64) {
            if (detectMsg != null) {
                detectMsg.append("32bit arch is selected because AUT uses " + launcher32);
            }
            return OSArchitecture.x86;
        }
        if (!has32 && has64) {
            if (detectMsg != null) {
                detectMsg.append("64bit arch is selected because AUT uses " + launcher64);
            }
            return OSArchitecture.x86_64;
        }
        if (preferCurrentVmArchitecture && has32 && has64) {
            OSArchitecture result;
            OSArchitecture oSArchitecture = result = isCurrentVm64 ? OSArchitecture.x86_64 : OSArchitecture.x86;
            if (detectMsg != null && result.equals((Object)OSArchitecture.x86) && detectMsg != null) {
                detectMsg.append("32bit arch is selected because\n- JVM is 32bit\n- AUT contains both launcher plugins\n\t-" + launcher32 + "\n\t-" + launcher64);
            }
            if (detectMsg != null && result.equals((Object)OSArchitecture.x86_64) && detectMsg != null) {
                detectMsg.append("64bit arch is selected because\n- JVM is 64bit\n- AUT contains both launcher plugins\n\t-" + launcher32 + "\n\t-" + launcher64);
            }
            return result;
        }
        if (detectMsg != null) {
            detectMsg.append("Cannot find appropriate Equinox launcher library.\n");
            if (availableLaunchers.size() > 0) {
                detectMsg.append("Available launchers:\n");
                for (String s : availableLaunchers) {
                    detectMsg.append(s).append("\n");
                }
            }
        }
        return OSArchitecture.Unknown;
    }

    private Map<String, String> getRunlevelsFromSimpleConfigurator() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.getTargetPlatformProfilePath() == null) {
            return result;
        }
        File infoFile = new File(this.getTargetPlatformProfilePath(), SC_BUNDLES_PATH);
        if (!infoFile.exists()) {
            return result;
        }
        FileInputStream input = null;
        try {
            input = new FileInputStream(infoFile);
            for (org.eclipse.equinox.internal.simpleconfigurator.utils.BundleInfo bi : SimpleConfiguratorUtils.readConfiguration((InputStream)input, (URI)infoFile.toURI())) {
                result.put(bi.getSymbolicName(), String.format("%d:%b", bi.getStartLevel(), bi.isMarkedAsStarted()));
            }
        }
        catch (Throwable throwable) {
            FileUtil.safeClose(input);
        }
        return result;
    }

    public Map<String, String> getRunlevelsMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        String osgiBundles = this.getConfigIniProperty(OSGI_BUNDLES);
        if (osgiBundles == null) {
            return result;
        }
        if (osgiBundles.contains(SIMPLECONFIGURATOR)) {
            return this.getRunlevelsFromSimpleConfigurator();
        }
        StringTokenizer tokenizer = new StringTokenizer(osgiBundles, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int index = token.indexOf(64);
            String id = index != -1 ? token.substring(0, index) : token;
            String tk = token.substring(index + 1);
            if (tk.indexOf(":") == -1) {
                tk = String.valueOf(tk) + ":default";
            }
            result.put(id, tk);
        }
        return result;
    }

    public ArrayList<IBundleContainer> getExtra() {
        return this.extra;
    }

    @Override
    public String getRuntimeVersion() {
        if (this.target != null && this.target.isResolved()) {
            String version = "";
            org.osgi.framework.Version runtimeBundle = this.getBundleVersion("org.eclipse.rcptt.tesla.swt");
            if (runtimeBundle != null) {
                version = runtimeBundle.toString();
                if (runtimeBundle.getQualifier().equals("qualifier")) {
                    version = String.valueOf(version) + System.currentTimeMillis();
                }
            }
            return version;
        }
        return "unknown";
    }

    private org.osgi.framework.Version getBundleVersion(String name) {
        if (this.target != null && this.target.isResolved()) {
            IBundleContainer[] containers;
            IBundleContainer[] iBundleContainerArray = containers = this.target.getBundleContainers();
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                IBundleContainer iBundleContainer = iBundleContainerArray[n2];
                IResolvedBundle[] bundles = iBundleContainer.getBundles();
                if (bundles != null) {
                    IResolvedBundle[] iResolvedBundleArray = bundles;
                    int n3 = bundles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResolvedBundle iResolvedBundle = iResolvedBundleArray[n4];
                        if (iResolvedBundle.getBundleInfo().getSymbolicName().equals(name)) {
                            return new org.osgi.framework.Version(iResolvedBundle.getBundleInfo().getVersion());
                        }
                        ++n4;
                    }
                }
                if (iBundleContainer instanceof IUBundleContainer) {
                    IUBundleContainer ct = (IUBundleContainer)iBundleContainer;
                    try {
                        Field ids = IUBundleContainer.class.getDeclaredField("fIds");
                        Field versions = IUBundleContainer.class.getDeclaredField("fVersions");
                        ids.setAccessible(true);
                        versions.setAccessible(true);
                        String[] idsValue = (String[])ids.get(ct);
                        Version[] versionsValue = (Version[])versions.get(ct);
                        int i = 0;
                        while (i < idsValue.length) {
                            String n5 = idsValue[i];
                            if (n5 != null && n5.equals(name)) {
                                return new org.osgi.framework.Version(versionsValue[i].toString());
                            }
                            ++i;
                        }
                    }
                    catch (Throwable e) {
                        Q7ExtLaunchingPlugin.status("Failed to check runtime version", e);
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public String getEquinoxStartupPath(String packageName) {
        IPluginModelBase[] targetModels;
        IPluginModelBase[] iPluginModelBaseArray = targetModels = this.getTargetModels();
        int n = targetModels.length;
        int n2 = 0;
        while (n2 < n) {
            String location;
            IPluginModelBase plugin = iPluginModelBaseArray[n2];
            if (plugin.getPluginBase().getId().equals(packageName) && new File(location = plugin.getInstallLocation()).isFile()) {
                return location;
            }
            ++n2;
        }
        return null;
    }
}

