/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rcptt.core.Scenarios;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.ui.debug.EclLineBreakpointAdapter;
import org.eclipse.rcptt.ui.editors.ecl.EclEditorInputFactory;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.ide.IGotoMarker;

public class EclEditorInput
extends PlatformObject
implements IFileEditorInput,
IPathEditorInput,
IPersistableElement {
    private final IQ7NamedElement scenario;

    public IFile getFile() {
        return (IFile)this.scenario.getResource();
    }

    public IPath getPath() {
        return this.scenario.getResource().getFullPath();
    }

    public EclEditorInput(IQ7NamedElement scenario) {
        this.scenario = scenario;
    }

    public IQ7NamedElement getElement() {
        return this.scenario;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        try {
            return this.scenario.getElementName();
        }
        catch (ModelException modelException) {
            return this.scenario.getName();
        }
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getToolTipText() {
        return this.getName();
    }

    public Object getAdapter(Class adapter) {
        if (IToggleBreakpointsTarget.class.isAssignableFrom(adapter)) {
            return new EclLineBreakpointAdapter(this.scenario.getResource());
        }
        if (IGotoMarker.class.isAssignableFrom(adapter)) {
            return this;
        }
        Object result = this.scenario.getAdapter(adapter);
        if (result != null) {
            return result;
        }
        result = this.scenario.getResource().getAdapter(adapter);
        if (result != null) {
            return result;
        }
        return super.getAdapter(adapter);
    }

    public IStorage getStorage() throws CoreException {
        return new IStorage(){

            public Object getAdapter(Class adapter) {
                return null;
            }

            public boolean isReadOnly() {
                return false;
            }

            public String getName() {
                return EclEditorInput.this.scenario.getName();
            }

            public IPath getFullPath() {
                return EclEditorInput.this.scenario.getPath();
            }

            public InputStream getContents() throws CoreException {
                String content = Scenarios.getScriptContent((Scenario)((Scenario)EclEditorInput.this.scenario.getNamedElement()));
                return new ByteArrayInputStream(content.getBytes());
            }
        };
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.scenario == null ? 0 : this.scenario.getResource().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof EclEditorInput) {
            EclEditorInput other = (EclEditorInput)((Object)obj);
            return !(this.scenario == null ? other.scenario.getResource() != null : !this.scenario.getResource().equals((Object)other.scenario.getResource()));
        }
        if (obj instanceof IFileEditorInput) {
            IFileEditorInput other = (IFileEditorInput)obj;
            return !(this.scenario == null ? other.getFile() != null : !this.scenario.getResource().equals((Object)other.getFile()));
        }
        return false;
    }

    public void saveState(IMemento memento) {
        EclEditorInputFactory.saveState(memento, this);
    }

    public String getFactoryId() {
        return EclEditorInputFactory.getFactoryId();
    }
}

