/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.synchronize.ISyncInfoTreeChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.internal.ui.synchronize.AbstractSynchronizeModelProvider;
import org.eclipse.team.internal.ui.synchronize.CompressedFoldersModelProvider;
import org.eclipse.team.internal.ui.synchronize.FlatModelProvider;
import org.eclipse.team.internal.ui.synchronize.HierarchicalModelProvider;
import org.eclipse.team.internal.ui.synchronize.ISynchronizeModelProvider;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public abstract class CompositeModelProvider
extends AbstractSynchronizeModelProvider {
    private final List providers = new ArrayList();
    private final Map resourceToElements = new HashMap();
    private final Map elementToProvider = new HashMap();

    protected CompositeModelProvider(ISynchronizePageConfiguration configuration, SyncInfoSet set) {
        super(configuration, set);
    }

    protected void addProvider(ISynchronizeModelProvider provider) {
        this.providers.add(provider);
    }

    protected void removeProvider(ISynchronizeModelProvider provider) {
        this.providers.remove(provider);
        provider.dispose();
    }

    protected ISynchronizeModelProvider getProvider(ISynchronizeModelElement element) {
        return (ISynchronizeModelProvider)this.elementToProvider.get(element);
    }

    public ISynchronizeModelElement[] getClosestExistingParents(IResource resource) {
        ISynchronizeModelProvider[] providers = this.getProviders();
        if (providers.length == 0) {
            return new ISynchronizeModelElement[0];
        }
        if (providers.length == 1 && providers[0] instanceof AbstractSynchronizeModelProvider) {
            return ((AbstractSynchronizeModelProvider)providers[0]).getClosestExistingParents(resource);
        }
        ArrayList<ISynchronizeModelElement> result = new ArrayList<ISynchronizeModelElement>();
        int i = 0;
        while (i < providers.length) {
            ISynchronizeModelProvider provider = providers[i];
            if (provider instanceof AbstractSynchronizeModelProvider) {
                ISynchronizeModelElement[] elements = ((AbstractSynchronizeModelProvider)provider).getClosestExistingParents(resource);
                int j = 0;
                while (j < elements.length) {
                    ISynchronizeModelElement element = elements[j];
                    result.add(element);
                    ++j;
                }
            }
            ++i;
        }
        return result.toArray(new ISynchronizeModelElement[result.size()]);
    }

    protected ISynchronizeModelProvider[] getProviders() {
        return this.providers.toArray(new ISynchronizeModelProvider[this.providers.size()]);
    }

    protected ISynchronizeModelProvider[] getProvidersContaining(IResource resource) {
        List elements = (List)this.resourceToElements.get(resource);
        if (elements == null || elements.isEmpty()) {
            return new ISynchronizeModelProvider[0];
        }
        ArrayList<ISynchronizeModelProvider> result = new ArrayList<ISynchronizeModelProvider>();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            ISynchronizeModelElement element = (ISynchronizeModelElement)iter.next();
            result.add(this.getProvider(element));
        }
        return result.toArray(new ISynchronizeModelProvider[result.size()]);
    }

    protected final void handleResourceAdditions(ISyncInfoTreeChangeEvent event) {
        this.handleAdditions(event.getAddedResources());
    }

    protected void handleAdditions(SyncInfo[] resources) {
        int i = 0;
        while (i < resources.length) {
            SyncInfo info = resources[i];
            this.handleAddition(info);
            ++i;
        }
    }

    protected abstract void handleAddition(SyncInfo var1);

    protected final void handleResourceChanges(ISyncInfoTreeChangeEvent event) {
        SyncInfo[] infos = event.getChangedResources();
        int i = 0;
        while (i < infos.length) {
            SyncInfo info = infos[i];
            this.handleChange(info);
            ++i;
        }
    }

    protected void handleChange(SyncInfo info) {
        this.handleRemoval(info.getLocal());
        this.handleAddition(info);
    }

    protected final void handleResourceRemovals(ISyncInfoTreeChangeEvent event) {
        IResource[] resources = event.getRemovedResources();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            this.handleRemoval(resource);
            ++i;
        }
    }

    protected void handleRemoval(IResource resource) {
        ISynchronizeModelProvider[] providers = this.getProvidersContaining(resource);
        int i = 0;
        while (i < providers.length) {
            ISynchronizeModelProvider provider = providers[i];
            this.removeFromProvider(resource, provider);
            ++i;
        }
    }

    protected void removeFromProvider(IResource resource, ISynchronizeModelProvider provider) {
        if (provider != this) {
            provider.getSyncInfoSet().remove(resource);
        }
    }

    protected void nodeAdded(ISynchronizeModelElement node, AbstractSynchronizeModelProvider provider) {
        IResource r = node.getResource();
        if (r != null) {
            ArrayList<ISynchronizeModelElement> elements = (ArrayList<ISynchronizeModelElement>)this.resourceToElements.get(r);
            if (elements == null) {
                elements = new ArrayList<ISynchronizeModelElement>(2);
                this.resourceToElements.put(r, elements);
            }
            elements.add(node);
        }
        this.elementToProvider.put(node, provider);
        super.nodeAdded(node, provider);
    }

    public void modelObjectCleared(ISynchronizeModelElement node) {
        List elements;
        super.modelObjectCleared(node);
        IResource r = node.getResource();
        if (r != null && (elements = (List)this.resourceToElements.get(r)) != null) {
            elements.remove(node);
            if (elements.isEmpty()) {
                this.resourceToElements.remove(r);
            }
        }
        this.elementToProvider.remove(node);
    }

    protected void recursiveClearModelObjects(ISynchronizeModelElement node) {
        super.recursiveClearModelObjects(node);
        if (node == this.getModelRoot()) {
            this.clearProviders();
        }
    }

    private void clearProviders() {
        Iterator iter = this.providers.iterator();
        while (iter.hasNext()) {
            ISynchronizeModelProvider provider = (ISynchronizeModelProvider)iter.next();
            provider.dispose();
        }
        this.providers.clear();
        this.resourceToElements.clear();
        this.elementToProvider.clear();
    }

    protected ISynchronizeModelProvider createModelProvider(ISynchronizeModelElement parent, String id, SyncInfoTree syncInfoTree) {
        if (id != null && id.endsWith("org.eclipse.team.ui.modelprovider_flat")) {
            return new FlatModelProvider(this, parent, this.getConfiguration(), (SyncInfoSet)syncInfoTree);
        }
        if (id != null && id.endsWith("org.eclipse.team.ui.modelprovider_compressedfolders")) {
            return new CompressedFoldersModelProvider(this, parent, this.getConfiguration(), (SyncInfoSet)syncInfoTree);
        }
        return new HierarchicalModelProvider(this, parent, this.getConfiguration(), (SyncInfoSet)syncInfoTree);
    }

    public void dispose() {
        this.clearProviders();
        super.dispose();
    }

    protected boolean hasViewerState() {
        return this.resourceToElements != null && !this.resourceToElements.isEmpty();
    }

    protected ISynchronizeModelElement[] getModelObjects(IResource resource) {
        List elements = (List)this.resourceToElements.get(resource);
        if (elements == null) {
            return new ISynchronizeModelElement[0];
        }
        return elements.toArray(new ISynchronizeModelElement[elements.size()]);
    }
}

