/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.internal.views.markers.MarkerCategory;
import org.eclipse.ui.internal.views.markers.Markers;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

class UIUpdateJob
extends WorkbenchJob {
    private ExtendedMarkersView view;
    private boolean updating;
    private long lastUpdateTime = -1L;

    public UIUpdateJob(ExtendedMarkersView view) {
        super(view.getSite().getShell().getDisplay(), MarkerMessages.MarkerView_19);
        this.view = view;
        this.updating = false;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        TreeViewer viewer = this.view.getViewer();
        if (viewer.getControl().isDisposed()) {
            return Status.CANCEL_STATUS;
        }
        Markers clone = this.view.getActiveViewerInputClone();
        try {
            MarkerCategory[] categories;
            this.updating = true;
            monitor.beginTask(MarkerMessages.MarkerView_19, -1);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            if (this.view.getBuilder().isShowingHierarchy() && this.view.getCategoriesToExpand().isEmpty() && (categories = clone.getCategories()) != null && categories.length == 1) {
                this.view.getCategoriesToExpand().add(categories[0].getDescription());
            }
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            clone = this.view.createViewerInputClone();
            if (clone == null) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            IContentProvider contentProvider = viewer.getContentProvider();
            contentProvider.inputChanged((Viewer)viewer, (Object)this.view.getViewerInput(), (Object)clone);
            viewer.getTree().setRedraw(false);
            viewer.refresh(true);
            if (!monitor.isCanceled()) {
                this.view.reexpandCategories();
            }
            boolean cfr_ignored_0 = this.view.getBuilder().readChangeFlags()[0];
            this.view.updateTitle();
            this.lastUpdateTime = System.currentTimeMillis();
        }
        finally {
            viewer.getTree().setRedraw(true);
            this.view.updateStatusLine((IStructuredSelection)viewer.getSelection());
            this.updating = false;
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    boolean isUpdating() {
        return this.updating;
    }

    public boolean shouldRun() {
        return PlatformUI.isWorkbenchRunning();
    }

    public boolean belongsTo(Object family) {
        if (family.equals(this.view.MARKERSVIEW_UPDATE_JOB_FAMILY)) {
            return true;
        }
        return super.belongsTo(family);
    }

    long getLastUpdateTime() {
        return this.lastUpdateTime;
    }
}

