/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.workbench.texteditor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.rcptt.tesla.core.ui.StyleRangeEntry;
import org.eclipse.rcptt.tesla.core.ui.Text;
import org.eclipse.rcptt.tesla.core.ui.TextPosition;
import org.eclipse.rcptt.tesla.core.ui.UiFactory;
import org.eclipse.rcptt.tesla.core.ui.Widget;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.jface.text.JFaceTextManager;
import org.eclipse.swt.custom.StyledText;

public class TextEditorMapper {
    public static Widget mapExtraValues(SWTUIElement element, Widget result) {
        org.eclipse.swt.widgets.Widget unwrap = element.unwrap();
        if (!(unwrap instanceof StyledText && TextEditorMapper.isTextEditorStyledText(unwrap) && result instanceof Text)) {
            return result;
        }
        StyledText t = (StyledText)unwrap;
        Text text = (Text)result;
        TextViewer viewer = JFaceTextManager.getViewer((StyledText)t);
        int caretOffset = t.getCaretOffset();
        int tabWidth = t.getTabs();
        TextEditorMapper.setCaretPosition(text, viewer, tabWidth, caretOffset);
        TextEditorMapper.updateStyleEntry(text.getStyleAtCaret(), viewer, tabWidth);
        for (StyleRangeEntry styleEntry : text.getStyles()) {
            TextEditorMapper.updateStyleEntry(styleEntry, viewer, tabWidth);
        }
        return result;
    }

    private static void updateStyleEntry(StyleRangeEntry entry, TextViewer viewer, int tabWidth) {
        if (entry == null) {
            return;
        }
        TextPosition start = TextEditorMapper.offsetToPosition(viewer, tabWidth, entry.getStart());
        TextPosition end = TextEditorMapper.offsetToPosition(viewer, tabWidth, entry.getStart() + entry.getLength());
        if (start != null && end != null) {
            entry.setStartPos(start);
            entry.setEndPos(end);
        }
    }

    public static boolean isTextEditorStyledText(Object widget) {
        TextViewer viewer;
        return widget instanceof StyledText && (viewer = JFaceTextManager.getViewer((StyledText)((StyledText)widget))) != null;
    }

    private static void setCaretPosition(Text text, TextViewer viewer, int tabWidth, int offset) {
        TextPosition updatedPosition = TextEditorMapper.offsetToPosition(viewer, tabWidth, offset);
        if (updatedPosition != null) {
            text.setCaretPosition(updatedPosition);
        }
    }

    private static TextPosition offsetToPosition(TextViewer viewer, int tabWidth, int offset) {
        TextPosition result = UiFactory.eINSTANCE.createTextPosition();
        try {
            IDocument document = viewer.getDocument();
            int realOffset = viewer.widgetOffset2ModelOffset(offset);
            int lineAtOffset = document.getLineOfOffset(realOffset);
            int offsetAtLine = document.getLineOffset(lineAtOffset);
            int column = 0;
            int i = offsetAtLine;
            while (i < realOffset) {
                column = '\t' == document.getChar(i) ? (column += tabWidth - (tabWidth == 0 ? 0 : column % tabWidth)) : ++column;
                ++i;
            }
            result.setLine(lineAtOffset + 1);
            result.setColumn(column + 1);
        }
        catch (BadLocationException e) {
            TeslaCore.log((Throwable)e);
            return null;
        }
        return result;
    }
}

