/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.discovery.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.equinox.internal.p2.discovery.AbstractCatalogSource;
import org.eclipse.equinox.internal.p2.discovery.model.AbstractCatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.Certification;
import org.eclipse.equinox.internal.p2.discovery.model.FeatureFilter;
import org.eclipse.equinox.internal.p2.discovery.model.Icon;
import org.eclipse.equinox.internal.p2.discovery.model.Messages;
import org.eclipse.equinox.internal.p2.discovery.model.Overview;
import org.eclipse.equinox.internal.p2.discovery.model.Tag;
import org.eclipse.equinox.internal.p2.discovery.model.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogItem
extends AbstractCatalogItem {
    private AbstractCatalogSource source;
    private CatalogCategory category;
    private boolean selected;
    private Boolean available;
    private Certification certification;
    private final PropertyChangeSupport changeSupport;
    private boolean installed;
    private Set<Tag> tags;
    protected String name;
    protected String provider;
    protected String license;
    protected String description;
    protected String siteUrl;
    protected String id;
    protected String categoryId;
    protected String platformFilter;
    protected String groupId;
    protected List<FeatureFilter> featureFilter = new ArrayList<FeatureFilter>();
    protected List<String> installableUnits = new ArrayList<String>();
    protected Icon icon;
    protected Overview overview;
    protected String certificationId;

    public CatalogItem() {
        this.changeSupport = new PropertyChangeSupport(this);
    }

    public CatalogCategory getCategory() {
        return this.category;
    }

    public void setCategory(CatalogCategory category) {
        this.category = category;
    }

    public AbstractCatalogSource getSource() {
        return this.source;
    }

    public void setSource(AbstractCatalogSource source) {
        this.source = source;
    }

    public Certification getCertification() {
        return this.certification;
    }

    public void setCertification(Certification certification) {
        this.certification = certification;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public Boolean getAvailable() {
        return this.available;
    }

    public void setAvailable(Boolean available) {
        if (available != this.available || available != null && !available.equals(this.available)) {
            Boolean previous = this.available;
            this.available = available;
            this.changeSupport.firePropertyChange("available", previous, this.available);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSiteUrl() {
        return this.siteUrl;
    }

    public void setSiteUrl(String siteUrl) {
        this.siteUrl = siteUrl;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public String getCertificationId() {
        return this.certificationId;
    }

    public void setCertificationId(String certificationId) {
        this.certificationId = certificationId;
    }

    public String getPlatformFilter() {
        return this.platformFilter;
    }

    public void setPlatformFilter(String platformFilter) {
        this.platformFilter = platformFilter;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public List<FeatureFilter> getFeatureFilter() {
        return this.featureFilter;
    }

    public void setFeatureFilter(List<FeatureFilter> featureFilter) {
        this.featureFilter = featureFilter;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Overview getOverview() {
        return this.overview;
    }

    public void setOverview(Overview overview) {
        this.overview = overview;
    }

    public void validate() throws ValidationException {
        if (this.name == null || this.name.length() == 0) {
            throw new ValidationException(Messages.CatalogItem_must_specify_CatalogItem_name);
        }
        if (this.provider == null || this.provider.length() == 0) {
            throw new ValidationException(Messages.CatalogItem_must_specify_CatalogItem_provider);
        }
        if (this.license == null || this.license.length() == 0) {
            throw new ValidationException(Messages.CatalogItem_must_specify_CatalogItem_license);
        }
        if (this.siteUrl == null || this.siteUrl.length() == 0) {
            throw new ValidationException(Messages.CatalogItem_must_specify_CatalogItem_siteUrl);
        }
        try {
            new URL(this.siteUrl);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ValidationException(Messages.CatalogItem_invalid_CatalogItem_siteUrl);
        }
        if (this.id == null || this.id.length() == 0) {
            throw new ValidationException(Messages.CatalogItem_must_specify_CatalogItem_id);
        }
        if (this.categoryId == null || this.categoryId.length() == 0) {
            throw new ValidationException(Messages.CatalogItem_must_specify_CatalogItem_categoryId);
        }
        for (FeatureFilter featureFilterItem : this.featureFilter) {
            featureFilterItem.validate();
        }
        if (this.icon != null) {
            this.icon.validate();
        }
        if (this.overview != null) {
            this.overview.validate();
        }
    }

    public List<String> getInstallableUnits() {
        return this.installableUnits;
    }

    public void setInstallableUnits(List<String> installableUnits) {
        this.installableUnits = installableUnits;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public Set<Tag> getTags() {
        if (this.tags == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.tags);
    }

    public boolean hasTag(Tag tag) {
        return this.tags == null ? false : this.tags.contains(tag);
    }

    public void addTag(Tag tag) {
        if (this.tags == null) {
            this.tags = new HashSet<Tag>();
        }
        this.tags.add(tag);
    }

    public boolean removeTag(Tag tag) {
        if (this.tags == null) {
            return false;
        }
        return this.tags.remove(tag);
    }
}

