/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dialogs;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.search.ManifestEditorOpener;
import org.eclipse.pde.internal.ui.search.dialogs.FilteredPluginArtifactsSelectionDialog;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class PluginArtifactSearchHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        FilteredPluginArtifactsSelectionDialog dialog = new FilteredPluginArtifactsSelectionDialog(window.getShell());
        int status = dialog.open();
        if (status == 0) {
            Object[] result = dialog.getResult();
            Object object = result[0];
            if (object instanceof IFeatureModel) {
                FeatureEditor.openFeatureEditor((IFeatureModel)object);
            } else {
                IEditorPart editorPart = ManifestEditor.open(object, true);
                if (editorPart != null && editorPart instanceof ManifestEditor) {
                    ManifestEditor editor = (ManifestEditor)editorPart;
                    InputContext context = this.getInputContext(object, editor);
                    IDocument document = context.getDocumentProvider().getDocument((Object)context.getInput());
                    IRegion region = ManifestEditorOpener.getAttributeMatch(editor, object, document);
                    editor.openToSourcePage(object, region.getOffset(), region.getLength());
                } else {
                    ManifestEditor.openPluginEditor((IPluginModelBase)object);
                }
            }
        }
        return null;
    }

    private InputContext getInputContext(Object object, ManifestEditor editor) {
        if (object instanceof BaseDescription) {
            return editor.getContextManager().findContext("bundle-context");
        }
        return editor.getContextManager().findContext("plugin-context");
    }
}

