/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.filesystem.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.rcptt.ecl.filesystem.EclFile;
import org.eclipse.rcptt.ecl.filesystem.EclFilesystemPlugin;

public class JavaFile
implements EclFile {
    private final File file;

    public JavaFile(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public Collection<EclFile> getChildren() throws IOException {
        File[] array = this.file.listFiles();
        if (array == null) {
            throw new IOException(this.file + " is not a directory");
        }
        ArrayList<EclFile> rv = new ArrayList<EclFile>(array.length);
        File[] fileArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            rv.add(new JavaFile(f));
            ++n2;
        }
        return rv;
    }

    @Override
    public URI toURI() {
        return this.file.toURI();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    private static boolean deleteRecursive(File path) throws FileNotFoundException {
        if (!path.exists()) {
            throw new FileNotFoundException(path.getAbsolutePath());
        }
        boolean ret = true;
        if (path.isDirectory()) {
            File[] fileArray = path.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                ret = ret && JavaFile.deleteRecursive(f);
                ++n2;
            }
        }
        return ret && path.delete();
    }

    @Override
    public void delete() throws IOException {
        if (!JavaFile.deleteRecursive(this.file)) {
            throw new IOException("Failed to delete " + this.file);
        }
    }

    public static void copy(JavaFile src, JavaFile dst) throws IOException {
        JavaFile.doCopyFile(src.file, dst.file);
    }

    private static void doCopyFile(File src, File dst) throws IOException {
        if (!dst.exists()) {
            dst.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(src).getChannel();
            destination = new FileOutputStream(dst).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
        try {
            if (src.canExecute() && !dst.setExecutable(true, true)) {
                EclFilesystemPlugin.logWarning(String.format("Can't set executable permissions for %s", dst.getAbsolutePath()), null);
            }
        }
        catch (SecurityException e) {
            EclFilesystemPlugin.logWarning(String.format("Can't set executable permissions for %s", dst.getAbsolutePath()), e);
        }
    }

    private void copyStream(InputStream input, OutputStream output) throws IOException {
        try {
            byte[] buffer = new byte[0x100000];
            while (true) {
                int count = input.read(buffer);
                assert (count != 0);
                if (count <= 0) break;
                output.write(buffer, 0, count);
            }
            return;
        }
        finally {
            input.close();
            output.close();
        }
    }

    @Override
    public void append(InputStream is) throws IOException {
        this.mkdirs();
        FileOutputStream os = new FileOutputStream(this.file, true);
        this.copyStream(is, os);
    }

    @Override
    public void write(InputStream is) throws IOException {
        this.mkdirs();
        FileOutputStream os = new FileOutputStream(this.file, false);
        this.copyStream(is, os);
    }

    private void mkdirs() throws IOException {
        File parent = this.file.getParentFile();
        if (parent == null) {
            return;
        }
        parent.mkdirs();
    }

    @Override
    public InputStream read() throws IOException {
        return new FileInputStream(this.file);
    }
}

