/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ext.ui;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.pde.internal.core.util.VMUtil;
import org.eclipse.pde.internal.launching.launcher.VMHelper;
import org.eclipse.pde.internal.ui.launcher.JREBlock;
import org.eclipse.pde.internal.ui.launcher.ProgramBlock;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.pde.ui.launcher.MainTab;
import org.eclipse.rcptt.internal.launching.ext.JDTUtils;
import org.eclipse.rcptt.internal.launching.ext.OSArchitecture;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;
import org.eclipse.rcptt.internal.launching.ext.ui.AUTLocationBlock;
import org.eclipse.rcptt.internal.launching.ext.ui.AUTProgramBlock;
import org.eclipse.rcptt.internal.launching.ext.ui.Activator;
import org.eclipse.rcptt.internal.launching.ext.ui.ExternalTabGroup;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class ExternalAUTMainTab
extends MainTab {
    private AUTLocationBlock fLocationBlock;
    private AUTProgramBlock fAUTProgramBlock;
    private ITargetPlatformHelper currentTargetPlatform;
    private ExternalTabGroup group;

    public ExternalAUTMainTab(ExternalTabGroup group) {
        this.group = group;
        this.createLocationBlock();
    }

    private void createLocationBlock() {
        this.fLocationBlock = new AUTLocationBlock(this);
    }

    protected void createJREBlock() {
        this.fJreBlock = new JREBlock((AbstractLauncherTab)this){
            OSArchitecture configArch;

            IVMInstall getSelectedJVM() {
                try {
                    IExecutionEnvironment environment;
                    Button fJreButton = (Button)this.getSuperfield("fJreButton");
                    Combo fJreCombo = (Combo)this.getSuperfield("fJreCombo");
                    Combo fEeCombo = (Combo)this.getSuperfield("fEeCombo");
                    if (fJreButton.getSelection()) {
                        if (fJreCombo.getSelectionIndex() != -1) {
                            String jreName = fJreCombo.getText();
                            IVMInstall install = VMHelper.getVMInstall((String)jreName);
                            return install;
                        }
                    } else if (fEeCombo.getSelectionIndex() != -1 && (environment = VMUtil.getExecutionEnvironment((String)this.parseEESelection(fEeCombo.getText()))) != null) {
                        return environment.getDefaultVM();
                    }
                }
                catch (Throwable e) {
                    Q7UIPlugin.log((Throwable)e);
                }
                return null;
            }

            private String parseEESelection(String selection) {
                int index = selection.indexOf(" (");
                if (index == -1) {
                    return selection;
                }
                return selection.substring(0, index);
            }

            private Object getSuperfield(String name) throws NoSuchFieldException, IllegalAccessException {
                Field field = JREBlock.class.getDeclaredField(name);
                field.setAccessible(true);
                return field.get((Object)this);
            }

            public void initializeFrom(ILaunchConfiguration config) throws CoreException {
                super.initializeFrom(config);
                String archAttrValue = config.getAttribute("com.xored.launching.common.attrArch", "");
                this.configArch = archAttrValue.isEmpty() ? null : OSArchitecture.valueOf((String)archAttrValue);
            }

            public String validate() {
                String value = super.validate();
                if (ExternalAUTMainTab.this.currentTargetPlatform != null) {
                    StringBuilder archDetect = new StringBuilder();
                    OSArchitecture architecture = this.configArch == null ? ExternalAUTMainTab.this.currentTargetPlatform.detectArchitecture(true, archDetect) : this.configArch;
                    boolean haveArch = false;
                    IVMInstall install = this.getSelectedJVM();
                    OSArchitecture jvmArch = null;
                    if (install != null && ((jvmArch = JDTUtils.detect((IVMInstall)install)).equals((Object)architecture) || jvmArch.equals((Object)OSArchitecture.x86_64) && JDTUtils.canRun32bit((IVMInstall)install))) {
                        haveArch = true;
                    }
                    if (install == null) {
                        return "The selected AUT requires " + (OSArchitecture.x86.equals((Object)architecture) ? "32 bit" : "64 bit") + " but selected JVM is " + (OSArchitecture.x86.equals((Object)jvmArch) ? "32 bit" : "64 bit");
                    }
                    if (!haveArch) {
                        return "The selected AUT requires " + (OSArchitecture.x86.equals((Object)architecture) ? "32 bit" : "64 bit") + " Java VM which cannot be found.";
                    }
                }
                return value;
            }
        };
    }

    protected void createProgramBlock() {
        this.fProgramBlock = new ProgramBlock((AbstractLauncherTab)this){

            public void initializeFrom(ILaunchConfiguration config) throws CoreException {
            }

            public void performApply(ILaunchConfigurationWorkingCopy config) {
            }
        };
        this.fAUTProgramBlock = new AUTProgramBlock(this);
    }

    public void createControl(Composite parent) {
        final ScrolledComposite scrollContainer = new ScrolledComposite(parent, 512);
        scrollContainer.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite((Composite)scrollContainer, 0);
        scrollContainer.setContent((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        this.fLocationBlock.createControl(composite);
        this.fDataBlock.createControl(composite);
        this.fAUTProgramBlock.createControl(composite);
        this.fJreBlock.createControl(composite);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                Control child = (Control)e.widget;
                Rectangle bounds = child.getBounds();
                Rectangle area = scrollContainer.getClientArea();
                Point origin = scrollContainer.getOrigin();
                if (origin.x > bounds.x) {
                    origin.x = Math.max(0, bounds.x);
                }
                if (origin.y > bounds.y) {
                    origin.y = Math.max(0, bounds.y);
                }
                if (origin.x + area.width < bounds.x + bounds.width) {
                    origin.x = Math.max(0, bounds.x + bounds.width - area.width);
                }
                if (origin.y + area.height < bounds.y + bounds.height) {
                    origin.y = Math.max(0, bounds.y + bounds.height - area.height);
                }
                scrollContainer.setOrigin(origin);
            }
        };
        Control[] controls = composite.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].addListener(26, listener);
            ++i;
        }
        Dialog.applyDialogFont((Control)composite);
        composite.setSize(composite.computeSize(-1, -1));
        scrollContainer.setExpandHorizontal(true);
        this.setControl((Control)scrollContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.pde.doc.user.launcher_basic");
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        try {
            this.fLocationBlock.initializeFrom(config);
            this.fAUTProgramBlock.initializeFrom(config);
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    void setStatus(final IStatus status) {
        if (!status.isOK() && !status.matches(8)) {
            Q7ExtLaunchingPlugin.log((IStatus)status);
        }
        this.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (status.isOK()) {
                    ExternalAUTMainTab.this.setErrorMessage(null);
                    ExternalAUTMainTab.this.setMessage(null);
                } else if (status.matches(4)) {
                    ExternalAUTMainTab.this.setMessage(null);
                    ExternalAUTMainTab.this.setErrorMessage(status.getMessage());
                } else {
                    ExternalAUTMainTab.this.setMessage(status.getMessage());
                    ExternalAUTMainTab.this.setErrorMessage(null);
                }
            }
        });
    }

    public void validateTab() {
        super.validateTab();
        if (this.getErrorMessage() == null) {
            this.setStatus(this.fLocationBlock.getStatus());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        super.performApply(config);
        this.fLocationBlock.performApply(config);
        this.fAUTProgramBlock.performApply(config);
    }

    public void setCurrentTargetPlatform(ITargetPlatformHelper info) {
        this.currentTargetPlatform = info;
        this.fAUTProgramBlock.updateInfo(this.currentTargetPlatform);
    }

    public ITargetPlatformHelper getTarget() {
        return this.currentTargetPlatform;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        this.fAUTProgramBlock.setDefaults(config);
    }

    public void doUpdate(ITargetPlatformHelper info) {
        this.group.doUpdate(info);
    }
}

