/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.p2utils;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.director.PermissiveSlicer;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.CollectAction;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.mirroring.Mirroring;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.provisional.ITargetPlatformService;
import org.eclipse.rcptt.launching.injection.UpdateSite;
import org.eclipse.rcptt.launching.p2utils.Q7P2UtilsActivator;
import org.eclipse.rcptt.util.FileUtil;

public class P2Utils {
    public static ITargetPlatformService getTargetService() {
        return (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class.getName());
    }

    public static IMetadataRepositoryManager getRepositoryManager() throws CoreException {
        return P2Utils.getRepositoryManager(P2Utils.getProvisioningAgent());
    }

    public static IProvisioningAgent getProvisioningAgent() {
        return (IProvisioningAgent)PDECore.getDefault().acquireService(IProvisioningAgent.SERVICE_NAME);
    }

    public static IMetadataRepositoryManager getRepositoryManager(IProvisioningAgent agent) throws CoreException {
        if (agent == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", "Failed to locate repository. Can't get service " + IProvisioningAgent.SERVICE_NAME));
        }
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (manager == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", "Failed to locate repository. No metadata repository manager found."));
        }
        return manager;
    }

    public static IArtifactRepositoryManager getArtifactRepositoryManager() throws CoreException {
        return P2Utils.getArtifactRepositoryManager(P2Utils.getProvisioningAgent());
    }

    public static IArtifactRepositoryManager getArtifactRepositoryManager(IProvisioningAgent agent) throws CoreException {
        if (agent == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", "Failed to locate repository. Can't get service " + IProvisioningAgent.SERVICE_NAME));
        }
        IArtifactRepositoryManager manager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        if (manager == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", "Failed to locate repository. No metadata repository manager found."));
        }
        return manager;
    }

    public static IMetadataRepository safeLoadRepository(URI uri, IProgressMonitor monitor, IProvisioningAgent agent) throws CoreException {
        try {
            IMetadataRepositoryManager rm = P2Utils.getRepositoryManager(agent);
            rm.removeRepository(uri);
            try {
                rm.refreshRepository(uri, monitor);
            }
            catch (ProvisionException provisionException) {}
            return rm.loadRepository(uri, monitor);
        }
        catch (RuntimeException e) {
            if (e instanceof OperationCanceledException || monitor.isCanceled()) {
                throw new CoreException((IStatus)new Status(8, "org.eclipse.rcptt.launching.p2utils", "Repository load cancelled", (Throwable)e));
            }
            throw e;
        }
    }

    public static IArtifactRepository safeLoadArtifactRepository(URI uri, IProgressMonitor monitor, IProvisioningAgent agent) {
        try {
            IArtifactRepositoryManager rm = P2Utils.getArtifactRepositoryManager(agent);
            rm.removeRepository(uri);
            try {
                rm.refreshRepository(uri, monitor);
            }
            catch (ProvisionException provisionException) {}
            return rm.loadRepository(uri, monitor);
        }
        catch (Throwable e) {
            if (e instanceof OperationCanceledException || monitor.isCanceled()) {
                return null;
            }
            Q7P2UtilsActivator.getDefault().log(e);
            return null;
        }
    }

    public static Set<String> mapUnitsToId(Set<IInstallableUnit> availableUnits) {
        HashSet<String> unitIDs = new HashSet<String>();
        for (IInstallableUnit u : availableUnits) {
            unitIDs.add(u.getId());
        }
        return unitIDs;
    }

    public static List<IQuery<IInstallableUnit>> mapUnitsToQuery(Set<String> units) {
        ArrayList<IQuery<IInstallableUnit>> queries = new ArrayList<IQuery<IInstallableUnit>>();
        for (String id : units) {
            queries.add((IQuery<IInstallableUnit>)QueryUtil.createIUQuery((String)id));
        }
        return queries;
    }

    public static List<IQuery<IInstallableUnit>> mapUnitsToCategoryQuery(Collection<IInstallableUnit> units) {
        ArrayList<IQuery<IInstallableUnit>> queries = new ArrayList<IQuery<IInstallableUnit>>();
        for (IInstallableUnit unit : units) {
            Collection requirements = unit.getRequirements();
            for (IRequirement req : requirements) {
                queries.add((IQuery<IInstallableUnit>)QueryUtil.createMatchQuery((IExpression)req.getMatches(), (Object[])new Object[0]));
            }
        }
        return queries;
    }

    public static IQuery<IInstallableUnit> createQuery(UpdateSite site) {
        IQuery finalQuery = null;
        if (site.isAllUnits()) {
            finalQuery = QueryUtil.ALL_UNITS;
        } else {
            List<IQuery<IInstallableUnit>> items = P2Utils.mapUnitsToQuery(new HashSet<String>((Collection<String>)site.getUnits()));
            finalQuery = QueryUtil.createLatestQuery((IQuery)QueryUtil.createCompoundQuery(items, (boolean)false));
        }
        return finalQuery;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IStatus validateBundle(File file) {
        if (!file.exists()) {
            return new Status(4, "org.eclipse.rcptt.launching.p2utils", "File " + file + " does not exist");
        }
        if (file.isDirectory()) {
            return Status.OK_STATUS;
        }
        if (!file.getName().toLowerCase().endsWith(".jar")) {
            return Status.OK_STATUS;
        }
        stream = null;
        zin = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(file));
            zin = new ZipInputStream(stream);
            names = new HashSet<String>();
lbl13:
            // 2 sources

            while (true) {
                entry = zin.getNextEntry();
                if (entry != null) ** GOTO lbl-1000
                if (names.size() == 0) {
                    var6_6 = new Status(4, "org.eclipse.rcptt.launching.p2utils", "Empty ZIP archive " + file);
                }
                ** GOTO lbl-1000
                break;
            }
        }
        catch (Throwable e) {
            var6_8 = new Status(4, "org.eclipse.rcptt.launching.p2utils", "Failed to check " + file, e);
            FileUtil.safeClose((Closeable)zin);
            FileUtil.safeClose((Closeable)stream);
            return var6_8;
        }
        catch (Throwable var5_9) {
            FileUtil.safeClose(zin);
            FileUtil.safeClose(stream);
            throw var5_9;
        }
        FileUtil.safeClose((Closeable)zin);
        FileUtil.safeClose((Closeable)stream);
        return var6_6;
lbl-1000:
        // 1 sources

        {
            var6_7 = Status.OK_STATUS;
        }
        FileUtil.safeClose((Closeable)zin);
        FileUtil.safeClose((Closeable)stream);
        return var6_7;
lbl-1000:
        // 1 sources

        {
            names.add(entry.getName());
            ** continue;
        }
    }

    public static void installUnits(IProgressMonitor monitor, IArtifactRepository artifactRepository, IFileArtifactRepository filesRepository, List<IInstallableUnit> toInstall, int installTryCount, ILogMonitor logMonitor, boolean useRaw, IProvisioningAgent agent) throws CoreException {
        if (logMonitor != null) {
            logMonitor.log("Downloading artifacts to: " + filesRepository.getLocation().toString());
        }
        filesRepository.setProperty("eclipse.p2.force.threading", "true");
        while (toInstall.size() > 0) {
            ArrayList<IArtifactKey> keys = new ArrayList<IArtifactKey>();
            for (IInstallableUnit unit : toInstall) {
                keys.addAll(unit.getArtifacts());
            }
            ArrayList<IArtifactRequest> requests = new ArrayList<IArtifactRequest>();
            if (useRaw) {
                P2Utils.rawMirror(artifactRepository, filesRepository, logMonitor, agent, keys);
            } else {
                for (IInstallableUnit unit : toInstall) {
                    Collection toDownload = unit.getArtifacts();
                    for (IArtifactKey key : toDownload) {
                        Map repositoryProperties = CollectAction.createArtifactDescriptorProperties((IInstallableUnit)unit);
                        requests.add(Util.getArtifactRepositoryManager((IProvisioningAgent)agent).createMirrorRequest(key, (IArtifactRepository)filesRepository, null, repositoryProperties));
                    }
                }
                if (requests.size() == 0) break;
                artifactRepository.getArtifacts(requests.toArray(new IArtifactRequest[requests.size()]), monitor);
            }
            MultiStatus rv = new MultiStatus("org.eclipse.rcptt.launching.p2utils", 0, "Failed to install bundles", null);
            ArrayList<IInstallableUnit> installedOK = new ArrayList<IInstallableUnit>();
            for (IInstallableUnit unit : toInstall) {
                Collection toDownload = unit.getArtifacts();
                if (toDownload == null || toDownload.size() == 0) {
                    installedOK.add(unit);
                    continue;
                }
                for (IArtifactKey key : toDownload) {
                    File file = filesRepository.getArtifactFile(key);
                    if (file != null && file.exists()) {
                        IStatus result = P2Utils.validateBundle(file);
                        if (result.isOK()) {
                            installedOK.add(unit);
                        } else {
                            rv.add(result);
                        }
                    }
                    filesRepository.removeDescriptor(key, monitor);
                }
            }
            toInstall.removeAll(installedOK);
            if (toInstall.size() == 0) {
                return;
            }
            if (--installTryCount < 0) {
                throw new CoreException((IStatus)rv);
            }
            if (logMonitor == null) continue;
            logMonitor.log("Artifacts left on iteration: " + toInstall.size() + " retrying: " + installTryCount + "delay: 5 seconds");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
        }
    }

    private static void rawMirror(IArtifactRepository artifactRepository, IFileArtifactRepository filesRepository, ILogMonitor logMonitor, IProvisioningAgent agent, List<IArtifactKey> keys) {
        MultiStatus result;
        Mirroring mirror = new Mirroring(artifactRepository, (IArtifactRepository)filesRepository, true);
        mirror.setCompare(false);
        mirror.setComparatorId(null);
        mirror.setBaseline(null);
        mirror.setValidate(false);
        mirror.setCompareExclusions(null);
        mirror.setTransport((Transport)agent.getService(Transport.SERVICE_NAME));
        if (keys.size() > 0) {
            mirror.setArtifactKeys(keys.toArray(new IArtifactKey[keys.size()]));
        }
        if ((result = mirror.run(false, false)) != null && !result.isOK() && logMonitor != null) {
            logMonitor.log("Mirroring is failed: " + result.getMessage());
        }
    }

    public static IQuery<IInstallableUnit> createContainmentQuery(Set<IInstallableUnit> availableUnits) {
        return QueryUtil.createCompoundQuery(P2Utils.mapUnitsToCategoryQuery(availableUnits), (boolean)false);
    }

    public static void expandFeatures(IProgressMonitor monitor, IMetadataRepository repository, Set<IInstallableUnit> availableUnits) {
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)repository, new Hashtable(), false, true, true, true, false);
        IQueryable slice = slicer.slice(availableUnits.toArray(new IInstallableUnit[availableUnits.size()]), monitor);
        availableUnits.addAll(slice.query(QueryUtil.ALL_UNITS, monitor).toSet());
    }

    public static interface ILogMonitor {
        public void log(String var1);
    }
}

