/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching;

import com.google.common.base.Preconditions;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.core.ecl.core.model.ExecutionPhase;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.launching.IExecutable;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;

public abstract class Executable
implements IExecutable {
    protected static final Executable[] EMPTY = new Executable[0];
    private static final IStatus cancelledForPreviousFailures = new Status(8, "org.eclipse.rcptt.launching", "Execution was canceled due to previous failures");
    private IStatus result;
    private IExecutable.State state = IExecutable.State.WAITING;
    private long time;
    private Executable parent;
    private final ExecutionPhase phase;
    private final boolean debug;
    private IStatus overridingResult = null;

    public abstract Executable[] getChildren();

    final void executeAndRememberResult(Listener listener) throws InterruptedException {
        long startTime;
        block29: {
            if (this.state != IExecutable.State.WAITING) {
                throw new IllegalStateException("Can't start in " + (Object)((Object)this.state) + " state");
            }
            this.state = IExecutable.State.LAUNCHING;
            startTime = System.currentTimeMillis();
            this.startLaunching();
            listener.onStatusChange(this);
            this.result = this.execute();
            if (this.result == null) {
                throw new NullPointerException("Null result");
            }
            if (this.overridingResult != null) {
                this.result = this.overridingResult;
            }
            if (this.result.isOK()) break block29;
            this.time = System.currentTimeMillis() - startTime;
            try {
                Preconditions.checkNotNull((Object)this.result);
                try {
                    this.result = this.postExecute(listener, this.result);
                }
                catch (Throwable e) {
                    this.result = Q7LaunchingPlugin.createStatus(e);
                }
            }
            catch (Throwable throwable) {
                this.state = this.result != null && this.result.isOK() ? IExecutable.State.PASSED : IExecutable.State.FAILED;
                listener.onStatusChange(this);
                throw throwable;
            }
            this.state = this.result != null && this.result.isOK() ? IExecutable.State.PASSED : IExecutable.State.FAILED;
            listener.onStatusChange(this);
            return;
        }
        try {
            try {
                IStatus cancelReason = null;
                Executable[] executableArray = this.getChildren();
                int n = executableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Executable child = executableArray[n2];
                    if (cancelReason != null) {
                        child.cancel(listener, cancelReason);
                    } else {
                        child.executeAndRememberResult(listener);
                        IStatus rv = this.handleChildResult(child.getResultStatus());
                        if (!rv.isOK()) {
                            this.result = rv;
                            cancelReason = cancelledForPreviousFailures;
                        }
                    }
                    ++n2;
                }
            }
            catch (InterruptedException e) {
                this.state = IExecutable.State.FAILED;
                this.result = Status.CANCEL_STATUS;
                throw e;
            }
            catch (Throwable e) {
                this.state = IExecutable.State.FAILED;
                this.result = Q7LaunchingPlugin.createStatus(e);
                this.time = System.currentTimeMillis() - startTime;
                try {
                    Preconditions.checkNotNull((Object)this.result);
                    try {
                        this.result = this.postExecute(listener, this.result);
                    }
                    catch (Throwable e2) {
                        this.result = Q7LaunchingPlugin.createStatus(e2);
                    }
                }
                catch (Throwable throwable) {
                    this.state = this.result != null && this.result.isOK() ? IExecutable.State.PASSED : IExecutable.State.FAILED;
                    listener.onStatusChange(this);
                    throw throwable;
                }
                this.state = this.result != null && this.result.isOK() ? IExecutable.State.PASSED : IExecutable.State.FAILED;
                listener.onStatusChange(this);
            }
        }
        catch (Throwable throwable) {
            this.time = System.currentTimeMillis() - startTime;
            try {
                Preconditions.checkNotNull((Object)this.result);
                try {
                    this.result = this.postExecute(listener, this.result);
                }
                catch (Throwable e) {
                    this.result = Q7LaunchingPlugin.createStatus(e);
                }
            }
            catch (Throwable throwable2) {
                this.state = this.result != null && this.result.isOK() ? IExecutable.State.PASSED : IExecutable.State.FAILED;
                listener.onStatusChange(this);
                throw throwable2;
            }
            this.state = this.result != null && this.result.isOK() ? IExecutable.State.PASSED : IExecutable.State.FAILED;
            listener.onStatusChange(this);
            throw throwable;
        }
        this.time = System.currentTimeMillis() - startTime;
        try {
            Preconditions.checkNotNull((Object)this.result);
            try {
                this.result = this.postExecute(listener, this.result);
            }
            catch (Throwable e) {
                this.result = Q7LaunchingPlugin.createStatus(e);
            }
        }
        catch (Throwable throwable) {
            this.state = this.result != null && this.result.isOK() ? IExecutable.State.PASSED : IExecutable.State.FAILED;
            listener.onStatusChange(this);
            throw throwable;
        }
        this.state = this.result != null && this.result.isOK() ? IExecutable.State.PASSED : IExecutable.State.FAILED;
        listener.onStatusChange(this);
    }

    public void cancel(Listener listener, IStatus status) {
        switch (this.state) {
            case LAUNCHING: {
                this.state = IExecutable.State.FAILED;
            }
            case WAITING: {
                this.result = status;
                listener.onStatusChange(this);
            }
        }
        Executable[] executableArray = this.getChildren();
        int n = executableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Executable child = executableArray[n2];
            child.cancel(listener, status);
            ++n2;
        }
    }

    protected IStatus handleChildResult(IStatus resultStatus) {
        return resultStatus;
    }

    protected abstract IStatus execute() throws InterruptedException;

    protected Executable getParent() {
        return this.parent;
    }

    protected void setParent(Executable parent) {
        this.parent = parent;
    }

    protected Executable(boolean debug) {
        this(debug, ExecutionPhase.AUTO);
    }

    protected Executable(boolean debug, ExecutionPhase phase) {
        this.debug = debug;
        this.phase = phase;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    public void dispose() {
        Executable[] childs = this.getChildren();
        if (childs != null) {
            Executable[] executableArray = childs;
            int n = childs.length;
            int n2 = 0;
            while (n2 < n) {
                Executable child = executableArray[n2];
                child.dispose();
                ++n2;
            }
        }
    }

    protected IStatus postExecute(Listener listener, IStatus result) {
        return result;
    }

    @Override
    public Report getResultReport() {
        return null;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public ExecutionPhase getPhase() {
        return this.phase;
    }

    public static IExecutable.State max(IExecutable.State a, IExecutable.State b) {
        return a.ordinal() >= b.ordinal() ? a : b;
    }

    public void startLaunching() {
    }

    @Override
    public final IExecutable.State getStatus() {
        IExecutable.State status = this.state;
        Executable[] executableArray = this.getChildren();
        int n = executableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Executable child = executableArray[n2];
            status = Executable.max(status, child.getStatus());
            ++n2;
        }
        return status;
    }

    @Override
    public final IStatus getResultStatus() {
        switch (this.state) {
            case PASSED: {
                return Status.OK_STATUS;
            }
            case WAITING: 
            case LAUNCHING: {
                return this.result == null ? Status.OK_STATUS : this.result;
            }
            case FAILED: {
                return this.result;
            }
        }
        throw new IllegalStateException("Unknown state");
    }

    @Override
    public long getTime() {
        return this.time;
    }

    public void terminateWithResult(IStatus status) {
        Preconditions.checkState((this.overridingResult == null ? 1 : 0) != 0);
        Executable[] executableArray = this.getChildren();
        int n = executableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Executable child = executableArray[n2];
            child.terminateWithResult(status);
            ++n2;
        }
        this.overridingResult = status;
    }

    public static interface Listener {
        public void onStatusChange(Executable var1);

        public void updateSessionCounters(Executable var1, IStatus var2);

        public static class Adapter
        implements Listener {
            @Override
            public void onStatusChange(Executable executable) {
            }

            @Override
            public void updateSessionCounters(Executable executable, IStatus status) {
            }
        }
    }
}

