/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.rcptt.core.ecl.core.model.ExecutionPhase;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.SuperContextSupport;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.scenario.GroupContext;
import org.eclipse.rcptt.core.scenario.SuperContext;
import org.eclipse.rcptt.core.scenario.TestSuiteItem;
import org.eclipse.rcptt.core.scenario.UnresolvedContext;
import org.eclipse.rcptt.core.scenario.UnresolvedVerification;
import org.eclipse.rcptt.core.utils.ModelCycleDetector;
import org.eclipse.rcptt.core.utils.SortingUtils;
import org.eclipse.rcptt.core.workspace.IWorkspaceFinder;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.core.workspace.WorkspaceFinder;
import org.eclipse.rcptt.internal.launching.EmptySuperContextExecutable;
import org.eclipse.rcptt.internal.launching.Executable;
import org.eclipse.rcptt.internal.launching.ExecutionSession;
import org.eclipse.rcptt.internal.launching.GroupExecutable;
import org.eclipse.rcptt.internal.launching.PrepareExecutionWrapper;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.internal.launching.Q7Process;
import org.eclipse.rcptt.internal.launching.Q7TestLaunch;
import org.eclipse.rcptt.internal.launching.TestSuiteExecutable;
import org.eclipse.rcptt.internal.launching.UnresolvedContextExecutable;
import org.eclipse.rcptt.internal.launching.UnresolvedVerificationExecutable;
import org.eclipse.rcptt.internal.launching.ecl.EclContextExecutable;
import org.eclipse.rcptt.internal.launching.ecl.EclDebugContextExecutable;
import org.eclipse.rcptt.internal.launching.ecl.EclDebugTestExecutable;
import org.eclipse.rcptt.internal.launching.ecl.EclDebugVerificationExecutable;
import org.eclipse.rcptt.internal.launching.ecl.EclScenarioExecutable;
import org.eclipse.rcptt.internal.launching.ecl.EclVerificationExecutable;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.IExecutable;
import org.eclipse.rcptt.launching.IExecutionSession;
import org.eclipse.rcptt.launching.ILaunchListener;
import org.eclipse.rcptt.launching.TestCaseDebugger;

public class Q7LaunchManager {
    public static final String Q7_TEST_SUITE_LAUNCH_ID = "org.eclipse.rcptt.launching.scenarios";
    private static boolean headless = false;
    private final Map<String, ExecThread> threads = new HashMap<String, ExecThread>();
    private final List<ILaunchListener> listeners;
    private final List<ExecutionSession> sessions = new ArrayList<ExecutionSession>();
    private static final String EXPT_ID = "org.eclipse.rcptt.launching.listeners";
    private static final String ATTR_CLASS = "class";
    private static final String PREFERENCE_HISTORY_MAX_EXECUTIONS_COUNT = "history_max_executions_count";
    private static final int HISTORY_MAX_EXECUTIONS_DEFAULT = 30;
    private boolean debuggingActive = false;

    public static boolean isConnectionException(IStatus status) {
        return status.getMessage().equals("Connection reset") || status.getMessage().equals("Connection refused: connect");
    }

    public static void makeHeadless() {
        headless = true;
    }

    public static synchronized Q7LaunchManager getInstance() {
        if (SingletonHolder.INSTANCE == null) {
            SingletonHolder.INSTANCE = new Q7LaunchManager();
        }
        return SingletonHolder.INSTANCE;
    }

    private Q7LaunchManager() {
        IConfigurationElement[] elements;
        ArrayList<ILaunchListener> list = new ArrayList<ILaunchListener>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXPT_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String uiAttr = element.getAttribute("ui");
            if (!headless || !"true".equals(uiAttr)) {
                try {
                    ILaunchListener listener = (ILaunchListener)element.createExecutableExtension(ATTR_CLASS);
                    list.add(listener);
                }
                catch (CoreException e) {
                    Q7LaunchingPlugin.log(e);
                }
            }
            ++n2;
        }
        this.listeners = list;
    }

    public synchronized boolean isRunning() {
        return !this.threads.isEmpty();
    }

    public synchronized void stop() {
        for (String launch : new HashSet<String>(this.threads.keySet())) {
            ExecThread thread = this.threads.get(launch);
            if (thread == null) continue;
            thread.stop();
            this.threads.remove(launch);
        }
    }

    public synchronized void addListener(ILaunchListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(ILaunchListener listener) {
        this.listeners.add(listener);
    }

    public void execute(IQ7NamedElement[] elements, AutLaunch aut, Q7TestLaunch launch, IWorkspaceFinder finder, Map<IQ7NamedElement, List<List<String>>> namedVariants) throws CoreException {
        if (ModelCycleDetector.hasCycles((IQ7NamedElement[])elements)) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.launching", "Can't execute testcases/testsuites. Circles detected."));
        }
        if (finder == null) {
            finder = WorkspaceFinder.getInstance();
        }
        Q7Process process = new Q7Process((ILaunch)launch, aut);
        ExecutableFabric executableFabric = new ExecutableFabric(aut, finder, process.getDebugger());
        Executable[] executables = executableFabric.map(elements, namedVariants);
        if (executableFabric.unresolvedItems.size() > 0 && !this.checkContinueOnUnresolved()) {
            return;
        }
        ExecutionSession session = new ExecutionSession(launch.getLaunchConfiguration().getName(), executables, aut);
        int maxEntries = this.getMaxHistoryEntries();
        while (this.sessions.size() >= maxEntries) {
            ExecutionSession rSession = this.sessions.remove(0);
            rSession.dispose();
        }
        if (!this.cancelDebugExecution(aut, null)) {
            launch.terminate();
            return;
        }
        launch.setSession(session);
        this.execute(session, process);
    }

    private boolean checkContinueOnUnresolved() {
        Status status = new Status(4, "org.eclipse.rcptt.launching", 123129, "There are unresolved test suite items. Build the project to find them.", null);
        IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
        if (prompter != null) {
            try {
                Object result = prompter.handleStatus((IStatus)status, null);
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
            }
            catch (CoreException e) {
                Q7LaunchingPlugin.log(e);
            }
        }
        return true;
    }

    public boolean cancelDebugExecution(AutLaunch aut, Object shell) throws DebugException {
        ArrayList<ExecutionSession> toDispose = new ArrayList<ExecutionSession>();
        for (ExecutionSession rSession : this.sessions) {
            if (!rSession.isDebugging(aut)) continue;
            toDispose.add(rSession);
        }
        if (toDispose.size() > 0 && !this.checkCancelDebugExecutionStatus(shell)) {
            return false;
        }
        this.sessions.removeAll(toDispose);
        for (ExecutionSession executionSession : toDispose) {
            executionSession.getLaunch().terminate();
            while (executionSession.isRunning()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Q7LaunchingPlugin.log(e);
                }
            }
        }
        return true;
    }

    private boolean checkCancelDebugExecutionStatus(Object shell) {
        Status status = new Status(1, "org.eclipse.rcptt.launching", 7707, "Debug session are active.", null);
        IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
        if (prompter != null) {
            try {
                Object result = prompter.handleStatus((IStatus)status, shell);
                if (result instanceof Boolean && !((Boolean)result).booleanValue()) {
                    return false;
                }
            }
            catch (CoreException e) {
                Q7LaunchingPlugin.log(e);
            }
        }
        return true;
    }

    public int getMaxHistoryEntries() {
        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.rcptt.launching");
        int count = node.getInt(PREFERENCE_HISTORY_MAX_EXECUTIONS_COUNT, 0);
        if (count == 0) {
            count = 30;
        }
        return count;
    }

    public void setMaxHistoryEntries(int maxEntries) {
        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.rcptt.launching");
        node.put(PREFERENCE_HISTORY_MAX_EXECUTIONS_COUNT, String.valueOf(maxEntries));
    }

    public IExecutionSession[] getExecutionSessions() {
        return this.sessions.toArray(new IExecutionSession[this.sessions.size()]);
    }

    public boolean removeExecutionSession(IExecutionSession session) {
        ExecutionSession es = (ExecutionSession)session;
        boolean result = this.sessions.remove(es);
        if (result) {
            es.dispose();
        }
        return result;
    }

    public void shutdown() {
        for (ExecutionSession session : this.sessions) {
            session.dispose();
        }
    }

    private synchronized void execute(ExecutionSession session, Q7Process process) {
        this.sessions.add(session);
        String launchId = process.getLaunch().getLaunchConfiguration().getName();
        ExecThread existing = this.threads.get(launchId);
        if (existing != null) {
            existing.stop();
        }
        SessionRunnable sessionRunnable = new SessionRunnable(launchId, session, process);
        ExecThread execThread = new ExecThread(session, sessionRunnable, launchId);
        this.threads.put(launchId, execThread);
        execThread.start();
    }

    public void execute(String launchId, ExecutionSession session, Runnable runnable) {
        this.sessions.add(session);
        ExecThread existing = this.threads.get(launchId);
        if (existing != null) {
            existing.stop();
        }
        ExecThread execThread = new ExecThread(session, runnable, launchId);
        this.threads.put(launchId, execThread);
        execThread.start();
    }

    public static boolean isTestSuiteLauch(ILaunch launch) {
        if (launch != null && launch.getLaunchConfiguration() != null) {
            try {
                return launch.getLaunchConfiguration().getType().getIdentifier().equals(Q7_TEST_SUITE_LAUNCH_ID);
            }
            catch (CoreException e) {
                Q7LaunchingPlugin.log(e);
            }
        }
        return false;
    }

    private void updateSessionCounters(ExecutionSession session, IExecutable executable, IStatus status) {
        if (!status.isOK()) {
            session.oneFailed();
        } else {
            session.oneFinished();
        }
    }

    public synchronized boolean isDebuggingActive() {
        return this.debuggingActive;
    }

    private void updateDebuggingActive(IExecutionSession exclude) {
        for (IExecutionSession iExecutionSession : this.sessions) {
            if (iExecutionSession.isTerminated() || iExecutionSession == exclude) continue;
            IExecutable[] iExecutableArray = iExecutionSession.getExecutables();
            int n = iExecutableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExecutable e = iExecutableArray[n2];
                if (e.isDebug()) {
                    this.debuggingActive = true;
                    return;
                }
                ++n2;
            }
        }
        this.debuggingActive = false;
    }

    public synchronized boolean isElementUnderDebugging(IQ7Element element) {
        for (ExecutionSession es : this.sessions) {
            if (es.isTerminated()) continue;
            Executable[] executableArray = es.getExecutables();
            int n = executableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Executable e = executableArray[n2];
                if (e.isDebug() && e.getActualElement().getResource().equals((Object)element.getResource())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private synchronized void fireStarted(IExecutionSession session) {
        this.updateDebuggingActive(null);
        for (ILaunchListener listener : this.listeners) {
            listener.started(session);
        }
    }

    private synchronized void fireLaunchStatusChanged(IExecutable ... executable) {
        for (ILaunchListener listener : this.listeners) {
            listener.launchStatusChanged(executable);
        }
    }

    private synchronized void fireFinished(IExecutionSession session) {
        this.updateDebuggingActive(session);
        for (ILaunchListener listener : this.listeners) {
            listener.finished();
        }
    }

    public synchronized boolean isDebuggingActive(AutLaunch aut) {
        for (ExecutionSession s : this.sessions) {
            if (!s.isDebugging(aut)) continue;
            return true;
        }
        return false;
    }

    private static class ExecThread {
        public final ExecutionSession session;
        public final Thread thread;
        public final Job job;
        private boolean complete = false;

        public ExecThread(ExecutionSession session, final Runnable runnable, String launchId) {
            this.session = session;
            this.thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            runnable.run();
                        }
                        catch (Exception e) {
                            Q7LaunchingPlugin.log(e);
                            ExecThread.this.complete = true;
                        }
                    }
                    finally {
                        ExecThread.this.complete = true;
                    }
                }
            }, "RCPTT Execution-" + launchId);
            this.job = new Job("Executing " + launchId){

                protected IStatus run(IProgressMonitor monitor) {
                    ExecThread.this.thread.start();
                    monitor.beginTask(this.getName(), -1);
                    try {
                        while (!ExecThread.this.complete) {
                            if (monitor.isCanceled()) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            try {
                                Thread.sleep(100L);
                                monitor.worked(-1);
                            }
                            catch (InterruptedException interruptedException) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                        }
                    }
                    finally {
                        ExecThread.this.stop();
                    }
                    return Status.OK_STATUS;
                }
            };
        }

        public void start() {
            this.job.schedule();
        }

        public void stop() {
            this.session.stop();
            this.job.cancel();
        }
    }

    public static class ExecutableFabric {
        private final AutLaunch launch;
        private final IWorkspaceFinder finder;
        private final TestCaseDebugger debugger;
        private final Set<ITestSuite> unresolvedItems = new HashSet<ITestSuite>();

        public ExecutableFabric(AutLaunch launch, IWorkspaceFinder finder, TestCaseDebugger debugger) {
            this.launch = launch;
            this.finder = finder;
            this.debugger = debugger;
        }

        private Executable makeContextExecutable(IContext context) throws ModelException {
            boolean debug;
            boolean bl = debug = this.debugger != null;
            if (context.getNamedElement() instanceof SuperContext) {
                return new EmptySuperContextExecutable(this.launch, context, debug);
            }
            if (context.getNamedElement() instanceof GroupContext) {
                ArrayList<Executable> children = new ArrayList<Executable>();
                for (String contextId : ((GroupContext)context.getNamedElement()).getContextReferences()) {
                    children.add(this.makeContextExecutable(RcpttCore.getInstance().findContext((IQ7NamedElement)context, false, contextId, this.finder)));
                }
                EclContextExecutable root = !debug ? new EclContextExecutable(this.launch, context, debug) : new EclDebugContextExecutable(this.launch, context, this.debugger);
                return new GroupExecutable(root, children);
            }
            if (context.getNamedElement() instanceof UnresolvedContext) {
                return new UnresolvedContextExecutable(this.launch, context, debug);
            }
            return !debug ? new EclContextExecutable(this.launch, context, debug) : new EclDebugContextExecutable(this.launch, context, this.debugger);
        }

        private Executable makeVerificationExecutable(IVerification verification, ExecutionPhase phase) throws ModelException {
            boolean debug;
            boolean bl = debug = this.debugger != null;
            if (verification.getNamedElement() instanceof UnresolvedVerification) {
                return new UnresolvedVerificationExecutable(this.launch, verification, debug, phase);
            }
            return !debug ? new EclVerificationExecutable(this.launch, verification, debug, phase) : new EclDebugVerificationExecutable(this.launch, verification, this.debugger, phase);
        }

        private Executable makeExecutionPlan(Executable parent, IContext[] contexts, IVerification[] verifications) {
            IVerification v;
            ArrayList<Executable> plan = new ArrayList<Executable>();
            Preconditions.checkNotNull((Object)parent);
            if (contexts == null) {
                contexts = new IContext[]{};
            }
            if (verifications == null) {
                verifications = new IVerification[]{};
            }
            IVerification[] iVerificationArray = verifications;
            int n = verifications.length;
            int n2 = 0;
            while (n2 < n) {
                v = iVerificationArray[n2];
                try {
                    if (v.getType().supportsPhase("start")) {
                        plan.add(this.makeVerificationExecutable(v, ExecutionPhase.START));
                    }
                }
                catch (ModelException e) {
                    Q7LaunchingPlugin.log("Failed to populate verifications for executable: " + parent.getName(), e);
                }
                ++n2;
            }
            iVerificationArray = contexts;
            n = contexts.length;
            n2 = 0;
            while (n2 < n) {
                IVerification c = iVerificationArray[n2];
                try {
                    plan.add(this.makeContextExecutable((IContext)c));
                }
                catch (ModelException e) {
                    Q7LaunchingPlugin.log("Failed to populate contexts for executable: " + parent.getName(), e);
                }
                ++n2;
            }
            iVerificationArray = verifications;
            n = verifications.length;
            n2 = 0;
            while (n2 < n) {
                v = iVerificationArray[n2];
                try {
                    if (v.getType().supportsPhase("run")) {
                        plan.add(this.makeVerificationExecutable(v, ExecutionPhase.RUN));
                    }
                }
                catch (ModelException e) {
                    Q7LaunchingPlugin.log("Failed to populate verifications for executable: " + parent.getName(), e);
                }
                ++n2;
            }
            plan.add(parent);
            iVerificationArray = verifications;
            n = verifications.length;
            n2 = 0;
            while (n2 < n) {
                v = iVerificationArray[n2];
                try {
                    if (v.getType().supportsPhase("finish")) {
                        plan.add(this.makeVerificationExecutable(v, ExecutionPhase.FINISH));
                    }
                }
                catch (ModelException e) {
                    Q7LaunchingPlugin.log("Failed to populate verifications for executable: " + parent.getName(), e);
                }
                ++n2;
            }
            return plan.size() > 1 ? new GroupExecutable(parent, plan) : parent;
        }

        public Executable[] map(IQ7NamedElement[] elements, Map<IQ7NamedElement, List<List<String>>> namedVariants) throws CoreException {
            ArrayList<Executable> executables = new ArrayList<Executable>();
            boolean debug = this.debugger != null;
            int i = 0;
            while (i < elements.length) {
                IQ7NamedElement element = elements[i];
                if (element instanceof ITestCase) {
                    ITestCase test = (ITestCase)element;
                    IContext[] contexts = RcpttCore.getInstance().getContexts(test, this.finder, false);
                    IVerification[] verifications = RcpttCore.getInstance().getVerifications(test, this.finder, false);
                    List superContexts = SuperContextSupport.findSuperContexts((IContext[])contexts);
                    if (superContexts.size() == 0) {
                        EclScenarioExecutable exec = this.debugger == null ? new EclScenarioExecutable(this.launch, test) : new EclDebugTestExecutable(this.launch, test, this.debugger);
                        executables.add(this.makeExecutionPlan(exec, contexts, verifications));
                    } else {
                        List variants = SuperContextSupport.findContextVariants((List)superContexts, (IContext[])contexts);
                        List<List<String>> supportedVariants = null;
                        if (namedVariants != null) {
                            supportedVariants = namedVariants.get(element);
                        }
                        for (SuperContextSupport.ContextConfiguration contextConfiguration : variants) {
                            if (supportedVariants != null && !supportedVariants.contains(contextConfiguration.getVariantName())) continue;
                            EclScenarioExecutable exec = this.debugger == null ? new EclScenarioExecutable(this.launch, test) : new EclDebugTestExecutable(this.launch, test, this.debugger);
                            exec.setVariantName(contextConfiguration.getVariantName());
                            executables.add(this.makeExecutionPlan(exec, contextConfiguration.getContexts(), verifications));
                        }
                    }
                } else if (element instanceof ITestSuite) {
                    ITestSuite suite = (ITestSuite)element;
                    ISearchScope scope = Q7SearchCore.getSearchScope((ITestSuite)suite);
                    ArrayList<IQ7NamedElement> testSuiteItems = new ArrayList<IQ7NamedElement>();
                    TestSuiteItem[] testSuiteItemArray = suite.getItems();
                    int n = testSuiteItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TestSuiteItem item = testSuiteItemArray[n2];
                        IQ7NamedElement q7Element = Q7SearchCore.getTestSuiteItemElement((TestSuiteItem)item, (ISearchScope)scope);
                        if (q7Element == null) {
                            this.unresolvedItems.add(suite);
                        } else {
                            testSuiteItems.add(q7Element);
                        }
                        ++n2;
                    }
                    if (!suite.getTestSuite().isManuallyOrdered()) {
                        SortingUtils.sortNamedElements(testSuiteItems);
                    }
                    Executable[] children = this.map(testSuiteItems.toArray(new IQ7NamedElement[testSuiteItems.size()]), namedVariants);
                    executables.add(new TestSuiteExecutable(this.launch, (ITestSuite)element, children, debug));
                } else if (element instanceof IContext) {
                    IContext context = (IContext)element;
                    executables.add(this.makeContextExecutable(context));
                } else {
                    IVerification verification = (IVerification)element;
                    executables.add(this.debugger == null ? new EclVerificationExecutable(this.launch, verification, debug, ExecutionPhase.AUTO) : new EclDebugVerificationExecutable(this.launch, verification, this.debugger, ExecutionPhase.AUTO));
                }
                ++i;
            }
            i = 0;
            while (i < executables.size()) {
                if (!(executables.get(i) instanceof TestSuiteExecutable)) {
                    executables.set(i, new PrepareExecutionWrapper(this.launch, (Executable)executables.get(i)));
                }
                ++i;
            }
            return executables.toArray(new Executable[executables.size()]);
        }
    }

    public static class SessionRunnable
    implements Runnable,
    IDebugEventSetListener {
        private final String launchId;
        private final ExecutionSession session;
        private final Q7Process q7Process;

        public SessionRunnable(String launchId, ExecutionSession session, Q7Process q7Process) {
            this.launchId = launchId;
            this.session = session;
            this.q7Process = q7Process;
        }

        public void handleDebugEvents(DebugEvent[] events) {
            DebugEvent[] debugEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                DebugEvent event = debugEventArray[n2];
                Object source = event.getSource();
                if (this.q7Process == source && event.getKind() == 8) {
                    Q7LaunchManager.getInstance().stop();
                }
                ++n2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block32: {
                this.session.resetCounters();
                this.session.setStartTime(new Date());
                this.session.start();
                DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
                Executable[] executables = this.session.getExecutables();
                Q7LaunchManager.getInstance().fireStarted(this.session);
                try {
                    ArrayList<Executable> massUpdateOnTerminate = new ArrayList<Executable>();
                    Executable.Listener listener = new Executable.Listener(){

                        @Override
                        public void onStatusChange(Executable executable) {
                            Q7LaunchManager.getInstance().fireLaunchStatusChanged(new IExecutable[]{executable});
                            SessionRunnable.this.session.setActive(executable);
                        }

                        @Override
                        public void updateSessionCounters(Executable executable, IStatus status) {
                            Q7LaunchManager.getInstance().updateSessionCounters(SessionRunnable.this.session, executable, status);
                        }
                    };
                    Executable[] executableArray = executables;
                    int n = executables.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Executable executable = executableArray[n2];
                        if (!this.session.isRunning()) {
                            massUpdateOnTerminate.add(executable);
                            executable.cancel(listener, (IStatus)new Status(8, "org.eclipse.rcptt.launching", "Execution is stopped"));
                        } else {
                            try {
                                executable.executeAndRememberResult(listener);
                            }
                            catch (Throwable throwable) {
                                this.session.setActive(null);
                                Q7LaunchManager.getInstance().fireLaunchStatusChanged(new IExecutable[]{executable});
                                throw throwable;
                            }
                            this.session.setActive(null);
                            Q7LaunchManager.getInstance().fireLaunchStatusChanged(new IExecutable[]{executable});
                            Q7LaunchManager.getInstance().fireLaunchStatusChanged(new IExecutable[]{executable});
                        }
                        ++n2;
                    }
                    if (massUpdateOnTerminate.size() > 0) {
                        Q7LaunchManager.getInstance().fireLaunchStatusChanged(massUpdateOnTerminate.toArray(new Executable[massUpdateOnTerminate.size()]));
                    }
                }
                catch (InterruptedException interruptedException) {
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    Q7LaunchManager q7LaunchManager = Q7LaunchManager.getInstance();
                    synchronized (q7LaunchManager) {
                        Q7LaunchManager.getInstance().threads.remove(this.launchId);
                    }
                    this.session.stop();
                    this.session.setEndTime(new Date());
                    Q7LaunchManager.getInstance().fireFinished(this.session);
                    try {
                        this.session.getLaunch().terminate();
                    }
                    catch (DebugException e) {
                        Q7LaunchingPlugin.log(e);
                    }
                    break block32;
                }
                catch (Exception e) {
                    try {
                        Q7LaunchingPlugin.log(e);
                    }
                    catch (Throwable throwable) {
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        Q7LaunchManager e2 = Q7LaunchManager.getInstance();
                        synchronized (e2) {
                            Q7LaunchManager.getInstance().threads.remove(this.launchId);
                        }
                        this.session.stop();
                        this.session.setEndTime(new Date());
                        Q7LaunchManager.getInstance().fireFinished(this.session);
                        try {
                            this.session.getLaunch().terminate();
                        }
                        catch (DebugException e22) {
                            Q7LaunchingPlugin.log(e22);
                        }
                        throw throwable;
                    }
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    e = Q7LaunchManager.getInstance();
                    synchronized (e) {
                        Q7LaunchManager.getInstance().threads.remove(this.launchId);
                    }
                    this.session.stop();
                    this.session.setEndTime(new Date());
                    Q7LaunchManager.getInstance().fireFinished(this.session);
                    try {
                        this.session.getLaunch().terminate();
                    }
                    catch (DebugException e2) {
                        Q7LaunchingPlugin.log(e2);
                    }
                    break block32;
                }
                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                Q7LaunchManager e22 = Q7LaunchManager.getInstance();
                synchronized (e22) {
                    Q7LaunchManager.getInstance().threads.remove(this.launchId);
                }
                this.session.stop();
                this.session.setEndTime(new Date());
                Q7LaunchManager.getInstance().fireFinished(this.session);
                try {
                    this.session.getLaunch().terminate();
                }
                catch (DebugException e) {
                    Q7LaunchingPlugin.log(e);
                }
            }
        }
    }

    private static class SingletonHolder {
        private static Q7LaunchManager INSTANCE = null;

        private SingletonHolder() {
        }
    }
}

