/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ecl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.internal.launching.ContextExecutable;
import org.eclipse.rcptt.internal.launching.Executable;
import org.eclipse.rcptt.internal.launching.ecl.ExecAdvancedInfoUtil;
import org.eclipse.rcptt.internal.launching.reporting.ReportMaker;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.reporting.ItemKind;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.ResultStatus;
import org.eclipse.rcptt.reporting.core.ReportHelper;
import org.eclipse.rcptt.tesla.core.TeslaLimits;

public class EclContextExecutable
extends ContextExecutable {
    private Map<String, EObject> props;
    private boolean isEcl;
    private static final String ECL_SCRIPT_TYPE_ID = "org.eclipse.rcptt.ctx.ecl";

    public EclContextExecutable(AutLaunch launch, IContext context, boolean debug) {
        super(launch, context, debug);
        this.isEcl = EclContextExecutable.isEclScriptContext((IQ7NamedElement)context);
    }

    protected void doExecuteContext(IProgressMonitor monitor) throws CoreException {
        this.launch.run((IQ7NamedElement)this.getActualElement(), TeslaLimits.getContextRunnableTimeout(), monitor, this.getPhase());
    }

    public static boolean isEclScriptContext(IQ7NamedElement context) {
        try {
            return context instanceof IContext && ECL_SCRIPT_TYPE_ID.equals(((IContext)context).getType().getId());
        }
        catch (ModelException modelException) {
            return false;
        }
    }

    @Override
    protected IStatus doExecute() throws CoreException, InterruptedException {
        IStatus resultStatus;
        String description = "";
        if (this.isEcl) {
            Q7Info info = ReportHelper.createInfo();
            Context context = (Context)this.getActualElement().getModifiedNamedElement();
            description = context.getDescription();
            this.props = new HashMap<String, EObject>();
            info.setType(ItemKind.CONTEXT);
            info.setResult(ResultStatus.PASS);
            info.setTags(context.getTags());
            info.setId(context.getId());
            info.setDescription(description);
            this.props.put("q7", (EObject)info);
            ReportMaker.beginReportNode(this.getName(), this.props, this.launch);
        }
        try {
            this.doExecuteContext((IProgressMonitor)this.executionMonitor);
            resultStatus = Status.OK_STATUS;
        }
        catch (CoreException e) {
            resultStatus = e.getStatus();
        }
        if (resultStatus.getSeverity() == 8) {
            String message = "Context execution is terminated";
            if (this.getResultStatus().matches(8)) {
                message = "Context is terminated by user request";
            } else if (!this.getResultStatus().isOK()) {
                message = "Timeout during context execution";
            }
            resultStatus = ExecAdvancedInfoUtil.askForAdvancedInfo(this.launch, message);
        }
        return resultStatus;
    }

    @Override
    public IStatus postExecute(Executable.Listener listener, IStatus status) {
        try {
            if (this.isEcl) {
                ReportMaker.endReportNode(true, null, this.launch);
            }
            return super.postExecute(listener, status);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }
}

