/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ecl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.internal.launching.Executable;
import org.eclipse.rcptt.internal.launching.ScenarioExecutable;
import org.eclipse.rcptt.internal.launching.reporting.ReportMaker;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.Q7Launcher;
import org.eclipse.rcptt.reporting.ItemKind;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.ResultStatus;
import org.eclipse.rcptt.reporting.core.ReportHelper;

public class EclScenarioExecutable
extends ScenarioExecutable {
    private Map<String, EObject> props;
    private List<String> variantName = new ArrayList<String>();

    public EclScenarioExecutable(AutLaunch launch, ITestCase scenario) {
        this(launch, scenario, false);
    }

    protected EclScenarioExecutable(AutLaunch launch, ITestCase scenario, boolean debug) {
        super(launch, scenario, debug);
    }

    @Override
    public IStatus doExecute() throws CoreException {
        IStatus resultStatus;
        Scenario scenario = (Scenario)this.getActualElement().getModifiedNamedElement();
        this.props = new HashMap<String, EObject>();
        Q7Info info = ReportHelper.createInfo();
        info.setType(ItemKind.SCRIPT);
        info.setResult(ResultStatus.PASS);
        info.setTags(scenario.getTags());
        info.setId(scenario.getId());
        if (this.getVariantName() != null) {
            info.getVariant().clear();
            info.getVariant().addAll(this.getVariantName());
        }
        info.setDescription(scenario.getDescription());
        this.props.put("q7", (EObject)info);
        ReportMaker.beginReportNode(this.getName(), this.props, this.launch);
        try {
            this.doExecuteTest((IProgressMonitor)this.executionMonitor);
            resultStatus = Status.OK_STATUS;
        }
        catch (CoreException e) {
            resultStatus = e.getStatus();
        }
        return resultStatus;
    }

    @Override
    public IStatus postExecute(Executable.Listener listener, IStatus status) {
        try {
            ReportMaker.endReportNode(true, null, this.launch);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return super.postExecute(listener, status);
    }

    protected void doExecuteTest(IProgressMonitor monitor) throws CoreException {
        this.launch.run((IQ7NamedElement)this.getActualElement(), Q7Launcher.getLaunchTimeout() * 1000, monitor, this.getPhase());
    }

    public void setVariantName(List<String> variantName) {
        this.variantName = variantName == null ? new ArrayList<String>() : new ArrayList<String>(variantName);
    }

    public List<String> getVariantName() {
        return this.variantName;
    }

    public String toString() {
        return "ECL: " + this.getActualElement().getName();
    }
}

