/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.reporting;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.core.ecl.core.model.BeginReportNode;
import org.eclipse.rcptt.core.ecl.core.model.EndReportNode;
import org.eclipse.rcptt.core.ecl.core.model.Q7CoreFactory;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.IExecutable;
import org.eclipse.rcptt.launching.IExecutionSession;
import org.eclipse.rcptt.reporting.ItemKind;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.ResultStatus;
import org.eclipse.rcptt.reporting.core.IQ7ReportConstants;
import org.eclipse.rcptt.reporting.core.ReportHelper;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.ReportFactory;
import org.eclipse.rcptt.sherlock.core.streams.SherlockReportOutputStream;

public class ReportMaker
implements IQ7ReportConstants {
    private final SherlockReportOutputStream stream;

    public static void beginReportNode(String node, Map<String, EObject> properties, AutLaunch launch) throws CoreException {
        BeginReportNode reportNode = Q7CoreFactory.eINSTANCE.createBeginReportNode();
        reportNode.setName(node);
        if (properties != null) {
            reportNode.getProperties().putAll(properties);
        }
        try {
            launch.execute((Command)reportNode);
        }
        catch (InterruptedException e) {
            RcpttPlugin.log((Throwable)e);
        }
    }

    public static void endReportNode(boolean takeSnaphots, List<String> snaphosts, AutLaunch launch) throws CoreException {
        EndReportNode reportNode = Q7CoreFactory.eINSTANCE.createEndReportNode();
        reportNode.setTakeSnaphots(takeSnaphots);
        if (takeSnaphots && snaphosts != null) {
            reportNode.getSnaphots().addAll(snaphosts);
        }
        try {
            launch.execute((Command)reportNode);
        }
        catch (InterruptedException e) {
            RcpttPlugin.log((Throwable)e);
        }
    }

    public ReportMaker(SherlockReportOutputStream out) {
        this.stream = out;
    }

    public void make(IExecutionSession session, IProgressMonitor monitor) {
        IExecutable[] executables = session.getTestCases();
        monitor.beginTask("Prepare RCPTT report", executables.length + 50);
        IExecutable[] iExecutableArray = executables;
        int n = executables.length;
        int n2 = 0;
        while (n2 < n) {
            IExecutable iExecutable = iExecutableArray[n2];
            Report report = iExecutable.getResultReport();
            if (report == null) {
                report = ReportFactory.eINSTANCE.createReport();
                Node nde = ReportFactory.eINSTANCE.createNode();
                report.setRoot(nde);
                nde.setName(iExecutable.getName());
                nde.setStartTime(0L);
                nde.setEndTime(iExecutable.getTime());
                Q7Info info = ReportHelper.getInfo((Node)nde);
                this.setProperties(iExecutable, nde);
                info.setMessage("Skipped or not started");
                info.setResult(ResultStatus.SKIPPED);
                info.setType(ItemKind.TESTCASE);
                this.processChildren(report, nde, iExecutable);
                this.stream.write(report);
            } else {
                this.stream.write((Report)EcoreUtil.copy((EObject)report));
            }
            monitor.worked(1);
            ++n2;
        }
        monitor.done();
    }

    private void setProperties(IExecutable iExecutable, Node nde) {
        Q7Info info = ReportHelper.getInfo((Node)nde);
        switch (iExecutable.getType()) {
            case 1: {
                info.setType(ItemKind.CONTEXT);
                break;
            }
            case 3: {
                info.setType(ItemKind.VERIFICATION);
                break;
            }
            case 0: {
                info.setType(ItemKind.SCRIPT);
            }
        }
        switch (iExecutable.getStatus()) {
            case WAITING: 
            case LAUNCHING: {
                info.setResult(ResultStatus.SKIPPED);
                break;
            }
            case FAILED: {
                info.setResult(ResultStatus.FAIL);
                break;
            }
            case PASSED: {
                info.setResult(ResultStatus.PASS);
            }
        }
    }

    private void processChildren(Report report, Node rnde, IExecutable iExecutable) {
        IExecutable[] children;
        IExecutable[] iExecutableArray = children = iExecutable.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IExecutable iExecutable2 = iExecutableArray[n2];
            Node nde = ReportFactory.eINSTANCE.createNode();
            rnde.getChildren().add((Object)nde);
            nde.setName(iExecutable2.getName());
            Q7Info info = ReportHelper.getInfo((Node)nde);
            info.setResult(ResultStatus.FAIL);
            nde.setStartTime(0L);
            nde.setEndTime(iExecutable2.getTime());
            this.setProperties(iExecutable2, nde);
            this.processChildren(report, nde, iExecutable2);
            ++n2;
        }
    }
}

