/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.launching;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.rcptt.core.ecl.core.model.ExecutionPhase;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.PrepareExecutionWrapper;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.launching.IExecutable;
import org.eclipse.rcptt.ui.launching.TimeFormatHelper;
import org.eclipse.swt.graphics.Image;

public class ExecutionLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    public Image getImage(Object element) {
        IExecutable executable = this.cast(element);
        if (executable.getType() == 0) {
            if (executable.getResultStatus().matches(8)) {
                return Images.getImage("icons/launching/teststop.gif");
            }
            switch (executable.getStatus()) {
                case WAITING: {
                    return Images.getImage("icons/launching/test.gif");
                }
                case LAUNCHING: {
                    return Images.getImage("icons/launching/testrun.gif");
                }
                case PASSED: {
                    return Images.getImage("icons/launching/testok.gif");
                }
                case FAILED: {
                    return Images.getImage("icons/launching/testerr.gif");
                }
            }
        } else if (executable.getType() == 1) {
            if (executable.getResultStatus().matches(8)) {
                return Images.getImage("icons/launching/contextstop.gif");
            }
            switch (executable.getStatus()) {
                case WAITING: {
                    return Images.getImage("icons/launching/context.gif");
                }
                case LAUNCHING: {
                    return Images.getImage("icons/launching/contextrun.gif");
                }
                case PASSED: {
                    return Images.getImage("icons/launching/contextok.gif");
                }
                case FAILED: {
                    return Images.getImage("icons/launching/contexterr.gif");
                }
            }
        } else if (executable.getType() == 3) {
            if (executable.getResultStatus().matches(8)) {
                return Images.getImage("icons/launching/verification-stop.png");
            }
            switch (executable.getStatus()) {
                case WAITING: {
                    return Images.getImage("icons/launching/verification.gif");
                }
                case LAUNCHING: {
                    return Images.getImage("icons/launching/verification-run.png");
                }
                case PASSED: {
                    return Images.getImage("icons/launching/verification-pass.png");
                }
                case FAILED: {
                    return Images.getImage("icons/launching/verification-fail.png");
                }
            }
        } else if (executable.getType() == 2) {
            if (executable.getResultStatus().matches(8)) {
                return Images.getImage("icons/launching/tsuitestop.gif");
            }
            switch (executable.getStatus()) {
                case WAITING: {
                    return Images.getImage("icons/launching/tsuite.gif");
                }
                case LAUNCHING: {
                    return Images.getImage("icons/launching/tsuiterun.gif");
                }
                case PASSED: {
                    return Images.getImage("icons/launching/tsuiteok.gif");
                }
                case FAILED: {
                    return Images.getImage("icons/launching/tsuiteerror.gif");
                }
            }
        }
        return null;
    }

    public StyledString getStyledText(Object element) {
        List variantName;
        IExecutable executable = this.cast(element);
        StyledString styledString = new StyledString(executable.getName());
        if (executable instanceof PrepareExecutionWrapper && (variantName = ((PrepareExecutionWrapper)executable).getVariantName()) != null && !variantName.isEmpty()) {
            styledString.append(" (" + Joiner.on((char)',').join((Iterable)variantName) + ")", StyledString.DECORATIONS_STYLER);
        }
        if (executable.getPhase() != ExecutionPhase.AUTO) {
            styledString.append(" ", StyledString.DECORATIONS_STYLER).append(executable.getPhase().toString(), StyledString.DECORATIONS_STYLER);
        }
        if (executable.getStatus() == IExecutable.State.PASSED || executable.getStatus() == IExecutable.State.FAILED) {
            styledString.append(" (", StyledString.COUNTER_STYLER);
            long time = executable.getTime();
            styledString.append(TimeFormatHelper.format(time), StyledString.COUNTER_STYLER);
            styledString.append(")", StyledString.COUNTER_STYLER);
        }
        try {
            String[] contexts;
            IQ7Project project;
            IQ7ProjectMetadata metadata;
            String id;
            IQ7NamedElement actualElement = executable.getActualElement();
            if (!actualElement.getResource().getProject().isOpen()) {
                return styledString;
            }
            if (actualElement != null && actualElement.exists() && (id = executable.getActualElement().getID()) != null && (metadata = (project = executable.getActualElement().getQ7Project()).getMetadata()) != null && metadata.exists() && (contexts = metadata.getContexts()) != null && Arrays.asList(contexts).contains(id)) {
                styledString.append(" (default context)", StyledString.DECORATIONS_STYLER);
            }
        }
        catch (ModelException e) {
            RcpttPlugin.log((Throwable)e);
        }
        return styledString;
    }

    public String getText(Object element) {
        return this.getStyledText(element).toString();
    }

    private IExecutable cast(Object element) {
        return (IExecutable)element;
    }
}

