/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.tags;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EObjectObservableList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.search.tags.TagsSearch;
import org.eclipse.rcptt.core.tags.Tag;
import org.eclipse.rcptt.core.tags.TagsPackage;
import org.eclipse.rcptt.core.utils.TagsUtil;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.commons.SearchControl;
import org.eclipse.rcptt.ui.utils.ModelUtils;
import org.eclipse.rcptt.util.StringUtils;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;

public class TagsFilterComposite {
    private static final String OPERATOR_OR = "OR";
    private static final String OPERATOR_AND = "AND";
    private static final String REGEX_LAST_SEGMENT = "^.*(\\(| or | OR | \\| | and | AND | & | not | NOT |!)(.*)$";
    private static final String REGEX_SPEC_CHARS = ".*[ ()!].*";
    private static final String TOOLTIP_FILTER = "Feel free to use AND, OR and parentheses";
    public IObservableList tags;
    private SearchControl searchControl;
    private TreeViewer tagsViewer;
    private TableViewer listViewer;
    private Shell popupShell;
    private Table popupTable;
    private boolean autocompleteOff = false;
    private boolean isHorizontal;

    public TagsFilterComposite(Composite parent, boolean isHorizontal) {
        Composite panel;
        this.isHorizontal = isHorizontal;
        if (isHorizontal) {
            panel = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(true).margins(0, 0).applyTo(panel);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)panel);
        } else {
            panel = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(panel);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)panel);
        }
        this.createFilterControl(panel);
        this.createTreeControl(panel);
        this.createListControl(panel);
    }

    public TreeViewer getTagsViewer() {
        return this.tagsViewer;
    }

    public TableViewer getListViewer() {
        return this.listViewer;
    }

    public void updateList() {
        String string = this.searchControl.getFilterString();
        if (string == null) {
            string = "";
        }
        if ((string = string.trim()).isEmpty()) {
            this.listViewer.setInput(null);
        } else {
            this.listViewer.setInput((Object)TagsSearch.findAllByExpression((String)string));
        }
    }

    public void hidePopup() {
        if (!this.popupShell.isDisposed()) {
            this.popupShell.setVisible(false);
        }
    }

    private void createFilterControl(Composite panel) {
        final Display display = panel.getDisplay();
        Shell shell = panel.getShell();
        this.popupShell = new Shell(shell, 16384);
        this.popupShell.setLayout((Layout)new FillLayout());
        this.popupTable = new Table((Composite)this.popupShell, 4);
        this.popupTable.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                switch (event.keyCode) {
                    case 27: {
                        TagsFilterComposite.this.popupShell.setVisible(false);
                        break;
                    }
                    case 13: {
                        TagsFilterComposite.this.selectAutocompleteOffer();
                    }
                }
            }
        });
        this.popupTable.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                TagsFilterComposite.this.selectAutocompleteOffer();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.searchControl = new SearchControl(panel);
        if (this.isHorizontal) {
            GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.searchControl);
        } else {
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.searchControl);
        }
        this.searchControl.setInitialText("Tag name");
        this.searchControl.getFilterControl().setToolTipText(TOOLTIP_FILTER);
        this.searchControl.getFilterControl().addListener(1, new Listener(){

            public void handleEvent(Event event) {
                switch (event.keyCode) {
                    case 0x1000002: {
                        int index = (TagsFilterComposite.this.popupTable.getSelectionIndex() + 1) % TagsFilterComposite.this.popupTable.getItemCount();
                        TagsFilterComposite.this.popupTable.setSelection(index);
                        event.doit = false;
                        break;
                    }
                    case 0x1000001: {
                        int index = TagsFilterComposite.this.popupTable.getSelectionIndex() - 1;
                        if (index < 0) {
                            index = TagsFilterComposite.this.popupTable.getItemCount() - 1;
                        }
                        TagsFilterComposite.this.popupTable.setSelection(index);
                        event.doit = false;
                        break;
                    }
                    case 27: {
                        TagsFilterComposite.this.popupShell.setVisible(false);
                        break;
                    }
                    case 32: {
                        if ((event.stateMask & 0x40000) != 262144) break;
                        TagsFilterComposite.this.showAutocomplete();
                        event.doit = false;
                        break;
                    }
                    case 13: {
                        TagsFilterComposite.this.selectAutocompleteOffer();
                    }
                }
            }
        });
        this.searchControl.getFilterControl().addListener(24, new Listener(){

            public void handleEvent(Event event) {
                TagsFilterComposite.this.showAutocomplete();
            }
        });
        Listener focusOutListener = new Listener(){

            public void handleEvent(Event event) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (display.isDisposed()) {
                            return;
                        }
                        Control control = display.getFocusControl();
                        if (control == null || control != TagsFilterComposite.this.searchControl.getFilterControl() && control != TagsFilterComposite.this.popupTable) {
                            TagsFilterComposite.this.popupShell.setVisible(false);
                        }
                    }
                });
            }
        };
        this.popupTable.addListener(16, focusOutListener);
        this.searchControl.getFilterControl().addListener(16, focusOutListener);
        shell.addListener(10, new Listener(){

            public void handleEvent(Event event) {
                TagsFilterComposite.this.popupShell.setVisible(false);
            }
        });
        shell.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                TagsFilterComposite.this.popupShell.setVisible(false);
            }
        });
    }

    private void showAutocomplete() {
        if (this.autocompleteOff) {
            return;
        }
        String search = this.searchControl.getFilterString();
        if (search.trim().length() == 0) {
            this.popupShell.setVisible(false);
        } else {
            ArrayList<String> results = this.getAutocompleteOffers(search);
            if (results.size() > 0) {
                int i;
                TableItem[] items = this.popupTable.getItems();
                if (results.size() > items.length) {
                    i = items.length;
                    while (i < results.size()) {
                        new TableItem(this.popupTable, 0);
                        ++i;
                    }
                } else if (results.size() < items.length) {
                    i = items.length - 1;
                    while (i >= results.size()) {
                        items[i].dispose();
                        --i;
                    }
                }
                i = 0;
                while (i < results.size()) {
                    this.popupTable.getItem(i).setText(results.get(i));
                    ++i;
                }
                this.popupTable.deselectAll();
                Rectangle bounds = this.searchControl.getBounds();
                Point p = this.searchControl.toDisplay(0, bounds.height);
                this.popupShell.setBounds(p.x, p.y, bounds.width - 50, 100);
                this.popupShell.setVisible(true);
            } else {
                this.popupShell.setVisible(false);
            }
        }
    }

    private void selectAutocompleteOffer() {
        if (this.popupShell.isVisible() && this.popupTable.getSelectionIndex() != -1) {
            String selected = this.popupTable.getSelection()[0].getText();
            this.searchControl.getFilterControl().setText(selected);
            this.searchControl.getFilterControl().setSelection(selected.length(), selected.length());
        }
        this.popupShell.setVisible(false);
        this.updateList();
        this.tagsViewer.setSelection(null);
        int index = this.listViewer.getTable().getItemCount();
        ArrayList<Object> toSelect = new ArrayList<Object>();
        while (--index >= 0) {
            toSelect.add(this.listViewer.getElementAt(index));
        }
        this.listViewer.setSelection((ISelection)new StructuredSelection(toSelect), true);
    }

    private ArrayList<String> getAutocompleteOffers(String search) {
        ArrayList<String> results = new ArrayList<String>(0);
        Map<String, String> last = TagsFilterComposite.getLastSegment(search);
        if (search.endsWith(" ")) {
            if (last.get("operator") == null) {
                this.findAllTags(search, "", results, (List<Tag>)this.tags);
                results.add(String.valueOf(search) + OPERATOR_OR);
                results.add(String.valueOf(search) + OPERATOR_AND);
            } else if (!last.get("segment").trim().isEmpty()) {
                String prefix = search.substring(0, search.length() - last.get("segment").length());
                this.findAllTags(last.get("segment"), prefix, results, (List<Tag>)this.tags);
                results.add(String.valueOf(search) + OPERATOR_OR);
                results.add(String.valueOf(search) + OPERATOR_AND);
            } else {
                this.getAllRootTags(search, results, (List<Tag>)this.tags);
            }
        } else if (search.endsWith("(") || search.endsWith("!")) {
            this.getAllRootTags(search, results, (List<Tag>)this.tags);
        } else if (last.get("operator") == null) {
            this.findAllTags(search.replaceAll("^\\s+", ""), "", results, (List<Tag>)this.tags);
        } else if (!last.get("segment").trim().isEmpty()) {
            String prefix = search.substring(0, search.length() - last.get("segment").length());
            this.findAllTags(last.get("segment").replaceAll("^\\s+", ""), prefix, results, (List<Tag>)this.tags);
        }
        return results;
    }

    private static Map<String, String> getLastSegment(String text) {
        Pattern pattern = Pattern.compile(REGEX_LAST_SEGMENT);
        Matcher matcher = pattern.matcher(text);
        HashMap<String, String> result = new HashMap<String, String>();
        if (matcher.find()) {
            result.put("operator", matcher.group(1));
            result.put("segment", matcher.group(2) == null ? "" : matcher.group(2));
        } else {
            result.put("operator", null);
            result.put("segment", null);
        }
        return result;
    }

    private void getAllRootTags(String prefix, ArrayList<String> results, List<Tag> tags) {
        if (tags != null) {
            for (Tag tag : tags) {
                if (tag.getPath().matches(REGEX_SPEC_CHARS)) {
                    results.add(String.valueOf(prefix) + "\"" + tag.getPath() + "\"");
                    continue;
                }
                results.add(String.valueOf(prefix) + tag.getPath());
            }
        }
    }

    private void findAllTags(String search, String prefix, ArrayList<String> results, List<Tag> tags) {
        if (tags != null) {
            for (Tag tag : tags) {
                if (tag.getPath().toLowerCase().startsWith(search.toLowerCase())) {
                    if (tag.getPath().matches(REGEX_SPEC_CHARS)) {
                        results.add(String.valueOf(prefix) + "\"" + tag.getPath() + "\"");
                    } else {
                        results.add(String.valueOf(prefix) + tag.getPath());
                    }
                }
                this.findAllTags(search, prefix, results, (List<Tag>)tag.getTags());
            }
        }
    }

    private void createTreeControl(Composite panel) {
        Tree tree = new Tree(panel, 2050);
        if (this.isHorizontal) {
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)tree);
        } else {
            GridDataFactory.fillDefaults().align(4, 4).grab(true, false).hint(-1, 220).applyTo((Control)tree);
        }
        ObservableListTreeContentProvider treeContentProvider = new ObservableListTreeContentProvider(new IObservableFactory(){

            public IObservable createObservable(Object target) {
                if (target instanceof IObservable) {
                    return (IObservable)target;
                }
                if (target instanceof Tag) {
                    Tag tag = (Tag)target;
                    return new EObjectObservableList((EObject)tag, (EStructuralFeature)TagsPackage.Literals.TAG__TAGS);
                }
                return null;
            }
        }, null);
        LabelProvider treeLabelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                return Images.getImage("icons/tag.gif");
            }

            public String getText(Object element) {
                Tag tag = (Tag)element;
                String value = tag.getValue().trim();
                if (value.length() == 0) {
                    return Messages.bind((String)Messages.TagsView_UntaggedLabelFormat, (Object)TagsUtil.getDistinctTagRefsCount((Tag)tag));
                }
                return Messages.bind((String)Messages.TagsView_TagLabelFormat, (Object)value, (Object)TagsUtil.getDistinctTagRefsCount((Tag)tag));
            }
        };
        this.tagsViewer = new TreeViewer(tree);
        this.tagsViewer.setContentProvider((IContentProvider)treeContentProvider);
        this.tagsViewer.setLabelProvider((IBaseLabelProvider)treeLabelProvider);
        this.tagsViewer.setSorter(new ViewerSorter());
        this.tagsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TagsFilterComposite.this.updateFilterControl((IStructuredSelection)event.getSelection());
            }
        });
    }

    private void createListControl(Composite panel) {
        this.listViewer = new TableViewer(panel, 2050);
        if (this.isHorizontal) {
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo((Control)this.listViewer.getTable());
        } else {
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.listViewer.getTable());
        }
        IStructuredContentProvider listContentProvider = new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Tag) {
                    EList refs = ((Tag)inputElement).getRefs();
                    return refs.toArray(new Object[refs.size()]);
                }
                if (inputElement instanceof IQ7NamedElement[]) {
                    Object[] list = (IQ7NamedElement[])inputElement;
                    return list;
                }
                return new Object[0];
            }
        };
        LabelProvider listLabelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof IQ7NamedElement) {
                    return ModelUtils.getImage((IQ7Element)((IQ7NamedElement)element));
                }
                return Images.getImage("icons/unknown.gif");
            }

            public String getText(Object element) {
                if (element instanceof IQ7NamedElement) {
                    return ModelUtils.getText((IQ7Element)((IQ7NamedElement)element));
                }
                return element != null ? element.toString() : "null";
            }
        };
        this.listViewer.setContentProvider((IContentProvider)listContentProvider);
        this.listViewer.setLabelProvider((IBaseLabelProvider)listLabelProvider);
        this.listViewer.setSorter(new ViewerSorter());
    }

    private void updateFilterControl(IStructuredSelection selection) {
        if (selection.size() >= 1) {
            ArrayList<String> tags = new ArrayList<String>();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof Tag) {
                    String tagName = ((Tag)o).getPath();
                    if (tagName.matches(REGEX_SPEC_CHARS)) {
                        tags.add("\"" + tagName + "\"");
                    } else {
                        tags.add(tagName);
                    }
                }
                ++n2;
            }
            this.autocompleteOff = true;
            this.searchControl.getFilterControl().setText(StringUtils.join((String)" OR ", tags));
            this.autocompleteOff = false;
            if (selection.size() == 1) {
                this.listViewer.setInput(selection.getFirstElement());
            } else {
                this.updateList();
            }
        }
    }
}

