/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.wizards.WizardScenarioPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;

public class NewScenarioWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private WizardScenarioPage scenarioPage;
    private boolean openEditor = true;
    private ITestCase testCase;

    public NewScenarioWizard() {
        this.setWindowTitle(Messages.NewScenarioWizard_WindowTitle);
    }

    public ITestCase getScenario() {
        return this.testCase;
    }

    public boolean openEditor() {
        return this.openEditor;
    }

    public void setOpenEditor(boolean openEditor) {
        this.openEditor = openEditor;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public void addPages() {
        this.scenarioPage = new WizardScenarioPage(this.selection);
        this.addPage((IWizardPage)this.scenarioPage);
    }

    public boolean performFinish() {
        final boolean[] result = new boolean[1];
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IProject project = NewScenarioWizard.this.scenarioPage.getProject();
                        String name = NewScenarioWizard.this.scenarioPage.getScenarioName();
                        IPath containerPath = NewScenarioWizard.this.scenarioPage.getPathInProject();
                        NewScenarioWizard.this.testCase = RcpttCore.create((IProject)project).getFolder(containerPath).createTestCase(name, true, (IProgressMonitor)new NullProgressMonitor());
                        ITestCase workingCopy = (ITestCase)NewScenarioWizard.this.testCase.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                        try {
                            workingCopy.setType(NewScenarioWizard.this.getType());
                            workingCopy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                        finally {
                            workingCopy.discardWorkingCopy();
                        }
                        if (NewScenarioWizard.this.openEditor) {
                            IDE.openEditor((IWorkbenchPage)NewScenarioWizard.this.getPage(), (IFile)((IFile)NewScenarioWizard.this.testCase.getResource()));
                        }
                        result[0] = true;
                    }
                    catch (Exception e) {
                        Q7UIPlugin.log(e);
                        result[0] = false;
                    }
                }
            });
        }
        catch (Throwable e) {
            Q7UIPlugin.log(e);
        }
        return result[0];
    }

    public String getType() {
        return "ecl";
    }

    private IWorkbenchPage getPage() {
        return this.workbench.getActiveWorkbenchWindow().getActivePage();
    }

    public IProject getProject() {
        return this.scenarioPage.getProject();
    }
}

