/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.merge;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.AdaptableFileTreeIterator;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.FileRevisionTypedElement;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.PlatformUI;

public class GitCompareEditorInput
extends CompareEditorInput {
    private static final Image FOLDER_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private final String baseVersion;
    private final String compareVersion;
    private final IResource[] resources;
    private final List<String> filterPathStrings = new ArrayList<String>();
    private final Map<IPath, IDiffContainer> diffRoots = new HashMap<IPath, IDiffContainer>();
    private Repository repository;

    public GitCompareEditorInput(String compareVersion, String baseVersion, IResource ... resources) {
        super(new CompareConfiguration());
        this.resources = this.convertResourceInput(resources);
        this.baseVersion = baseVersion;
        this.compareVersion = compareVersion;
    }

    public GitCompareEditorInput(String compareVersion, String baseVersion, Repository repository) {
        super(new CompareConfiguration());
        this.resources = new IResource[0];
        this.baseVersion = baseVersion;
        this.compareVersion = compareVersion;
        this.repository = repository;
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        RevWalk rw = null;
        try {
            Object[] titleParameters;
            RevCommit compareCommit;
            RevCommit baseCommit;
            monitor.beginTask(UIText.GitCompareEditorInput_CompareResourcesTaskName, -1);
            IResource[] iResourceArray = this.resources;
            int n = this.resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                RepositoryMapping map = RepositoryMapping.getMapping((IResource)resource.getProject());
                if (this.repository != null && this.repository != map.getRepository()) {
                    throw new InvocationTargetException(new IllegalStateException(UIText.GitCompareEditorInput_ResourcesInDifferentReposMessagge));
                }
                String repoRelativePath = map.getRepoRelativePath(resource);
                this.filterPathStrings.add(repoRelativePath);
                DiffNode node = new DiffNode(0){

                    public Image getImage() {
                        return FOLDER_IMAGE;
                    }
                };
                this.diffRoots.put((IPath)new Path(map.getRepoRelativePath(resource)), (IDiffContainer)node);
                this.repository = map.getRepository();
                ++n2;
            }
            if (this.repository == null) {
                throw new InvocationTargetException(new IllegalStateException(UIText.GitCompareEditorInput_ResourcesInDifferentReposMessagge));
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            rw = new RevWalk(this.repository);
            try {
                baseCommit = rw.parseCommit((AnyObjectId)this.repository.resolve(this.baseVersion));
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            if (this.compareVersion == null) {
                compareCommit = null;
            } else {
                try {
                    compareCommit = rw.parseCommit((AnyObjectId)this.repository.resolve(this.compareVersion));
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            CompareConfiguration config = this.getCompareConfiguration();
            config.setLeftLabel(this.compareVersion);
            config.setRightLabel(this.baseVersion);
            if (this.resources.length == 0) {
                titleParameters = new Object[]{Activator.getDefault().getRepositoryUtil().getRepositoryName(this.repository), this.compareVersion, this.baseVersion};
                this.setTitle(NLS.bind((String)UIText.GitCompareEditorInput_EditorTitle, (Object[])titleParameters));
            } else if (this.resources.length == 1) {
                titleParameters = new Object[]{this.resources[0].getFullPath().makeRelative().toString(), this.compareVersion, this.baseVersion};
                this.setTitle(NLS.bind((String)UIText.GitCompareEditorInput_EditorTitleSingleResource, (Object[])titleParameters));
            } else {
                this.setTitle(NLS.bind((String)UIText.GitCompareEditorInput_EditorTitleMultipleResources, (Object)this.compareVersion, (Object)this.baseVersion));
            }
            try {
                IDiffContainer iDiffContainer = this.buildDiffContainer(baseCommit, compareCommit, monitor);
                return iDiffContainer;
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            if (rw != null) {
                rw.dispose();
            }
            monitor.done();
        }
    }

    protected void contentsCreated() {
        super.contentsCreated();
        this.getNavigator().selectChange(true);
    }

    protected void handleDispose() {
        super.handleDispose();
    }

    private IDiffContainer buildDiffContainer(RevCommit baseCommit, RevCommit compareCommit, IProgressMonitor monitor) throws IOException, InterruptedException {
        int baseTreeIndex;
        String path;
        boolean useIndex = this.compareVersion.equals("%%%INDEX%%%");
        boolean checkIgnored = false;
        DiffNode result = new DiffNode(12);
        TreeWalk tw = new TreeWalk(this.repository);
        if (this.filterPathStrings.size() > 1) {
            ArrayList<PathFilter> suffixFilters = new ArrayList<PathFilter>();
            for (String filterPath : this.filterPathStrings) {
                suffixFilters.add(PathFilter.create((String)filterPath));
            }
            TreeFilter otf = OrTreeFilter.create(suffixFilters);
            tw.setFilter(otf);
        } else if (this.filterPathStrings.size() > 0 && (path = this.filterPathStrings.get(0)).length() != 0) {
            tw.setFilter((TreeFilter)PathFilter.create((String)path));
        }
        tw.setRecursive(true);
        if (baseCommit == null) {
            checkIgnored = true;
            baseTreeIndex = tw.addTree((AbstractTreeIterator)new AdaptableFileTreeIterator(this.repository, ResourcesPlugin.getWorkspace().getRoot()));
        } else {
            baseTreeIndex = tw.addTree((AbstractTreeIterator)new CanonicalTreeParser(null, this.repository.newObjectReader(), (AnyObjectId)baseCommit.getTree()));
        }
        int compareTreeIndex = !useIndex ? tw.addTree((AbstractTreeIterator)new CanonicalTreeParser(null, this.repository.newObjectReader(), (AnyObjectId)compareCommit.getTree())) : tw.addTree((AbstractTreeIterator)new DirCacheIterator(this.repository.readDirCache()));
        try {
            while (tw.next()) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                AbstractTreeIterator compareVersionIterator = tw.getTree(compareTreeIndex, AbstractTreeIterator.class);
                AbstractTreeIterator baseVersionIterator = tw.getTree(baseTreeIndex, AbstractTreeIterator.class);
                if (checkIgnored && baseVersionIterator != null && ((WorkingTreeIterator)baseVersionIterator).isEntryIgnored()) continue;
                if (compareVersionIterator != null && baseVersionIterator != null) {
                    boolean equalContent = compareVersionIterator.getEntryObjectId().equals((AnyObjectId)baseVersionIterator.getEntryObjectId());
                    if (equalContent) continue;
                    monitor.setTaskName(baseVersionIterator.getEntryPathString());
                    GitFileRevision baseRev = GitFileRevision.inCommit((Repository)this.repository, (RevCommit)baseCommit, (String)baseVersionIterator.getEntryPathString(), (ObjectId)tw.getObjectId(baseTreeIndex));
                    GitFileRevision compareRev = !useIndex ? GitFileRevision.inCommit((Repository)this.repository, (RevCommit)compareCommit, (String)compareVersionIterator.getEntryPathString(), (ObjectId)tw.getObjectId(compareTreeIndex)) : GitFileRevision.inIndex((Repository)this.repository, (String)compareVersionIterator.getEntryPathString());
                    this.add((IDiffContainer)result, baseVersionIterator.getEntryPathString(), new DiffNode((ITypedElement)new FileRevisionTypedElement((IFileRevision)baseRev), (ITypedElement)new FileRevisionTypedElement((IFileRevision)compareRev)));
                } else if (baseVersionIterator != null && compareVersionIterator == null) {
                    monitor.setTaskName(baseVersionIterator.getEntryPathString());
                    GitFileRevision baseRev = GitFileRevision.inCommit((Repository)this.repository, (RevCommit)baseCommit, (String)baseVersionIterator.getEntryPathString(), (ObjectId)tw.getObjectId(baseTreeIndex));
                    this.add((IDiffContainer)result, baseVersionIterator.getEntryPathString(), new DiffNode(2, null, null, (ITypedElement)new FileRevisionTypedElement((IFileRevision)baseRev)));
                } else if (compareVersionIterator != null && baseVersionIterator == null) {
                    monitor.setTaskName(compareVersionIterator.getEntryPathString());
                    GitFileRevision compareRev = GitFileRevision.inCommit((Repository)this.repository, (RevCommit)compareCommit, (String)compareVersionIterator.getEntryPathString(), (ObjectId)tw.getObjectId(compareTreeIndex));
                    this.add((IDiffContainer)result, compareVersionIterator.getEntryPathString(), new DiffNode(1, null, null, (ITypedElement)new FileRevisionTypedElement((IFileRevision)compareRev)));
                }
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
            DiffNode diffNode = result;
            return diffNode;
        }
        finally {
            tw.release();
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.baseVersion == null ? 0 : this.baseVersion.hashCode());
        result = 31 * result + (this.compareVersion == null ? 0 : this.compareVersion.hashCode());
        result = 31 * result + (this.repository == null ? 0 : this.repository.getDirectory().hashCode());
        result = 31 * result + Arrays.hashCode(this.resources);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GitCompareEditorInput other = (GitCompareEditorInput)((Object)obj);
        if (this.baseVersion == null ? other.baseVersion != null : !this.baseVersion.equals(other.baseVersion)) {
            return false;
        }
        if (this.compareVersion == null ? other.compareVersion != null : !this.compareVersion.equals(other.compareVersion)) {
            return false;
        }
        if (this.repository == null ? other.repository != null : !this.repository.getDirectory().equals(other.repository.getDirectory())) {
            return false;
        }
        return Arrays.equals(this.resources, other.resources);
    }

    private void add(IDiffContainer result, String filePath, DiffNode diffNode) {
        IDiffContainer container = this.getFileParent(result, filePath);
        container.add((IDiffElement)diffNode);
        diffNode.setParent(container);
    }

    private IDiffContainer getFileParent(IDiffContainer root, String filePath) {
        Path path = new Path(filePath);
        IDiffContainer child = root;
        if (this.diffRoots.isEmpty()) {
            int i = 0;
            while (i < path.segmentCount() - 1) {
                child = this.getOrCreateChild(child, path.segment(i));
                ++i;
            }
            return child;
        }
        for (Map.Entry<IPath, IDiffContainer> entry : this.diffRoots.entrySet()) {
            if (!entry.getKey().isPrefixOf((IPath)path)) continue;
            int i = entry.getKey().segmentCount();
            while (i < path.segmentCount() - 1) {
                child = this.getOrCreateChild(child, path.segment(i));
                ++i;
            }
            return child;
        }
        return null;
    }

    private DiffNode getOrCreateChild(IDiffContainer parent, final String name) {
        Object child;
        IDiffElement[] iDiffElementArray = parent.getChildren();
        int n = iDiffElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            child = iDiffElementArray[n2];
            if (child.getName().equals(name)) {
                return (DiffNode)child;
            }
            ++n2;
        }
        child = new DiffNode(parent, 0){

            public String getName() {
                return name;
            }

            public Image getImage() {
                return FOLDER_IMAGE;
            }
        };
        return child;
    }

    private IResource[] convertResourceInput(IResource[] input) {
        if (input.length > 0) {
            IResource originalInput;
            ArrayList<IResource> resourceList = new ArrayList<IResource>(input.length);
            ArrayList<IPath> allPaths = new ArrayList<IPath>(input.length);
            IResource[] iResourceArray = input;
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                originalInput = iResourceArray[n2];
                allPaths.add(originalInput.getFullPath());
                ++n2;
            }
            iResourceArray = input;
            n = input.length;
            n2 = 0;
            while (n2 < n) {
                originalInput = iResourceArray[n2];
                boolean skip = false;
                for (IPath path : allPaths) {
                    if (!path.isPrefixOf(originalInput.getFullPath()) || path.segmentCount() >= originalInput.getFullPath().segmentCount()) continue;
                    skip = true;
                    break;
                }
                if (!skip) {
                    resourceList.add(originalInput);
                }
                ++n2;
            }
            return resourceList.toArray(new IResource[resourceList.size()]);
        }
        return input;
    }
}

