/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.player;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rcptt.logging.Q7LoggingManager;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.GenericElementKind;
import org.eclipse.rcptt.tesla.core.protocol.UIColor;
import org.eclipse.rcptt.tesla.core.ui.Widget;
import org.eclipse.rcptt.tesla.internal.ui.IBasicMappingNode;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerTextUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWidgetUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWrapUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTModelMapper;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.viewers.Viewers;
import org.eclipse.rcptt.tesla.jface.ControlDecoratorRecordingHolder;
import org.eclipse.rcptt.tesla.swt.TeslaSWTMessages;
import org.eclipse.rcptt.util.swt.TableTreeUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class SWTUIElement
implements IBasicMappingNode {
    public final org.eclipse.swt.widgets.Widget widget;
    protected final SWTUIPlayer swtPlayer;
    private GenericElementKind kindOverride = null;

    public void overrideKind(GenericElementKind kind) {
        this.kindOverride = kind;
    }

    public SWTUIElement(org.eclipse.swt.widgets.Widget w, SWTUIPlayer p) {
        this.widget = w;
        this.swtPlayer = p;
    }

    @Override
    public String getGenerationKind() {
        return this.getKind().name();
    }

    public GenericElementKind getKind() {
        if (this.kindOverride != null) {
            return this.kindOverride;
        }
        return SWTUIPlayer.getKind(this.widget);
    }

    public boolean isSuitableForKind(GenericElementKind kind) {
        if (this.getKind().is(ElementKind.PropertyTab) && kind.is(ElementKind.Canvas)) {
            return true;
        }
        return this.getKind().is(kind);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.widget == null ? 0 : this.widget.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SWTUIElement other = (SWTUIElement)obj;
        return !(this.widget == null ? other.widget != null : !this.widget.equals(other.widget));
    }

    public boolean match(Object c) {
        return this.widget != null && this.widget.equals(c);
    }

    public String toString() {
        if (this.widget != null && this.widget.isDisposed()) {
            return NLS.bind((String)TeslaSWTMessages.SWTUIElement_ControlDisposed, (Object)this.widget.getClass().getSimpleName());
        }
        return this.widget == null ? TeslaSWTMessages.SWTUIElement_ControlNull : String.valueOf(this.widget.getClass().getSimpleName()) + ":" + this.getText();
    }

    public String getClassName() {
        return this.widget == null ? "null" : this.widget.getClass().getName();
    }

    public void setText(String text) {
        this.swtPlayer.setText(this, text);
    }

    public int countItems(String[] selection) {
        return this.swtPlayer.countItems(this, selection);
    }

    public String getText() {
        return PlayerTextUtils.getText(this);
    }

    public String getModificationText() {
        return PlayerTextUtils.replaceMultilinesNoTrim(PlayerTextUtils.getRawText(this));
    }

    public void setBackgroundColor(UIColor color) {
        this.swtPlayer.setBackgroundColor(this, color);
    }

    public void setBackgroundColor(int color) {
        this.swtPlayer.setBackgroundColor(this, color);
    }

    public UIColor getBackgroundColor() {
        return this.swtPlayer.getBackgroundColor(this);
    }

    public boolean isWindow() {
        return this.getKind().is(ElementKind.Window);
    }

    public boolean isView() {
        return this.getKind().is(ElementKind.View);
    }

    public boolean isTree() {
        return this.getKind().is(ElementKind.Tree);
    }

    public boolean isTable() {
        return this.getKind().is(ElementKind.Table);
    }

    public boolean isList() {
        return this.getKind().is(ElementKind.List);
    }

    public boolean isButton() {
        return this.getKind().is(ElementKind.Button);
    }

    public boolean isText() {
        return this.getKind().is(ElementKind.Text);
    }

    public void click() {
        this.swtPlayer.click(this);
    }

    public void clickAndWait() {
        this.swtPlayer.clickAndWait(this);
    }

    public boolean isDisposed() {
        return this.swtPlayer.isDisposed(this);
    }

    public void show() {
        this.swtPlayer.show(this, -1, -1);
    }

    public boolean setSelection(List<String[]> selection, boolean selectAll) {
        return Viewers.setSelection(this, selection, selectAll);
    }

    public boolean setSelection(String[] selection, String pattern, Integer index, boolean selectAll) {
        return Viewers.setSelection(this, selection, pattern, index, selectAll);
    }

    public int expandSelection(String[] selection, String pattern, Integer index) {
        return Viewers.expandSelection(this, selection, pattern, index);
    }

    public void close() {
        this.swtPlayer.close(this);
    }

    public boolean isDisabled() {
        return PlayerWidgetUtils.isDisabled(this);
    }

    public String[] getPathSelection() {
        return Viewers.getPathSelection(this);
    }

    public SWTUIPlayer getPlayer() {
        return this.swtPlayer;
    }

    public String getSelectedTab() {
        return this.swtPlayer.getSelectedTabItem(this);
    }

    public boolean isSupportMultipleSelections() {
        if (this.widget instanceof Tree || this.widget instanceof Table || this.widget instanceof org.eclipse.swt.widgets.List) {
            int style = this.widget.getStyle();
            return (style & 2) != 0;
        }
        return false;
    }

    public String[][] getMultiPathSelection() {
        return Viewers.getMultiPathSelection(this);
    }

    public Widget getModel() {
        if (TeslaFeatures.isActivityLogging()) {
            Q7LoggingManager.logMessage((String)"widget.properties", (String)("begin property mapping for: " + this.getClassName()));
        }
        return SWTModelMapper.map(this);
    }

    public org.eclipse.swt.widgets.Widget unwrap() {
        return PlayerWrapUtils.unwrapWidget(this);
    }

    public boolean isWorkbenchWindow() {
        if (this.getKind().is(ElementKind.Window)) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().equals(this.widget);
        }
        return false;
    }

    public Rectangle getBounds() {
        if (this.widget.isDisposed()) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (this.widget instanceof Control) {
            Rectangle bounds = ((Control)this.widget).getBounds();
            if (((Control)this.widget).getParent() != null) {
                Point point = ((Control)this.widget).toDisplay(bounds.x, bounds.y);
                bounds.x = point.x;
                bounds.y = point.y;
            }
            return bounds;
        }
        if (this.widget instanceof TreeItem || this.widget instanceof TableItem) {
            return TableTreeUtil.getItemBounds((org.eclipse.swt.widgets.Widget)this.widget);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public List<ControlDecoration> getDecorators() {
        List<Object> result = new ArrayList<ControlDecoration>();
        if (this.widget instanceof Control) {
            result = ControlDecoratorRecordingHolder.getDecorators((Control)((Control)this.widget));
        }
        return result;
    }
}

