/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.internal.repository.tools.Activator;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryAnalyzer;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.osgi.framework.BundleContext;

public class RepositoryAnalyzerApplication
implements IApplication {
    private URI uri = null;

    public Object start(IApplicationContext context) throws Exception {
        long start = System.currentTimeMillis();
        this.processArguments((String[])context.getArguments().get("application.args"));
        IProvisioningAgent agent = (IProvisioningAgent)ServiceHelper.getService((BundleContext)Activator.getBundleContext(), (String)IProvisioningAgent.SERVICE_NAME);
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        IMetadataRepository repository = manager.loadRepository(this.uri, (IProgressMonitor)new NullProgressMonitor());
        RepositoryAnalyzer repositoryAnalyzer = new RepositoryAnalyzer(new IMetadataRepository[]{repository});
        IStatus status = repositoryAnalyzer.analyze((IProgressMonitor)new NullProgressMonitor());
        IStatus[] children = status.getChildren();
        long time = System.currentTimeMillis() - start;
        if (status.isOK()) {
            System.out.println("Repository Analyzer Finished succesfuly in " + time + " ms.");
        } else {
            System.out.println("Repository Analyzer Finished in " + time + " ms with status with errors.");
        }
        int i = 0;
        while (i < children.length) {
            if (children[i].isOK()) {
                System.out.print("[OK] ");
            } else {
                System.out.print("[Error] ");
            }
            System.out.println(children[i].getMessage());
            if (children[i].isMultiStatus() && children[i].getChildren() != null && children[i].getChildren().length > 0) {
                IStatus[] subChildren = children[i].getChildren();
                int j = 0;
                while (j < subChildren.length) {
                    System.out.println("   " + subChildren[j].getMessage());
                    ++j;
                }
            }
            ++i;
        }
        return IApplication.EXIT_OK;
    }

    private void processArguments(String[] args) throws CoreException, URISyntaxException {
        int i = 0;
        while (i < args.length) {
            if (("-m".equals(args[i]) || "-metadataRepository".equals(args[i])) && i + 1 < args.length) {
                this.uri = new URI(args[i + 1]);
            }
            ++i;
        }
        this.validateLaunch();
    }

    private void validateLaunch() throws CoreException {
        if (this.uri == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.p2.transformer", "-metadataRepository <metadataURI> must be specified"));
        }
    }

    public void stop() {
    }
}

