/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.client.ResponseHandler;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;

public class NewEntryHandler
extends ResponseHandler {
    public String getResponseID() {
        return "New-entry";
    }

    public void handle(Session session, String localDir, IProgressMonitor monitor) throws CVSException {
        String repositoryFile = session.readLine();
        String entryLine = session.readLine();
        session.setModTime(null);
        String fileName = repositoryFile.substring(repositoryFile.lastIndexOf("/") + 1);
        ICVSFolder mParent = session.getLocalRoot().getFolder(localDir);
        ICVSFile mFile = mParent.getFile(fileName);
        ResourceSyncInfo fileInfo = mFile.getSyncInfo();
        MutableResourceSyncInfo newInfo = fileInfo.cloneMutable();
        newInfo.setEntryLine(entryLine);
        CVSTag newTag = newInfo.getTag();
        if (newTag != null && newTag.isBaseTag()) {
            newInfo.setTag(fileInfo.getTag());
        }
        mFile.setSyncInfo(newInfo, 0);
    }
}

