/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTreeContentProvider;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationView;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class LaunchConfigurationViewer
extends TreeViewer {
    private int fTotalCount = 0;
    private LaunchConfigurationView fView = null;

    public LaunchConfigurationViewer(Tree tree) {
        super(tree);
    }

    public LaunchConfigurationViewer(Composite parent, int style) {
        this(new Tree(parent, style));
    }

    protected void preservingSelection(Runnable updateCode) {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        if (!selection.isEmpty()) {
            Tree tree;
            int[] indices = this.collectIndices(selection.getFirstElement());
            updateCode.run();
            ArrayList<Object> set = new ArrayList<Object>();
            Object o = null;
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                o = iter.next();
                if (o instanceof ILaunchConfiguration && !((ILaunchConfiguration)o).exists() || this.internalGetWidgetToSelect(o) == null || set.contains(o)) continue;
                set.add(o);
            }
            if (set.isEmpty() && (tree = this.getTree()).getItemCount() > 0) {
                int index = this.selectIndex(tree.getItemCount(), indices[0]);
                if (index > -1) {
                    TreeItem pitem = null;
                    pitem = indices[0] > tree.getItemCount() - 1 ? tree.getItem(tree.getItemCount() - 1) : tree.getItem(indices[0]);
                    if (pitem != null) {
                        o = pitem.getData();
                        if (indices[1] > -1) {
                            index = this.selectIndex(pitem.getItemCount(), indices[1]);
                            if (index > -1) {
                                ILaunchConfiguration config = null;
                                int i = index;
                                while (i > -1) {
                                    config = (ILaunchConfiguration)pitem.getItem(i).getData();
                                    if (config != null && config.exists()) {
                                        o = config;
                                        break;
                                    }
                                    --i;
                                }
                            } else if (pitem.getItemCount() > 0 && (o = pitem.getItem(indices[1] - 1 > -1 ? indices[1] - 1 : 0).getData()) == null) {
                                o = pitem.getData();
                            }
                        }
                    }
                }
                if (!set.contains(o)) {
                    set.add(o);
                }
            }
            this.setSelection((ISelection)new StructuredSelection(set), true);
        } else {
            super.preservingSelection(updateCode);
        }
        this.getTree().getHorizontalBar().setSelection(0);
    }

    private int selectIndex(int count, int index) {
        if (index < count) {
            return index;
        }
        if (index > count - 1) {
            return count - 1;
        }
        if (index < 0) {
            return 0;
        }
        return -1;
    }

    protected int getTotalChildCount() {
        return this.fTotalCount;
    }

    public void remove(Object elementsOrTreePaths) {
        super.remove(elementsOrTreePaths);
        --this.fTotalCount;
    }

    protected void internalAdd(Widget widget, Object parentElement, Object[] childElements) {
        super.internalAdd(widget, parentElement, childElements);
        ++this.fTotalCount;
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        LaunchConfigurationTreeContentProvider cp = (LaunchConfigurationTreeContentProvider)this.getContentProvider();
        Object[] types = cp.getElements(null);
        LaunchGroupFilter filter = new LaunchGroupFilter(((LaunchConfigurationsDialog)LaunchConfigurationsDialog.getCurrentlyVisibleLaunchConfigurationDialog()).getLaunchGroup());
        ILaunchConfiguration[] configs = null;
        int i = 0;
        while (i < types.length) {
            if (filter.select((Viewer)this, types[i], null)) {
                ++this.fTotalCount;
                configs = (ILaunchConfiguration[])cp.getChildren(types[i]);
                int j = 0;
                while (j < configs.length) {
                    if (LaunchConfigurationManager.isVisible(configs[j])) {
                        ++this.fTotalCount;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected int getNonFilteredChildCount() {
        int count = 0;
        this.getTree().setRedraw(false);
        TreeItem[] items = this.getTree().getItems();
        count += items.length;
        boolean expanded = false;
        TreeItem item = null;
        int i = 0;
        while (i < items.length) {
            item = items[i];
            expanded = item.getExpanded();
            this.setExpandedState(item.getData(), true);
            count += item.getItems().length;
            item.setExpanded(expanded);
            ++i;
        }
        this.getTree().setRedraw(true);
        return count;
    }

    private int[] collectIndices(Object object) {
        TreePath path;
        TreeItem item;
        int[] indices = new int[]{-1, -1};
        if (object != null && (item = (TreeItem)this.findItem(object)) != null && (item = (TreeItem)this.findItem((path = this.getTreePathFromItem((Item)item)).getFirstSegment())) != null) {
            indices[0] = this.getTree().indexOf(item);
            if (path.getSegmentCount() == 2) {
                indices[1] = this.indexOf(item.getItems(), path.getLastSegment());
            }
        }
        return indices;
    }

    private int indexOf(TreeItem[] items, Object object) {
        if (object != null) {
            int i = 0;
            while (i < items.length) {
                if (object.equals(items[i].getData())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    protected void filterChanged() {
        if (this.fView != null) {
            this.fView.updateFilterLabel();
        }
    }

    protected void setLaunchConfigurationView(LaunchConfigurationView launchConfigurationView) {
        this.fView = launchConfigurationView;
    }
}

