/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.actions;

import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.actions.ProfileModificationAction;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.model.InstalledIUElement;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.viewers.ISelectionProvider;

public abstract class ExistingIUInProfileAction
extends ProfileModificationAction {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ExistingIUInProfileAction(ProvisioningUI ui, String label, ISelectionProvider selectionProvider, String profileId) {
        super(ui, label, selectionProvider, profileId);
    }

    protected boolean isEnabledFor(Object[] selectionArray) {
        Object parent = null;
        IProfile profile = this.getProfile();
        if (selectionArray.length > 0) {
            int i = 0;
            while (i < selectionArray.length) {
                if (selectionArray[i] instanceof InstalledIUElement) {
                    InstalledIUElement element = (InstalledIUElement)selectionArray[i];
                    if (parent == null) {
                        parent = element.getParent(element);
                    } else if (parent != element.getParent(element)) {
                        return false;
                    }
                    if (!this.isSelectable(element.getIU(), profile)) {
                        return false;
                    }
                } else {
                    IInstallableUnit iu;
                    Object object = selectionArray[i];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((iu = (IInstallableUnit)ProvUI.getAdapter(object, clazz)) == null || !this.isSelectable(iu)) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected boolean isSelectable(IIUElement element) {
        if (!super.isSelectable(element)) {
            return false;
        }
        Object parent = element.getParent(element);
        if (parent != null) {
            IProfile profile;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.equinox.p2.engine.IProfile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((profile = (IProfile)ProvUI.getAdapter(parent, clazz)) != null) {
                return this.isSelectable(element.getIU(), profile);
            }
        }
        return false;
    }

    protected boolean isSelectable(IInstallableUnit iu) {
        if (!super.isSelectable(iu)) {
            return false;
        }
        return this.isSelectable(iu, this.getProfile());
    }

    private boolean isSelectable(IInstallableUnit iu, IProfile profile) {
        int lock = this.getLock(profile, iu);
        if ((lock & this.getLockConstant()) == this.getLockConstant()) {
            return false;
        }
        return !profile.query(QueryUtil.createPipeQuery((IQuery)QueryUtil.createIUQuery((IVersionedId)iu), this.getPolicy().getVisibleInstalledIUQuery()), null).isEmpty();
    }

    protected abstract int getLockConstant();
}

