/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.help.ui.internal.HyperlinkLabel;
import org.eclipse.help.ui.internal.IHyperlinkListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

public class HyperlinkHandler
implements MouseListener,
MouseTrackListener,
PaintListener,
Listener {
    public static final int UNDERLINE_NEVER = 1;
    public static final int UNDERLINE_ROLLOVER = 2;
    public static final int UNDERLINE_ALWAYS = 3;
    private Cursor hyperlinkCursor;
    private Cursor busyCursor;
    private boolean hyperlinkCursorUsed = true;
    private int hyperlinkUnderlineMode = 3;
    private Color background;
    private Color foreground;
    private Color activeBackground;
    private Color activeForeground;
    private Hashtable hyperlinkListeners = new Hashtable();
    private Control lastLink;

    public HyperlinkHandler() {
        this.hyperlinkCursor = new Cursor((Device)Display.getCurrent(), 21);
        this.busyCursor = new Cursor((Device)Display.getCurrent(), 1);
    }

    public void dispose() {
        this.hyperlinkCursor.dispose();
        this.busyCursor.dispose();
    }

    public Color getActiveBackground() {
        return this.activeBackground;
    }

    public Color getActiveForeground() {
        return this.activeForeground;
    }

    public Color getBackground() {
        return this.background;
    }

    public Cursor getBusyCursor() {
        return this.busyCursor;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Cursor getHyperlinkCursor() {
        return this.hyperlinkCursor;
    }

    public int getHyperlinkUnderlineMode() {
        return this.hyperlinkUnderlineMode;
    }

    public Control getLastLink() {
        return this.lastLink;
    }

    public boolean isHyperlinkCursorUsed() {
        return this.hyperlinkCursorUsed;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (e.button == 1) {
            return;
        }
        this.lastLink = (Control)e.widget;
    }

    public void mouseEnter(MouseEvent e) {
        IHyperlinkListener action;
        Control control = (Control)e.widget;
        if (this.isHyperlinkCursorUsed()) {
            control.setCursor(this.hyperlinkCursor);
        }
        if (this.activeBackground != null) {
            control.setBackground(this.activeBackground);
        }
        if (this.activeForeground != null) {
            control.setForeground(this.activeForeground);
        }
        if (this.hyperlinkUnderlineMode == 2) {
            HyperlinkHandler.underline(control, true);
        }
        if ((action = this.getLinkListener(control)) != null) {
            action.linkEntered(control);
        }
    }

    public void mouseExit(MouseEvent e) {
        IHyperlinkListener action;
        Control control = (Control)e.widget;
        if (this.isHyperlinkCursorUsed()) {
            control.setCursor(null);
        }
        if (this.hyperlinkUnderlineMode == 2) {
            HyperlinkHandler.underline(control, false);
        }
        if (this.background != null) {
            control.setBackground(this.background);
        }
        if (this.foreground != null) {
            control.setForeground(this.foreground);
        }
        if ((action = this.getLinkListener(control)) != null) {
            action.linkExited(control);
        }
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
        if (e.button != 1) {
            return;
        }
        IHyperlinkListener action = this.getLinkListener((Control)e.widget);
        if (action != null) {
            Control c = (Control)e.widget;
            c.setCursor(this.busyCursor);
            action.linkActivated(c);
            if (!c.isDisposed()) {
                c.setCursor(this.isHyperlinkCursorUsed() ? this.hyperlinkCursor : null);
            }
        }
    }

    public void paintControl(PaintEvent e) {
        Control control = (Control)e.widget;
        if (this.hyperlinkUnderlineMode == 3) {
            HyperlinkHandler.underline(control, true);
        }
    }

    public void registerHyperlink(Control control, IHyperlinkListener listener) {
        if (this.background != null) {
            control.setBackground(this.background);
        }
        if (this.foreground != null) {
            control.setForeground(this.foreground);
        }
        control.addMouseListener((MouseListener)this);
        control.addMouseTrackListener((MouseTrackListener)this);
        control.addListener(14, (Listener)this);
        if (this.hyperlinkUnderlineMode == 3) {
            control.addPaintListener((PaintListener)this);
        }
        this.hyperlinkListeners.put(control, listener);
        this.removeDisposedLinks();
    }

    public IHyperlinkListener getLinkListener(Control c) {
        if (c instanceof Label) {
            c = c.getParent();
        }
        return (IHyperlinkListener)this.hyperlinkListeners.get(c);
    }

    private void removeDisposedLinks() {
        Enumeration keys = this.hyperlinkListeners.keys();
        while (keys.hasMoreElements()) {
            Control control = (Control)keys.nextElement();
            if (!control.isDisposed()) continue;
            this.hyperlinkListeners.remove(control);
        }
    }

    public void reset() {
        this.hyperlinkListeners.clear();
    }

    public void setActiveBackground(Color newActiveBackground) {
        this.activeBackground = newActiveBackground;
    }

    public void setActiveForeground(Color newActiveForeground) {
        this.activeForeground = newActiveForeground;
    }

    public void setBackground(Color newBackground) {
        this.background = newBackground;
    }

    public void setForeground(Color newForeground) {
        this.foreground = newForeground;
    }

    public void setHyperlinkCursorUsed(boolean newHyperlinkCursorUsed) {
        this.hyperlinkCursorUsed = newHyperlinkCursorUsed;
    }

    public void setHyperlinkUnderlineMode(int newHyperlinkUnderlineMode) {
        this.hyperlinkUnderlineMode = newHyperlinkUnderlineMode;
    }

    public static void underline(Control control, boolean inside) {
        if (control instanceof HyperlinkLabel) {
            control = ((HyperlinkLabel)control).getLabel();
        }
        Composite parent = control.getParent();
        Rectangle bounds = control.getBounds();
        GC gc = new GC((Drawable)parent);
        Color color = inside ? control.getForeground() : control.getBackground();
        gc.setForeground(color);
        int y = bounds.y + bounds.height;
        gc.drawLine(bounds.x, y, bounds.x + bounds.width, y);
        gc.dispose();
    }

    public void handleEvent(Event event) {
        IHyperlinkListener listener = this.getLinkListener((Control)event.widget);
        listener.linkActivated((Control)event.widget);
    }
}

