/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.dialogfields;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckedListDialogField<E>
extends ListDialogField<E> {
    private int fCheckAllButtonIndex = -1;
    private int fUncheckAllButtonIndex = -1;
    private List<E> fCheckedElements = new ArrayList();
    private List<E> fGrayedElements = new ArrayList();

    public CheckedListDialogField(IListAdapter<E> adapter, String[] customButtonLabels, ILabelProvider lprovider) {
        super(adapter, customButtonLabels, lprovider);
    }

    public void setCheckAllButtonIndex(int checkAllButtonIndex) {
        Assert.isTrue((checkAllButtonIndex < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fCheckAllButtonIndex = checkAllButtonIndex;
    }

    public void setUncheckAllButtonIndex(int uncheckAllButtonIndex) {
        Assert.isTrue((uncheckAllButtonIndex < this.fButtonLabels.length ? 1 : 0) != 0);
        this.fUncheckAllButtonIndex = uncheckAllButtonIndex;
    }

    @Override
    protected TableViewer createTableViewer(Composite parent) {
        Table table = new Table(parent, 0x20 | this.getListStyle());
        table.setFont(parent.getFont());
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(table);
        tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                CheckedListDialogField.this.doCheckStateChanged(e);
            }
        });
        return tableViewer;
    }

    @Override
    public Control getListControl(Composite parent) {
        Control control = super.getListControl(parent);
        if (parent != null) {
            ((CheckboxTableViewer)this.fTable).setCheckedElements(this.fCheckedElements.toArray());
            ((CheckboxTableViewer)this.fTable).setGrayedElements(this.fGrayedElements.toArray());
        }
        return control;
    }

    @Override
    public void dialogFieldChanged() {
        int i = this.fCheckedElements.size() - 1;
        while (i >= 0) {
            if (!this.fElements.contains(this.fCheckedElements.get(i))) {
                this.fCheckedElements.remove(i);
            }
            --i;
        }
        super.dialogFieldChanged();
    }

    private void checkStateChanged() {
        super.dialogFieldChanged();
    }

    public List<E> getCheckedElements() {
        if (this.isOkToUse(this.fTableControl)) {
            Object[] checked = ((CheckboxTableViewer)this.fTable).getCheckedElements();
            ArrayList<Object> res = new ArrayList<Object>(checked.length);
            int i = 0;
            while (i < checked.length) {
                res.add(checked[i]);
                ++i;
            }
            return res;
        }
        return new ArrayList<E>(this.fCheckedElements);
    }

    public int getCheckedSize() {
        return this.fCheckedElements.size();
    }

    public boolean isChecked(Object obj) {
        if (this.isOkToUse(this.fTableControl)) {
            return ((CheckboxTableViewer)this.fTable).getChecked(obj);
        }
        return this.fCheckedElements.contains(obj);
    }

    public boolean isGrayed(Object obj) {
        if (this.isOkToUse(this.fTableControl)) {
            return ((CheckboxTableViewer)this.fTable).getGrayed(obj);
        }
        return this.fGrayedElements.contains(obj);
    }

    public void setCheckedElements(Collection<E> list) {
        this.fCheckedElements = new ArrayList<E>(list);
        if (this.isOkToUse(this.fTableControl)) {
            ((CheckboxTableViewer)this.fTable).setCheckedElements(list.toArray());
        }
        this.checkStateChanged();
    }

    public void setChecked(E object, boolean state) {
        this.setCheckedWithoutUpdate(object, state);
        this.checkStateChanged();
    }

    public void setCheckedWithoutUpdate(E object, boolean state) {
        if (state) {
            if (!this.fCheckedElements.contains(object)) {
                this.fCheckedElements.add(object);
            }
        } else {
            this.fCheckedElements.remove(object);
        }
        if (this.isOkToUse(this.fTableControl)) {
            ((CheckboxTableViewer)this.fTable).setChecked(object, state);
        }
    }

    public void setGrayedWithoutUpdate(E object, boolean state) {
        if (state) {
            if (!this.fGrayedElements.contains(object)) {
                this.fGrayedElements.add(object);
            }
        } else {
            this.fGrayedElements.remove(object);
        }
        if (this.isOkToUse(this.fTableControl)) {
            ((CheckboxTableViewer)this.fTable).setGrayed(object, state);
        }
    }

    public void checkAll(boolean state) {
        if (state) {
            this.fCheckedElements = this.getElements();
        } else {
            this.fCheckedElements.clear();
        }
        if (this.isOkToUse(this.fTableControl)) {
            ((CheckboxTableViewer)this.fTable).setAllChecked(state);
        }
        this.checkStateChanged();
    }

    private void doCheckStateChanged(CheckStateChangedEvent e) {
        if (e.getChecked()) {
            this.fCheckedElements.add(e.getElement());
        } else {
            this.fCheckedElements.remove(e.getElement());
        }
        this.checkStateChanged();
    }

    @Override
    public void replaceElement(E oldElement, E newElement) throws IllegalArgumentException {
        boolean wasChecked = this.isChecked(oldElement);
        super.replaceElement(oldElement, newElement);
        this.setChecked(newElement, wasChecked);
    }

    @Override
    protected boolean getManagedButtonState(ISelection sel, int index) {
        if (index == this.fCheckAllButtonIndex) {
            return !this.fElements.isEmpty();
        }
        if (index == this.fUncheckAllButtonIndex) {
            return !this.fElements.isEmpty();
        }
        return super.getManagedButtonState(sel, index);
    }

    @Override
    protected boolean managedButtonPressed(int index) {
        if (index == this.fCheckAllButtonIndex) {
            this.checkAll(true);
        } else if (index == this.fUncheckAllButtonIndex) {
            this.checkAll(false);
        } else {
            return super.managedButtonPressed(index);
        }
        return true;
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.isOkToUse(this.fTableControl)) {
            ((CheckboxTableViewer)this.fTable).setCheckedElements(this.fCheckedElements.toArray());
            ((CheckboxTableViewer)this.fTable).setGrayedElements(this.fGrayedElements.toArray());
        }
    }
}

