/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core.gef;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTEventDispatcher;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.diagram.DiagramViewerUIElement;
import org.eclipse.rcptt.tesla.core.protocol.diagram.FigureUIElement;
import org.eclipse.rcptt.tesla.core.protocol.diagram.MouseCommandKind;
import org.eclipse.rcptt.tesla.core.protocol.raw.SetMode;
import org.eclipse.rcptt.tesla.internal.ui.player.FindResult;
import org.eclipse.rcptt.tesla.recording.aspects.draw2d.Draw2DEventManager;
import org.eclipse.rcptt.tesla.recording.aspects.draw2d.IDraw2DEventListener;
import org.eclipse.rcptt.tesla.recording.core.IRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.IRecordingProcessor;
import org.eclipse.rcptt.tesla.recording.core.IRecordingProcessorExtension;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;
import org.eclipse.rcptt.tesla.recording.core.gef.Draw2DRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.swt.BasicRecordingHelper;
import org.eclipse.rcptt.tesla.recording.core.swt.SWTEventRecorder;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Canvas;

public class Draw2dEventRecorder
implements IRecordingProcessor,
IDraw2DEventListener,
IRecordingProcessorExtension {
    private TeslaRecorder recorder;
    private SWTEventRecorder swtProcessor;

    public Draw2dEventRecorder() {
        Draw2DEventManager.addListener((IDraw2DEventListener)this);
    }

    public void clear() {
        Draw2DRecordingHelper.getHelper().clear();
    }

    public void initialize(TeslaRecorder teslaRecorder) {
        this.recorder = teslaRecorder;
    }

    public int getInitLevel() {
        return 900;
    }

    private synchronized SWTEventRecorder getSWTProcessor() {
        if (this.swtProcessor == null) {
            this.swtProcessor = (SWTEventRecorder)this.recorder.getProcessor(SWTEventRecorder.class);
        }
        return this.swtProcessor;
    }

    public void setFreeze(boolean value, SetMode command) {
    }

    public void mouseDoubleClick(SWTEventDispatcher disp, MouseEvent event) {
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
        this.mouseOp(event, MouseCommandKind.DOUBLE_CLICK, disp);
    }

    public void mouseEntered(SWTEventDispatcher disp, MouseEvent event) {
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
        this.mouseOp(event, MouseCommandKind.ENTER, disp);
    }

    public void mouseExited(SWTEventDispatcher disp, MouseEvent event) {
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
        this.mouseOp(event, MouseCommandKind.EXIT, disp);
    }

    public void mouseHover(SWTEventDispatcher disp, MouseEvent event) {
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
        this.mouseOp(event, MouseCommandKind.HOVER, disp);
    }

    public void mouseMoved(SWTEventDispatcher disp, MouseEvent event) {
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
        if ((event.stateMask & SWT.BUTTON_MASK) != 0) {
            this.mouseOp(event, MouseCommandKind.DRAG, disp);
        } else {
            this.mouseOp(event, MouseCommandKind.MOVE, disp);
        }
    }

    public void mousePressed(SWTEventDispatcher disp, MouseEvent event) {
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
        this.mouseOp(event, MouseCommandKind.DOWN, disp);
    }

    private FigureUIElement getFigureByAddress(FigureUIElement diagramViewer, IFigure figure, List<Integer> address) {
        BasicRecordingHelper.ElementEntry el = Draw2DRecordingHelper.getHelper().get(figure);
        FigureUIElement element = null;
        if (el != null) {
            element = new FigureUIElement(el.getElement(), (UIPlayer)this.recorder);
        } else {
            element = diagramViewer.rawFigure(address);
            Draw2DRecordingHelper.getHelper().put(figure, new BasicRecordingHelper.ElementEntry(element.getElement()));
        }
        return element;
    }

    private void mouseOp(MouseEvent event, MouseCommandKind op, SWTEventDispatcher disp) {
        if (TeslaFeatures.getInstance().isTrue("org.eclipse.rcptt.tesla.recording.iml.imaging.use") && !TeslaFeatures.getInstance().isTrue("org.eclipse.rcptt.tesla.recording.iml.imaging.use.raw.canvas.only")) {
            return;
        }
        if (ContextManagement.currentContext().containsClass("org.eclipse.gef.ui.parts.DomainEventDispatcher")) {
            return;
        }
        List list = this.recorder.getProcessors(IRecordingProcessorExtension.class);
        for (IRecordingProcessorExtension ext : list) {
            if (!(event.widget instanceof Canvas) || !ext.isNotDraw2d((Object)event.widget)) continue;
            return;
        }
        FindResult canvas = this.getSWTProcessor().getLocator().findElement(event.widget, false, false, false);
        if (canvas != null) {
            DiagramViewerUIElement canvasCtrl = new DiagramViewerUIElement(canvas.element, (UIPlayer)this.recorder);
            if (event.widget instanceof FigureCanvas) {
                FigureCanvas cv = (FigureCanvas)event.widget;
                IFigure figure = cv.getContents();
                FigureAddress fa = Draw2dEventRecorder.getAddress(figure, event.x, event.y);
                if (op.equals((Object)MouseCommandKind.DRAG)) {
                    fa.lastFigure = figure;
                    fa.path.clear();
                }
                Rectangle bounds = fa.lastFigure.getBounds().getCopy();
                fa.lastFigure.translateToAbsolute((Translatable)bounds);
                int px = event.x - bounds.x;
                int py = event.y - bounds.y;
                org.eclipse.swt.graphics.Rectangle bounds2 = cv.getBounds();
                if (fa.path != null && fa.path.size() > 0) {
                    FigureUIElement element = this.getFigureByAddress((FigureUIElement)canvasCtrl, fa.lastFigure, fa.path);
                    element.executeFigureMouseCommand(px, py, event.button, op, null, null, bounds2.width, bounds2.height, bounds.width, bounds.height, event.stateMask);
                    return;
                }
                canvasCtrl.executeFigureMouseCommand(px, py, event.button, op, null, fa.path, bounds2.width, bounds2.height, bounds.width, bounds.height, event.stateMask);
            }
        }
    }

    public static FigureAddress getAddress(IFigure figure, int x, int y) {
        ArrayList<Integer> path = new ArrayList<Integer>();
        while (figure != null) {
            List children = figure.getChildren();
            boolean changed = false;
            for (Object child : children) {
                if (!(child instanceof IFigure) || !((IFigure)child).containsPoint(x, y)) continue;
                path.add(children.indexOf(child));
                figure = (IFigure)child;
                changed = true;
                break;
            }
            if (!changed) break;
        }
        FigureAddress fa = new FigureAddress();
        fa.lastFigure = figure;
        fa.path = path;
        return fa;
    }

    public void mouseReleased(SWTEventDispatcher disp, MouseEvent event) {
        if (this.recorder == null) {
            return;
        }
        if (!this.recorder.hasListeners()) {
            return;
        }
        this.mouseOp(event, MouseCommandKind.UP, disp);
    }

    public void resetAssertSelection() {
    }

    public IRecordingHelper getHelper() {
        return Draw2DRecordingHelper.getHelper();
    }

    public boolean isIgnored(Object widget, int type, Object event) {
        return false;
    }

    public boolean isNotCanvas(Object widget, int type, Object event) {
        return widget instanceof FigureCanvas;
    }

    public boolean isNotDraw2d(Object widget) {
        return false;
    }

    public static class FigureAddress {
        public List<Integer> path;
        public IFigure lastFigure;
    }
}

