/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeEvent;
import org.eclipse.team.core.synchronize.ISyncInfoTreeChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.CheckedInChangeSet;
import org.eclipse.team.internal.core.subscribers.IChangeSetChangeListener;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.synchronize.AbstractSynchronizeModelProvider;
import org.eclipse.team.internal.ui.synchronize.ActiveChangeSetCollector;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.ChangeSetDiffNode;
import org.eclipse.team.internal.ui.synchronize.ChangeSetModelSorter;
import org.eclipse.team.internal.ui.synchronize.CompositeModelProvider;
import org.eclipse.team.internal.ui.synchronize.IChangeSetProvider;
import org.eclipse.team.internal.ui.synchronize.ISynchronizeModelProvider;
import org.eclipse.team.internal.ui.synchronize.ISynchronizeModelProviderDescriptor;
import org.eclipse.team.internal.ui.synchronize.SyncInfoSetChangeSetCollector;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelProvider;
import org.eclipse.team.internal.ui.synchronize.actions.ChangeSetActionGroup;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;

public class ChangeSetModelProvider
extends CompositeModelProvider {
    private ViewerSorter viewerSorter;
    private final String subProvierId;
    private Map rootToProvider = new HashMap();
    private ViewerSorter embeddedSorter;
    private SyncInfoSetChangeSetCollector checkedInCollector;
    private IChangeSetChangeListener changeSetListener = new IChangeSetChangeListener(){

        public void setAdded(ChangeSet set) {
            SyncInfoTree syncInfoSet = set instanceof CheckedInChangeSet ? ChangeSetModelProvider.this.checkedInCollector.getSyncInfoSet(set) : ChangeSetModelProvider.this.activeCollector.getSyncInfoSet(set);
            if (syncInfoSet != null) {
                ChangeSetModelProvider.this.createChangeSetModelElement(set, syncInfoSet);
            }
        }

        public void defaultSetChanged(ChangeSet previousDefault, ChangeSet set) {
            ChangeSetModelProvider.this.refreshLabel(previousDefault);
            ChangeSetModelProvider.this.refreshLabel(set);
        }

        public void setRemoved(ChangeSet set) {
            ChangeSetModelProvider.this.removeModelElementForSet(set);
        }

        public void nameChanged(ChangeSet set) {
            ChangeSetModelProvider.this.refreshLabel(set);
        }

        public void resourcesChanged(ChangeSet set, IPath[] paths) {
        }
    };
    private ActiveChangeSetCollector activeCollector;
    private static final ChangeSetModelProviderDescriptor descriptor = new ChangeSetModelProviderDescriptor();

    protected ChangeSetModelProvider(ISynchronizePageConfiguration configuration, SyncInfoSet set, String subProvierId) {
        super(configuration, set);
        this.subProvierId = subProvierId;
        ChangeSetCapability changeSetCapability = this.getChangeSetCapability();
        if (changeSetCapability.supportsCheckedInChangeSets()) {
            this.checkedInCollector = changeSetCapability.createSyncInfoSetChangeSetCollector(configuration);
            this.checkedInCollector.setProvider(this);
            this.checkedInCollector.addListener(this.changeSetListener);
        }
        if (changeSetCapability.supportsActiveChangeSets()) {
            this.activeCollector = new ActiveChangeSetCollector(configuration, this);
            this.activeCollector.setChangeSetChangeListener(this.changeSetListener);
            configuration.addMenuGroup("org.eclipse.team.ui.P_CONTEXT_MENU", "change_set_group");
        }
    }

    protected void handleChanges(ISyncInfoTreeChangeEvent event, IProgressMonitor monitor) {
        ISynchronizeModelProvider provider;
        boolean handled = false;
        if (this.checkedInCollector != null && this.getChangeSetCapability().enableCheckedInChangeSetsFor(this.getConfiguration())) {
            this.checkedInCollector.handleChange((ISyncInfoSetChangeEvent)event);
            handled = true;
        }
        if (this.activeCollector != null && this.getChangeSetCapability().enableActiveChangeSetsFor(this.getConfiguration())) {
            this.activeCollector.handleChange((ISyncInfoSetChangeEvent)event);
            handled = true;
        }
        if (!handled && (provider = this.getProviderRootedAt(this.getModelRoot())) != null) {
            SyncInfoSet set = provider.getSyncInfoSet();
            try {
                set.beginInput();
                set.removeAll(event.getRemovedResources());
                SyncInfo[] added = event.getAddedResources();
                int i = 0;
                while (i < added.length) {
                    SyncInfo info = added[i];
                    set.add(info);
                    ++i;
                }
                SyncInfo[] changed = event.getChangedResources();
                int i2 = 0;
                while (i2 < changed.length) {
                    SyncInfo info = changed[i2];
                    set.add(info);
                    ++i2;
                }
            }
            finally {
                set.endInput(monitor);
            }
        }
    }

    protected void handleAddition(SyncInfo info) {
    }

    protected IDiffElement[] buildModelObjects(ISynchronizeModelElement node) {
        if (node == this.getModelRoot()) {
            ISynchronizeModelProvider provider;
            if (this.checkedInCollector != null) {
                this.checkedInCollector.reset(null);
                this.checkedInCollector.removeListener(this.changeSetListener);
            }
            if (this.activeCollector != null) {
                this.activeCollector.setChangeSetChangeListener(null);
                this.activeCollector.reset(null);
            }
            boolean handled = false;
            if (this.checkedInCollector != null && this.getChangeSetCapability().enableCheckedInChangeSetsFor(this.getConfiguration())) {
                this.checkedInCollector.addListener(this.changeSetListener);
                this.checkedInCollector.reset(this.getSyncInfoSet());
                handled = true;
            }
            if (this.activeCollector != null && this.getChangeSetCapability().enableActiveChangeSetsFor(this.getConfiguration())) {
                this.activeCollector.setChangeSetChangeListener(this.changeSetListener);
                this.activeCollector.reset(this.getSyncInfoSet());
                handled = true;
            }
            if (!handled && (provider = this.getProviderRootedAt(this.getModelRoot())) != null) {
                ((SynchronizeModelProvider)provider).getSyncInfoSet().addAll(this.getSyncInfoSet());
            }
        }
        return new IDiffElement[0];
    }

    public ISynchronizeModelProviderDescriptor getDescriptor() {
        return descriptor;
    }

    public ViewerSorter getViewerSorter() {
        if (this.viewerSorter == null) {
            this.viewerSorter = new ChangeSetModelSorter(this, ChangeSetActionGroup.getSortCriteria(this.getConfiguration()));
        }
        return this.viewerSorter;
    }

    public void setViewerSorter(ViewerSorter viewerSorter) {
        this.viewerSorter = viewerSorter;
        this.firePropertyChange("org.eclipse.team.ui.P_VIEWER_SORTER", null, null);
    }

    protected SynchronizePageActionGroup createActionGroup() {
        return new ChangeSetActionGroup(this);
    }

    private ISynchronizeModelProvider createProviderRootedAt(ISynchronizeModelElement parent, SyncInfoTree set) {
        ISynchronizeModelProvider provider = this.createModelProvider(parent, this.getSubproviderId(), set);
        this.addProvider(provider);
        this.rootToProvider.put(parent, provider);
        return provider;
    }

    private ISynchronizeModelProvider getProviderRootedAt(ISynchronizeModelElement parent) {
        return (ISynchronizeModelProvider)this.rootToProvider.get(parent);
    }

    protected void removeProvider(ISynchronizeModelProvider provider) {
        this.rootToProvider.remove(provider.getModelRoot());
        super.removeProvider(provider);
    }

    public String getSubproviderId() {
        return this.subProvierId;
    }

    public ViewerSorter getEmbeddedSorter() {
        return this.embeddedSorter;
    }

    protected void recursiveClearModelObjects(ISynchronizeModelElement node) {
        super.recursiveClearModelObjects(node);
        if (node == this.getModelRoot()) {
            this.rootToProvider.clear();
            this.embeddedSorter = null;
            this.createRootProvider();
        }
    }

    private void createRootProvider() {
        SynchronizePageActionGroup actionGroup;
        SyncInfoTree tree = this.activeCollector != null && this.getChangeSetCapability().enableActiveChangeSetsFor(this.getConfiguration()) ? this.activeCollector.getRootSet() : new SyncInfoTree();
        final ISynchronizeModelProvider provider = this.createProviderRootedAt(this.getModelRoot(), tree);
        this.embeddedSorter = provider.getViewerSorter();
        if (provider instanceof AbstractSynchronizeModelProvider && (actionGroup = ((AbstractSynchronizeModelProvider)provider).getActionGroup()) != null) {
            this.getConfiguration().addActionContribution(actionGroup);
            provider.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("org.eclipse.team.ui.P_VIEWER_SORTER")) {
                        ChangeSetModelProvider.this.embeddedSorter = provider.getViewerSorter();
                        ChangeSetModelProvider.this.firePropertyChange("org.eclipse.team.ui.P_VIEWER_SORTER", null, null);
                    }
                }
            });
        }
    }

    protected ISynchronizeModelElement getModelElement(ChangeSet set) {
        IDiffElement[] children = this.getModelRoot().getChildren();
        int i = 0;
        while (i < children.length) {
            IDiffElement element = children[i];
            if (element instanceof ChangeSetDiffNode && ((ChangeSetDiffNode)element).getSet() == set) {
                return (ISynchronizeModelElement)element;
            }
            ++i;
        }
        return null;
    }

    public ChangeSetCapability getChangeSetCapability() {
        ISynchronizeParticipant participant = this.getConfiguration().getParticipant();
        if (participant instanceof IChangeSetProvider) {
            IChangeSetProvider provider = (IChangeSetProvider)((Object)participant);
            return provider.getChangeSetCapability();
        }
        return null;
    }

    public void dispose() {
        if (this.checkedInCollector != null) {
            this.checkedInCollector.removeListener(this.changeSetListener);
            this.checkedInCollector.dispose();
        }
        if (this.activeCollector != null) {
            this.activeCollector.setChangeSetChangeListener(null);
            this.activeCollector.dispose();
        }
        super.dispose();
    }

    public void waitUntilDone(IProgressMonitor monitor) {
        super.waitUntilDone(monitor);
        if (this.checkedInCollector != null) {
            this.checkedInCollector.waitUntilDone(monitor);
            super.waitUntilDone(monitor);
        }
    }

    void removeModelElementForSet(ChangeSet set) {
        ISynchronizeModelElement node = this.getModelElement(set);
        if (node != null) {
            ISynchronizeModelProvider provider = this.getProviderRootedAt(node);
            this.removeFromViewer(new ISynchronizeModelElement[]{node});
            this.removeProvider(provider);
        }
    }

    public void createChangeSetModelElement(ChangeSet set, SyncInfoTree tree) {
        ISynchronizeModelElement node = this.getModelElement(set);
        ISynchronizeModelProvider provider = null;
        if (node != null) {
            provider = this.getProviderRootedAt(node);
        }
        if (provider == null) {
            provider = this.createProvider(set, tree);
            provider.prepareInput(null);
        }
    }

    private ISynchronizeModelProvider createProvider(ChangeSet set, SyncInfoTree tree) {
        ChangeSetDiffNode node = new ChangeSetDiffNode(this.getModelRoot(), set);
        this.addToViewer(node);
        return this.createProviderRootedAt(node, tree);
    }

    public void refreshLabel(ChangeSet set) {
        ISynchronizeModelElement node = this.getModelElement(set);
        if (node != null) {
            this.getViewer().refresh((Object)node);
        }
    }

    public static class ChangeSetModelProviderDescriptor
    implements ISynchronizeModelProviderDescriptor {
        public static final String ID = "org.eclipse.team.ui.modelprovider_cvs_changelog";

        public String getId() {
            return ID;
        }

        public String getName() {
            return TeamUIMessages.ChangeLogModelProvider_5;
        }

        public ImageDescriptor getImageDescriptor() {
            return TeamUIPlugin.getImageDescriptor("obj/changeset_obj.gif");
        }
    }
}

