/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class OpenResourceAction
extends WorkspaceAction
implements IResourceChangeListener {
    public static final String ID = "org.eclipse.ui.OpenResourceAction";

    public OpenResourceAction(Shell shell) {
        super(shell, IDEWorkbenchMessages.OpenResourceAction_text);
        this.initAction();
    }

    public OpenResourceAction(IShellProvider provider) {
        super(provider, IDEWorkbenchMessages.OpenResourceAction_text);
        this.initAction();
    }

    private void initAction() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.open_resource_action_context");
        this.setToolTipText(IDEWorkbenchMessages.OpenResourceAction_toolTip);
        this.setId(ID);
    }

    private int countClosedProjects() {
        int count = 0;
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (!projects[i].isOpen()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    protected String getOperationMessage() {
        return IDEWorkbenchMessages.OpenResourceAction_operationMessage;
    }

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.OpenResourceAction_problemMessage;
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.OpenResourceAction_dialogTitle;
    }

    private boolean hasOtherClosedProjects() {
        int closedInSelection = 0;
        Iterator resources = this.getSelectedResources().iterator();
        while (resources.hasNext()) {
            IProject project = (IProject)resources.next();
            if (project.isOpen()) continue;
            ++closedInSelection;
        }
        return closedInSelection < this.countClosedProjects();
    }

    protected void invokeOperation(IResource resource, IProgressMonitor monitor) throws CoreException {
        ((IProject)resource).open(monitor);
    }

    private boolean promptToOpenWithReferences() {
        String key;
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String value = store.getString(key = "OPEN_REQUIRED_PROJECTS");
        if ("always".equals(value)) {
            return true;
        }
        if ("never".equals(value)) {
            return false;
        }
        String message = IDEWorkbenchMessages.OpenResourceAction_openRequiredProjects;
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)this.getShell(), (String)IDEWorkbenchMessages.Question, (String)message, null, (boolean)false, (IPreferenceStore)store, (String)key);
        int result = dialog.getReturnCode();
        if (result == 1 || result == -1) {
            throw new OperationCanceledException();
        }
        return dialog.getReturnCode() == 2;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta;
        List sel = this.getSelectedResources();
        if (this.selectionIsOfType(4) && (delta = event.getDelta()) != null) {
            IResourceDelta[] projDeltas = delta.getAffectedChildren(4);
            int i = 0;
            while (i < projDeltas.length) {
                IResourceDelta projDelta = projDeltas[i];
                if ((projDelta.getFlags() & 0x4000) != 0 && sel.contains(projDelta.getResource())) {
                    this.selectionChanged(this.getStructuredSelection());
                    return;
                }
                ++i;
            }
        }
    }

    public void run() {
        try {
            this.runOpenWithReferences();
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    private void runOpenWithReferences() {
        final ArrayList resources = new ArrayList(this.getActionResources());
        WorkspaceJob job = new WorkspaceJob(OpenResourceAction.removeMnemonics((String)this.getText())){
            private boolean openProjectReferences = true;
            private boolean hasPrompted = false;
            private boolean canceled = false;

            private void doOpenWithReferences(IProject project, IProgressMonitor monitor) throws CoreException {
                int i;
                if (!project.exists() || project.isOpen()) {
                    return;
                }
                project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                IProject[] references = project.getReferencedProjects();
                if (!this.hasPrompted) {
                    this.openProjectReferences = false;
                    i = 0;
                    while (i < references.length) {
                        if (references[i].exists() && !references[i].isOpen()) {
                            this.openProjectReferences = true;
                            break;
                        }
                        ++i;
                    }
                    if (this.openProjectReferences && OpenResourceAction.this.hasOtherClosedProjects()) {
                        Display.getDefault().syncExec(new Runnable(this){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                try {
                                    1.access$0(this.this$1, OpenResourceAction.access$1(1.access$3(this.this$1)));
                                }
                                catch (OperationCanceledException operationCanceledException) {
                                    1.access$1(this.this$1, true);
                                }
                                1.access$2(this.this$1, true);
                            }
                        });
                        if (this.canceled) {
                            throw new OperationCanceledException();
                        }
                    }
                }
                if (this.openProjectReferences) {
                    i = 0;
                    while (i < references.length) {
                        this.doOpenWithReferences(references[i], monitor);
                        ++i;
                    }
                }
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask("", OpenResourceAction.this.countClosedProjects() * 1000);
                    monitor.setTaskName(OpenResourceAction.this.getOperationMessage());
                    Iterator it = resources.iterator();
                    while (it.hasNext()) {
                        this.doOpenWithReferences((IProject)it.next(), monitor);
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }

            static /* synthetic */ void access$0(1 var0, boolean bl) {
                var0.openProjectReferences = bl;
            }

            static /* synthetic */ void access$1(1 var0, boolean bl) {
                var0.canceled = bl;
            }

            static /* synthetic */ void access$2(1 var0, boolean bl) {
                var0.hasPrompted = bl;
            }

            static /* synthetic */ OpenResourceAction access$3(1 var0) {
                return var0.OpenResourceAction.this;
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.setUser(true);
        job.schedule();
    }

    protected boolean shouldPerformResourcePruning() {
        return false;
    }

    protected boolean updateSelection(IStructuredSelection s) {
        if (!this.selectionIsOfType(4)) {
            return false;
        }
        Iterator resources = this.getSelectedResources().iterator();
        while (resources.hasNext()) {
            IProject currentResource = (IProject)resources.next();
            if (currentResource.isOpen()) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean access$1(OpenResourceAction openResourceAction) {
        return openResourceAction.promptToOpenWithReferences();
    }
}

