/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.logging;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.rcptt.logging.BaseFileQ7Monitor;
import org.eclipse.rcptt.logging.ConfigurableFileQ7Monitor;
import org.eclipse.rcptt.logging.IQ7Monitor;
import org.eclipse.rcptt.logging.Q7LoggingPlugin;

public class Q7LoggingManager {
    private File rootFile = this.getLogsFile().toFile();
    private static Map<String, IQ7Monitor> monitors = new HashMap<String, IQ7Monitor>();
    private static Q7LoggingManager serverMonitor = new Q7LoggingManager();

    public static Q7LoggingManager getManager() {
        return serverMonitor;
    }

    public Q7LoggingManager() {
        this.rootFile.mkdirs();
    }

    public IPath getLogsFile() {
        return Q7LoggingPlugin.getDefault().getStateLocation();
    }

    public IQ7Monitor getMonitor(String id) {
        return this.getMonitor(id, null, ".log");
    }

    public static IQ7Monitor get(String id) {
        return Q7LoggingManager.getManager().getMonitor(id);
    }

    public static IQ7Monitor get(String id, String prefix, String pipe) {
        return Q7LoggingManager.getManager().getMonitor(id, prefix, pipe);
    }

    public synchronized IQ7Monitor getMonitor(String id, String prefix, String pipeName) {
        String key = String.valueOf(id) + ":" + pipeName;
        if (monitors.containsKey(key)) {
            return monitors.get(key);
        }
        File child = new File(this.rootFile, String.valueOf(prefix != null ? String.valueOf(prefix) + "/" : "") + Q7LoggingManager.getID(id));
        if (!child.exists()) {
            child.mkdirs();
        }
        ConfigurableFileQ7Monitor monitor = new ConfigurableFileQ7Monitor(id, prefix, child, pipeName);
        monitors.put(key, monitor);
        return monitor;
    }

    public static String getCurrentDate() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        String idValue = formatter.format(new Date(System.currentTimeMillis()));
        return idValue;
    }

    public synchronized IQ7Monitor getNewMonitor(String prefix, String base) {
        String key;
        File child;
        do {
            key = String.valueOf(base) + Q7LoggingManager.getCurrentDate();
        } while ((child = new File(this.rootFile, String.valueOf(prefix != null ? String.valueOf(prefix) + "/" : "") + Q7LoggingManager.getID(key))).exists());
        child.mkdirs();
        ConfigurableFileQ7Monitor monitor = new ConfigurableFileQ7Monitor(key, prefix, child, ".log");
        monitors.put(String.valueOf(key) + ":.log", monitor);
        return monitor;
    }

    public static IQ7Monitor newMonitor(String prefix, String base) {
        return Q7LoggingManager.getManager().getNewMonitor(prefix, base);
    }

    public static IQ7Monitor getChild(IQ7Monitor monitor, String uri) {
        IQ7Monitor result = Q7LoggingManager.getManager().getMonitor(monitor.getId(), monitor.getPrefix(), uri);
        monitor.putChild(result);
        return result;
    }

    public static String getID(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder textResult = new StringBuilder();
        char[] cArray = value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isLetterOrDigit(c)) {
                textResult.append('_');
            } else {
                textResult.append(c);
            }
            ++n2;
        }
        return textResult.toString();
    }

    synchronized void remove(BaseFileQ7Monitor simpleFileQ7Monitor) {
        String removeID = null;
        for (Map.Entry<String, IQ7Monitor> e : monitors.entrySet()) {
            if (!e.getValue().equals(simpleFileQ7Monitor)) continue;
            removeID = e.getKey();
            break;
        }
        if (removeID != null) {
            monitors.remove(removeID);
        }
    }

    public static void logMessage(String id, String message) {
        Q7LoggingManager.get(id).log(message, null);
    }

    public static void logMessage(String id, String message, Exception e) {
        Q7LoggingManager.get(id).log(message, e);
    }
}

