/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting.internal;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.reporting.core.IReportRenderer;
import org.eclipse.rcptt.reporting.internal.Q7ReportingPlugin;
import org.eclipse.rcptt.reporting.internal.XMLReportGenerator;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.util.FileUtil;
import org.eclipse.rcptt.util.StringUtils;

public class XmlSplitReportGenerator
implements IReportRenderer {
    @Override
    public IStatus generateReport(IReportRenderer.IContentFactory factory, String reportName, Iterable<Report> reports) {
        try {
            factory.removeFileOrFolder(reportName);
            factory = factory.createFolder(reportName);
            for (Report test : reports) {
                XmlSplitReportGenerator.writeContents(factory.createFileStream(XmlSplitReportGenerator.getFileName(test.getRoot().getName(), factory)), new XMLReportGenerator().generateContent(test));
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    @Override
    public String[] getGeneratedFileNames(String reportName) {
        return new String[]{reportName};
    }

    private static void writeContents(OutputStream out, String contents) {
        try {
            out.write(StringUtils.getUtf8Bytes((String)contents));
            out.close();
        }
        catch (IOException e) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
            Q7ReportingPlugin.log(e);
        }
    }

    private static String getFileName(String name, IReportRenderer.IContentFactory content) {
        String result;
        int count = 0;
        String escapedName = FileUtil.escapeFileName((String)name, null);
        while (content.isFileExist(result = XmlSplitReportGenerator.getFileName(escapedName, "xml", count++))) {
        }
        return result;
    }

    private static String getFileName(String baseName, String extension, int count) {
        if (count == 0) {
            return String.format("%s.%s", baseName, extension);
        }
        return String.format("%s (%d).%s", baseName, count, extension);
    }
}

