/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring;

import java.util.List;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.tags.Tag;
import org.eclipse.rcptt.core.tags.TagsRegistry;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;

public class RefactoringUtils {
    public static String elementToString(IQ7NamedElement element) {
        try {
            if (element instanceof ITestCase) {
                return NLS.bind((String)Messages.RefactoringUtils_TestCase, (Object)element.getElementName());
            }
            if (element instanceof IContext) {
                return NLS.bind((String)Messages.RefactoringUtils_Context, (Object)element.getElementName());
            }
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
        }
        return NLS.bind((String)Messages.RefactoringUtils_Element, (Object)element.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RefactoringStatus validateTagInSync(Tag tag) {
        TagsRegistry registry;
        TagsRegistry tagsRegistry = registry = Q7UIPlugin.getDefault().getTags();
        synchronized (tagsRegistry) {
            if (RefactoringUtils.containTag((List<Tag>)registry.getTags(), tag)) {
                return new RefactoringStatus();
            }
        }
        return RefactoringStatus.createErrorStatus((String)NLS.bind((String)Messages.RefactoringUtils_TagOutOfSyncMsg, (Object)tag.getPath()));
    }

    private static boolean containTag(List<Tag> tags, Tag target) {
        if (tags.contains(target)) {
            return true;
        }
        for (Tag t : tags) {
            if (!RefactoringUtils.containTag((List<Tag>)t.getTags(), target)) continue;
            return true;
        }
        return false;
    }

    private RefactoringUtils() {
        throw new AssertionError();
    }
}

