/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.egit.ui.internal.history.SWTCommitList;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.osgi.util.NLS;

class GenerateHistoryJob
extends Job {
    private static final int BATCH_SIZE = 256;
    private final int maxCommits = Activator.getDefault().getPreferenceStore().getInt("HistoryView_MaxNumberOfCommmits");
    private final GitHistoryPage page;
    private final SWTCommitList allCommits;
    private int lastUpdateCnt;
    private long lastUpdateAt;
    private boolean trace;

    GenerateHistoryJob(GitHistoryPage ghp, SWTCommitList list) {
        super(NLS.bind((String)UIText.HistoryPage_refreshJob, (Object)Activator.getDefault().getRepositoryUtil().getRepositoryName(ghp.getInputInternal().getRepository())));
        this.page = ghp;
        this.allCommits = list;
        this.trace = GitTraceLocation.HISTORYVIEW.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        boolean incomplete = false;
        try {
            if (this.trace) {
                GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
            }
            this.page.setErrorMessage(NLS.bind((String)UIText.GenerateHistoryJob_BuildingListMessage, (Object)this.page.getName()));
            while (true) {
                int oldsz;
                try {
                    oldsz = this.allCommits.size();
                    if (this.trace) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.HISTORYVIEW.getLocation(), "Filling commit list");
                    }
                    SWTCommitList sWTCommitList = this.allCommits;
                    synchronized (sWTCommitList) {
                        this.allCommits.fillTo(oldsz + 256 - 1);
                    }
                    if (monitor.isCanceled()) {
                        this.page.setErrorMessage(NLS.bind((String)UIText.GenerateHistoryJob_CancelMessage, (Object)this.page.getName()));
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                }
                catch (IOException e) {
                    status = new Status(4, Activator.getPluginId(), UIText.GenerateHistoryJob_errorComputingHistory, (Throwable)e);
                    break;
                }
                {
                    if (this.allCommits.size() == 0) {
                        this.page.setErrorMessage(NLS.bind((String)UIText.GenerateHistoryJob_NoCommits, (Object)this.page.getName()));
                        break;
                    }
                    if (this.maxCommits > 0 && this.allCommits.size() > this.maxCommits) {
                        incomplete = true;
                    }
                    if (incomplete || oldsz == this.allCommits.size()) break;
                    monitor.setTaskName(NLS.bind((String)"Found {0} commits", (Object)this.allCommits.size()));
                    long now = System.currentTimeMillis();
                    if (now - this.lastUpdateAt < 2000L && this.lastUpdateCnt > 0) continue;
                    this.updateUI(incomplete);
                    this.lastUpdateAt = now;
                    continue;
                }
                break;
            }
            this.updateUI(incomplete);
            return status;
        }
        finally {
            monitor.done();
            if (this.trace) {
                GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
            }
        }
    }

    void updateUI(boolean incomplete) {
        if (this.trace) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
        }
        try {
            if (!incomplete && this.allCommits.size() == this.lastUpdateCnt) {
                return;
            }
            SWTCommit[] asArray = new SWTCommit[this.allCommits.size()];
            this.allCommits.toArray((Object[])asArray);
            this.page.showCommitList(this, this.allCommits, asArray, incomplete);
            this.lastUpdateCnt = this.allCommits.size();
        }
        finally {
            if (this.trace) {
                GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
            }
        }
    }

    public boolean belongsTo(Object family) {
        if (family.equals(JobFamilies.GENERATE_HISTORY)) {
            return true;
        }
        return super.belongsTo(family);
    }
}

