/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.util.SmallFloat;

public abstract class Similarity
implements Serializable {
    public static final int NO_DOC_ID_PROVIDED = -1;
    private static final float[] NORM_TABLE = new float[256];
    private final MethodSupport supportedMethods = Similarity.getSupportedMethods(this.getClass());
    private static final IdentityHashMap knownMethodSupport;
    private static Similarity defaultImpl;
    static /* synthetic */ Class class$org$apache$lucene$search$Similarity;
    static /* synthetic */ Class class$org$apache$lucene$index$Term;
    static /* synthetic */ Class class$org$apache$lucene$search$Searcher;
    static /* synthetic */ Class class$java$util$Collection;

    public static void setDefault(Similarity similarity) {
        defaultImpl = similarity;
    }

    public static Similarity getDefault() {
        return defaultImpl;
    }

    public static float decodeNorm(byte b) {
        return NORM_TABLE[b & 0xFF];
    }

    public static float[] getNormDecoder() {
        return NORM_TABLE;
    }

    public float computeNorm(String field, FieldInvertState state) {
        return state.getBoost() * this.lengthNorm(field, state.getLength());
    }

    public abstract float lengthNorm(String var1, int var2);

    public abstract float queryNorm(float var1);

    public static byte encodeNorm(float f) {
        return SmallFloat.floatToByte315(f);
    }

    public float tf(int freq) {
        return this.tf((float)freq);
    }

    public abstract float sloppyFreq(int var1);

    public abstract float tf(float var1);

    public float idf(Term term, Searcher searcher) throws IOException {
        return this.idf(searcher.docFreq(term), searcher.maxDoc());
    }

    public Explanation.IDFExplanation idfExplain(Term term, Searcher searcher) throws IOException {
        if (this.supportedMethods.overridesTermIDF) {
            final float idf = this.idf(term, searcher);
            return new Explanation.IDFExplanation(){

                public float getIdf() {
                    return idf;
                }

                public String explain() {
                    return "Inexplicable";
                }
            };
        }
        final int df = searcher.docFreq(term);
        final int max = searcher.maxDoc();
        final float idf = this.idf(df, max);
        return new Explanation.IDFExplanation(){

            public String explain() {
                return "idf(docFreq=" + df + ", maxDocs=" + max + ")";
            }

            public float getIdf() {
                return idf;
            }
        };
    }

    public float idf(Collection terms, Searcher searcher) throws IOException {
        float idf = 0.0f;
        Iterator i = terms.iterator();
        while (i.hasNext()) {
            idf += this.idf((Term)i.next(), searcher);
        }
        return idf;
    }

    public Explanation.IDFExplanation idfExplain(Collection terms, Searcher searcher) throws IOException {
        if (this.supportedMethods.overridesCollectionIDF) {
            final float idf = this.idf(terms, searcher);
            return new Explanation.IDFExplanation(){

                public float getIdf() {
                    return idf;
                }

                public String explain() {
                    return "Inexplicable";
                }
            };
        }
        int max = searcher.maxDoc();
        float idf = 0.0f;
        final StringBuffer exp = new StringBuffer();
        Iterator i = terms.iterator();
        while (i.hasNext()) {
            Term term = (Term)i.next();
            int df = searcher.docFreq(term);
            idf += this.idf(df, max);
            exp.append(" ");
            exp.append(term.text());
            exp.append("=");
            exp.append(df);
        }
        final float fIdf = idf;
        return new Explanation.IDFExplanation(){

            public float getIdf() {
                return fIdf;
            }

            public String explain() {
                return exp.toString();
            }
        };
    }

    public abstract float idf(int var1, int var2);

    public abstract float coord(int var1, int var2);

    public float scorePayload(String fieldName, byte[] payload, int offset, int length) {
        return 1.0f;
    }

    public float scorePayload(int docId, String fieldName, int start, int end, byte[] payload, int offset, int length) {
        return this.scorePayload(fieldName, payload, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MethodSupport getSupportedMethods(Class clazz) {
        MethodSupport supportedMethods;
        IdentityHashMap identityHashMap = knownMethodSupport;
        synchronized (identityHashMap) {
            supportedMethods = (MethodSupport)knownMethodSupport.get(clazz);
            if (supportedMethods == null) {
                supportedMethods = new MethodSupport(clazz);
                knownMethodSupport.put(clazz, supportedMethods);
            }
        }
        return supportedMethods;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            Similarity.NORM_TABLE[i] = SmallFloat.byte315ToFloat((byte)i);
        }
        knownMethodSupport = new IdentityHashMap();
        defaultImpl = new DefaultSimilarity();
    }

    private static final class MethodSupport
    implements Serializable {
        final boolean overridesCollectionIDF;
        final boolean overridesTermIDF;
        private static final Class[] T_IDF_METHOD_PARAMS = new Class[]{class$org$apache$lucene$index$Term == null ? (class$org$apache$lucene$index$Term = Similarity.class$("org.apache.lucene.index.Term")) : class$org$apache$lucene$index$Term, class$org$apache$lucene$search$Searcher == null ? (class$org$apache$lucene$search$Searcher = Similarity.class$("org.apache.lucene.search.Searcher")) : class$org$apache$lucene$search$Searcher};
        private static final Class[] C_IDF_METHOD_PARAMS = new Class[]{class$java$util$Collection == null ? (class$java$util$Collection = Similarity.class$("java.util.Collection")) : class$java$util$Collection, class$org$apache$lucene$search$Searcher == null ? (class$org$apache$lucene$search$Searcher = Similarity.class$("org.apache.lucene.search.Searcher")) : class$org$apache$lucene$search$Searcher};

        MethodSupport(Class clazz) {
            this.overridesCollectionIDF = MethodSupport.isMethodOverridden(clazz, "idf", C_IDF_METHOD_PARAMS);
            this.overridesTermIDF = MethodSupport.isMethodOverridden(clazz, "idf", T_IDF_METHOD_PARAMS);
        }

        private static boolean isMethodOverridden(Class clazz, String name, Class[] params) {
            try {
                return clazz.getMethod(name, params).getDeclaringClass() != (class$org$apache$lucene$search$Similarity == null ? (class$org$apache$lucene$search$Similarity = Similarity.class$("org.apache.lucene.search.Similarity")) : class$org$apache$lucene$search$Similarity);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

