/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.workbench.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rcptt.core.IContextProcessor;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.core.scenario.ScenarioFactory;
import org.eclipse.rcptt.core.scenario.WorkbenchContext;
import org.eclipse.rcptt.ctx.workbench.impl.Activator;
import org.eclipse.rcptt.ctx.workbench.impl.ResourcesSupport;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.tesla.core.TeslaLimits;
import org.eclipse.rcptt.tesla.ecl.impl.UIRunnable;
import org.eclipse.rcptt.tesla.ecl.impl.Utils;
import org.eclipse.rcptt.tesla.internal.ui.player.UIJobCollector;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.osgi.framework.Bundle;

public class WorkbenchContextProcessor
implements IContextProcessor {
    private UIRunnable<IStatus> closeModalDialogs = new UIRunnable<IStatus>(){

        public IStatus run() throws CoreException {
            try {
                return Utils.closeDialogs();
            }
            catch (Throwable e) {
                return RcpttPlugin.createStatus((Throwable)e);
            }
        }
    };
    private Runnable closeModalDialogsAsync = new Runnable(){

        @Override
        public void run() {
            Utils.closeDialogs();
        }
    };
    private UIRunnable<Object> closeIntro = new UIRunnable<Object>(){

        public Object run() throws CoreException {
            IIntroPart intro;
            IIntroManager manager = PlatformUI.getWorkbench().getIntroManager();
            if (manager != null && (intro = manager.getIntro()) != null) {
                manager.closeIntro(intro);
            }
            return null;
        }
    };
    private UIRunnable<Object> clearClipboard = new UIRunnable<Object>(){

        public Object run() throws CoreException {
            Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());
            clipboard.setContents(new Object[]{" "}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.clearContents();
            return null;
        }
    };

    public boolean isApplied(final Context context) {
        return (Boolean)UIRunnable.safeExec((UIRunnable)new UIRunnable<Boolean>(){

            public Boolean run() throws CoreException {
                IPerspectiveDescriptor descriptor;
                IWorkbenchPage page;
                IWorkbenchWindow window = WorkbenchContextProcessor.this.getWindow();
                if (window != null && (page = window.getActivePage()) != null && (descriptor = page.getPerspective()) != null) {
                    return descriptor.getId().equals(WorkbenchContextProcessor.this.getPerspectiveId(context));
                }
                return false;
            }
        });
    }

    public boolean isCreateAllowed() {
        return true;
    }

    public void apply(Context context) throws CoreException {
        WorkbenchContext ctx = (WorkbenchContext)context;
        final UIJobCollector collector = new UIJobCollector();
        Job.getJobManager().addJobChangeListener((IJobChangeListener)collector);
        try {
            try {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        collector.enable();
                    }
                });
                if (ctx.isNoModalDialogs()) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(this.closeModalDialogsAsync);
                    UIRunnable.exec(this.closeModalDialogs);
                    PlatformUI.getWorkbench().getDisplay().asyncExec(this.closeModalDialogsAsync);
                    IStatus status = (IStatus)UIRunnable.exec(this.closeModalDialogs);
                    if (!status.isOK()) {
                        throw new CoreException(status);
                    }
                }
                UIRunnable.exec(this.closeIntro);
                IWorkbenchPage page = (IWorkbenchPage)UIRunnable.exec(this.activatePerspective(ctx));
                if (ctx.isCloseEditors() && page != null) {
                    UIRunnable.exec(this.closeAllEditors(page));
                }
                if (ctx.isClearClipboard()) {
                    UIRunnable.exec(this.clearClipboard);
                }
                String perspectiveId = this.getPerspectiveId((Context)ctx);
                if (page != null && perspectiveId != null && perspectiveId.length() > 0 && ctx.isResetPerspective()) {
                    List<IPerspectiveDescriptor> descriptors = Arrays.asList(page.getSortedPerspectives());
                    for (IPerspectiveDescriptor desc : descriptors) {
                        this.setPageInput(page, this.getDefaultPageInput());
                        UIRunnable.exec(this.closePerspective(page, desc));
                    }
                    UIRunnable.exec(this.cleanOtherPerspectives(page));
                }
                UIRunnable.exec(this.setPerspective(ctx, page));
                this.openParts(ctx);
                this.updateSelection(ctx);
                UIRunnable.exec((UIRunnable)new UIRunnable<Object>(){

                    public Object run() throws CoreException {
                        collector.setNeedDisable();
                        return null;
                    }
                });
                collector.join(TeslaLimits.getContextJoinTimeout());
            }
            catch (Exception e) {
                CoreException ee = new CoreException(RcpttPlugin.createStatus((String)("Failed to execute context: " + ctx.getName() + " Cause: " + e.getMessage()), (Throwable)e));
                RcpttPlugin.log((Throwable)e);
                throw ee;
            }
        }
        finally {
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)collector);
        }
    }

    private void updateSelection(WorkbenchContext ctx) {
        IWorkbenchWindow[] windows;
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage[] pages;
            IWorkbenchWindow win = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = pages = win.getPages();
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IViewReference[] references;
                IWorkbenchPage page0 = iWorkbenchPageArray[n4];
                IViewReference[] iViewReferenceArray = references = page0.getViewReferences();
                int n5 = references.length;
                int n6 = 0;
                while (n6 < n5) {
                    ISelectionProvider provider;
                    IWorkbenchPart part;
                    IViewReference ref = iViewReferenceArray[n6];
                    if (ctx.getViews().contains((Object)ref.getId()) && (part = ref.getPart(false)) != null && (provider = part.getSite().getSelectionProvider()) != null) {
                        try {
                            UIRunnable.exec(this.setSelection(provider));
                        }
                        catch (Throwable e) {
                            RcpttPlugin.log((Throwable)e);
                        }
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private UIRunnable<Object> setSelection(final ISelectionProvider provider) {
        return new UIRunnable<Object>(){

            public Object run() throws CoreException {
                provider.setSelection((ISelection)new StructuredSelection());
                return null;
            }
        };
    }

    private UIRunnable<Object> setPerspective(final WorkbenchContext ctx, final IWorkbenchPage page) {
        return new UIRunnable<Object>(){

            public Object run() throws CoreException {
                WorkbenchContextProcessor.this.showPerspective(ctx);
                if (page != null && page.getSortedPerspectives().length == 0) {
                    String defaultPerspectiveId = PlatformUI.getWorkbench().getPerspectiveRegistry().getDefaultPerspective();
                    IPerspectiveDescriptor perspectiveDesc = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(defaultPerspectiveId);
                    page.setPerspective(perspectiveDesc);
                }
                return null;
            }
        };
    }

    private UIRunnable<Object> cleanOtherPerspectives(final IWorkbenchPage page) {
        return new UIRunnable<Object>(){

            public Object run() throws CoreException {
                IPerspectiveDescriptor[] iPerspectiveDescriptorArray = page.getWorkbenchWindow().getWorkbench().getPerspectiveRegistry().getPerspectives();
                int n = iPerspectiveDescriptorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPerspectiveDescriptor persp = iPerspectiveDescriptorArray[n2];
                    Bundle bundle = Platform.getBundle((String)"org.eclipse.osgi");
                    bundle.getVersion();
                    IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
                    store.setToDefault(String.valueOf(persp.getId()) + "_persp");
                    ++n2;
                }
                return null;
            }
        };
    }

    private UIRunnable<Object> closePerspective(final IWorkbenchPage page, final IPerspectiveDescriptor desc) {
        return new UIRunnable<Object>(){

            public Object run() throws CoreException {
                try {
                    page.closePerspective(desc, false, false);
                }
                catch (Throwable e) {
                    RcpttPlugin.log((Throwable)e);
                }
                return null;
            }
        };
    }

    private UIRunnable<Object> closeAllEditors(final IWorkbenchPage page) {
        return new UIRunnable<Object>(){

            public Object run() throws CoreException {
                page.closeAllEditors(false);
                return null;
            }
        };
    }

    private UIRunnable<IWorkbenchPage> activatePerspective(final WorkbenchContext ctx) {
        return new UIRunnable<IWorkbenchPage>(){

            public IWorkbenchPage run() throws CoreException {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage lpage = window.getActivePage();
                if (lpage == null) {
                    lpage = WorkbenchContextProcessor.this.showPerspective(ctx);
                }
                return lpage;
            }
        };
    }

    private Object getDefaultPageInput() {
        try {
            return ResourcesSupport.getWorkspaceRoot();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected void setPageInput(IWorkbenchPage page, Object value) {
        try {
            Field field = WorkbenchPage.class.getDeclaredField("input");
            field.setAccessible(true);
            field.set(page, value);
        }
        catch (SecurityException e) {
            Activator.log(e);
        }
        catch (NoSuchFieldException e) {
            Activator.log(e);
        }
        catch (IllegalArgumentException e) {
            Activator.log(e);
        }
        catch (IllegalAccessException e) {
            Activator.log(e);
        }
    }

    public Context create(EObject param) throws CoreException {
        return (Context)UIRunnable.exec((UIRunnable)new UIRunnable<WorkbenchContext>(){

            public WorkbenchContext run() throws CoreException {
                return WorkbenchContextProcessor.this.doCreate();
            }
        });
    }

    private IWorkbenchPage showPerspective(WorkbenchContext context) throws CoreException {
        IWorkbenchPage activePage;
        IWorkbench workbench = PlatformUI.getWorkbench();
        String perspective = this.getPerspectiveId((Context)context);
        IWorkbenchWindow window = this.getWindow();
        if (perspective != null && perspective.length() > 0) {
            return workbench.showPerspective(perspective, window);
        }
        if (window == null) {
            window = workbench.getWorkbenchWindows()[0];
        }
        if ((activePage = window.getActivePage()) == null) {
            IWorkbenchPage[] pages;
            IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchPage page;
                activePage = page = iWorkbenchPageArray[n2];
                ++n2;
            }
        }
        return activePage;
    }

    private void openParts(WorkbenchContext context) throws CoreException {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        final IWorkbenchPage page = (IWorkbenchPage)UIRunnable.exec((UIRunnable)new UIRunnable<IWorkbenchPage>(){

            public IWorkbenchPage run() throws CoreException {
                IWorkbenchPage[] pages;
                IWorkbenchPage activePage;
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window == null) {
                    window = workbench.getWorkbenchWindows()[0];
                }
                if ((activePage = window.getActivePage()) == null && (pages = window.getPages()).length > 0) {
                    activePage = pages[0];
                }
                return activePage;
            }
        });
        if (page != null) {
            for (final String viewId : context.getViews()) {
                IViewReference[] references = page.getViewReferences();
                boolean found = false;
                IViewReference[] iViewReferenceArray = references;
                int n = references.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference iViewReference = iViewReferenceArray[n2];
                    if (viewId.equals(iViewReference.getId())) {
                        found = true;
                        break;
                    }
                    ++n2;
                }
                if (found) continue;
                UIRunnable.exec((UIRunnable)new UIRunnable<Object>(){

                    public Object run() throws CoreException {
                        page.showView(viewId);
                        return null;
                    }
                });
            }
            if (context.isCloseEditors()) {
                UIRunnable.exec((UIRunnable)new UIRunnable<Object>(){

                    public Object run() throws CoreException {
                        page.closeAllEditors(false);
                        return null;
                    }
                });
            }
            try {
                ResourcesSupport.openEditors(page, context);
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Throwable throwable) {}
        }
    }

    private WorkbenchContext doCreate() throws CoreException {
        IWorkbenchWindow window = this.getWindow();
        IWorkbenchPage page = window.getActivePage();
        WorkbenchContext context = ScenarioFactory.eINSTANCE.createWorkbenchContext();
        IPerspectiveDescriptor descriptor = page.getPerspective();
        if (descriptor != null) {
            context.setPerspectiveId(descriptor.getId());
        }
        IViewReference[] views = page.getViewReferences();
        List<IViewReference> viewReference = this.sortViewsByActive(page, views);
        for (IViewReference view : viewReference) {
            context.getViews().add((Object)view.getId());
        }
        ResourcesSupport.fillEditors(page, context);
        return context;
    }

    private List<IViewReference> sortViewsByActive(IWorkbenchPage page, IViewReference[] viewReferences) {
        ArrayList<IViewReference> references = new ArrayList<IViewReference>();
        ArrayList<IViewReference> referencesToSort = new ArrayList<IViewReference>();
        IViewReference[] iViewReferenceArray = viewReferences;
        int n = viewReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference reference = iViewReferenceArray[n2];
            if (reference.getView(false) == null) {
                references.add(reference);
            } else {
                referencesToSort.add(reference);
            }
            ++n2;
        }
        this.sortViewsByActive(page, referencesToSort);
        references.addAll(referencesToSort);
        return references;
    }

    private void sortViewsByActive(IWorkbenchPage page, List<IViewReference> viewReferences) {
        ArrayList<IViewReference> sorted = new ArrayList<IViewReference>();
        while (!viewReferences.isEmpty()) {
            IViewReference viewReference = viewReferences.get(0);
            IViewPart viewPart = viewReference.getView(false);
            IViewPart[] stack = page.getViewStack(viewPart);
            if (stack == null) {
                sorted.add(viewReference);
                continue;
            }
            int i = stack.length - 1;
            while (i >= 0) {
                IViewPart stackPart = stack[i];
                IViewReference target = null;
                for (IViewReference r : viewReferences) {
                    if (!r.getView(false).equals(stackPart)) continue;
                    target = r;
                    break;
                }
                if (target != null) {
                    viewReferences.remove(target);
                    sorted.add(target);
                }
                --i;
            }
        }
        viewReferences.addAll(sorted);
    }

    private IWorkbenchWindow getWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    private String getPerspectiveId(Context context) {
        WorkbenchContext pContext = (WorkbenchContext)context;
        return pContext.getPerspectiveId();
    }
}

